<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<!-- xcConfirm的css -->
<link rel="stylesheet" href="${pageContext.request.contextPath}/lib/plug/xcConfirm/css/xcConfirm.css">
<script type="text/javascript" src="${pageContext.request.contextPath}/lib/js/jquery-1.8.2.min.js"></script>
<!-- xcConfirm的js -->
<script src="${pageContext.request.contextPath}/lib/plug/xcConfirm/js/xcConfirm.js"></script>
<!-- 调用api时的js -->
<script type="text/javascript" src="${pageContext.request.contextPath}/jwapp/common/js/lang_json.js"></script>
<script type="text/javascript" src="${pageContext.request.contextPath}/jwapp/pages/apps/js/jwAppAppsModule.js" charset="utf-8"></script>
<script type="text/javascript">
var ctx='${pageContext.request.contextPath}';
</script>
<style>
body{
	font-size: 14px;
	color: #333;
	font-family:"Microsoft YaHei";	
}
a{
	color:inherit;
	text-decoration:none !important;
}
*{
	box-sizing:border-box;
	-moz-box-sizing:border-box; /* Firefox */
	-webkit-box-sizing:border-box; /* Safari */
}
.index_application_header{
	overflow:hidden;
}
.index_application_header_left{
	float:left;
}
.index_application_header_left>img{
    vertical-align: bottom;
}
.index_application_header_left>span{
	font-size:25px;
	font-weight:bold;
}
.index_application_header_right{
	float:right;
	height:35px;
    border: 2px solid #1887f6;
    border-radius: 5px;
    background: #1887f6;
}
.index_application_header_right>input{
    height: 31px;
	border:none;
	line-height:31px;
	padding-left:10px;
	width:200px;
	outline:none;
}
.index_application_header_right>div{
    float: right;
    width: 50px;
    cursor: pointer;
    text-align: center;
    padding-top: 6px;
}
.index_application{
	box-shadow:0 0 5px #af9d9d;
	margin-top:30px;
	overflow:hidden;
}
.index_application_left{
	float:left;
	background:#eee;
	width:250px;
	border-right:1px solid #ccc;
	margin-bottom: -1000px;
    padding-bottom: 1000px;
}	
.index_application_left>div{
    border-bottom: 1px solid #ccc;
    height: 50px;
    padding: 0px 20px 0;
    line-height: 50px;
    cursor:pointer;
}
.index_application_left>div>span:first-child{
	font-size:16px;
}
.index_application_left>div>span:first-child+span{
	float:right;
}
.index_application_left>div:hover{
	background:white;
}
.index_application_left_click{
	background:white;	
}
.index_application_right{
	margin-left:270px;
	margin-bottom: -1000px;
    padding-bottom: 1000px;
    margin-top:20px;
}
.index_application_show_tabs{
	height:30px;
	border-bottom:1px solid #ccc;
}
.index_application_show_tabs>span{
	display: inline-block;
	height:30px;
	line-height:30px;
	padding:0 10px;
	text-align: center;
	margin-right:15px;
	background:#eee;
	border-top:1px solid #ccc;
	border-left:1px solid #ccc;
	border-right:1px solid #ccc;
	cursor:pointer;
}
.index_application_show_tabs>span:hover{
	background:white;
}
.index_application_show_tabs_click{
	background:white !important;
}
.index_application_show_tabs_content{
	margin-top:30px;
}
.index_application_show_tabs_content>div{
    display: inline-block;
    width: 150px;
    height: 160px;
    box-shadow: 7px 7px 5px #af9d9d;
    margin-left: 30px;
    margin-bottom: 30px;
    border: 1px solid #ccc;
    border-radius:5px;
    padding:3px;
    background:white;
    vertical-align: top;
}
.index_application_show_tabs_content_div{
	border:1px solid #ccc;
	border-radius:5px;
	background:#eee;
	position:relative;
	height:100%;
}
.index_application_show_tabs_content_div>div:first-child{
    border-radius: 10px;
    width: 60px;
    height: 60px;
    margin: 10px auto 5px;
    border-radius: 10px;
}
.index_application_show_tabs_content_div>div:first-child>img{
	border-radius:13px;
}
.index_application_show_tabs_content_text{
	text-align:center;
	white-space: nowrap;
	overflow: hidden;
	text-overflow: ellipsis;	
	padding: 0 15px;
	font-weight:bold;
}
.index_application_show_tabs_content_img{
	background: #B50000;
    height: 30px;
    line-height: 28px;
    text-align: center;
    color: white;
    margin-top: 5px;
    cursor: pointer;
}
.index_application_show_tabs_content_img:hover{
	opacity:0.8;
}
.index_application_show_tabs_content_img>img{
	vertical-align: sub;
	margin-right:5px;
}
</style>

<div class="index_application_header">
	<div class="index_application_header_left">
		<img src="${ctx}/custom/images/index_application.png" width="32" height="32"/>
		<span>应用中心</span>
	</div>
	<div class="index_application_header_right">
		<input type="text" placeholder="搜索应用" oninput="">
		<div onclick="index_application_search()"><img src="${ctx}/custom/images/index4_search.png" height="22" /></div>
	</div>
</div>
<div class="index_application">
	<div class="index_application_left">
		<div class="index_application_left_click">
			<span>全部应用</span>
			<span>></span>
		</div>
		<div>
			<span>未安装</span>
			<span>></span>
		</div>
		<div>
			<span>已安装</span>
			<span>></span>
		</div>
	</div>
	<div class="index_application_right">
		<div class="index_application_show">
			<div class="index_application_show_tabs">
				<!-- <span class="index_application_show_tabs_click">全部应用</span><span>教学类</span><span>管理类</span><span>服务类</span><span>娱乐类</span><span>默认应用</span> -->
			</div>
			<div class="index_application_show_tabs_container">

				<div class="index_application_show_tabs_content">
					<%-- <div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_unLoad.png" width="16" height="16"/><span>卸载</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" style="background:#1887f6;" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_load.png" width="16" height="16"/><span>安装</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_unLoad.png" width="16" height="16"/><span>卸载</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" style="background:#1887f6;" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_load.png" width="16" height="16"/><span>安装</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_unLoad.png" width="16" height="16"/><span>卸载</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" style="background:#1887f6;" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_load.png" width="16" height="16"/><span>安装</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_unLoad.png" width="16" height="16"/><span>卸载</span></div>
						</div>
					</div>
					<div>
						<div class="index_application_show_tabs_content_div">
							<div><img SRC="${ctx}/custom/images/index_application_img.png" width="40" height="40"/></div>
							<div class="index_application_show_tabs_content_text">组织结构组织结构</div>
							<div class="index_application_show_tabs_content_text">(用户安装)</div>
							<div class="index_application_show_tabs_content_img" style="background:#1887f6;" onclick="index_application_isLoad(this)"><img src="${ctx}/custom/images/index_application_load.png" width="16" height="16"/><span>安装</span></div>
						</div>
					</div> --%>				
				</div>
					
			</div>
			<!-- end -->
		</div>
	</div>
</div>

<script>

//全局变量所有的应用
var list_allApps = jwAppAppsModel.jwAppsAppsDataAction.list_allApps_by_user({FIELD_COLUMN_ID:$('.layout_center_navClick').data('uuid')});

$(function(){
	
	//初始化类别
	init_index_categorys();
	
	//初始化apps
	init_index_apps();
	
	//左边导航的切换
	$('.index_application_left>div').bind('click',function(){
		$('.index_application_left_click').toggleClass('index_application_left_click');
		$(this).addClass('index_application_left_click');
		//apps的切换
		index_application_toggle();
	})
	
	//右边导航的切换
	$('.index_application_show_tabs>span').bind('click',function(){
		$('.index_application_show_tabs_click').toggleClass('index_application_show_tabs_click');
		$(this).addClass('index_application_show_tabs_click');
		//apps的切换
		index_application_toggle();
	})
		
	//搜索时回车触发的事件
	$(".index_application_header_right>input").bind("keydown",function(e){
	　　// 兼容FF和IE和Opera
	　　var theEvent = e || window.event;
	　　var code = theEvent.keyCode || theEvent.which || theEvent.charCode;
	　　 if (code == 13) {
		　　//回车执行查询
		　　index_application_search();
	　　}
	});
})

//安装或者卸载
function index_application_isLoad(handler){
		var txt;
		var option;
		if($(handler).text()=='卸载'){
			txt=  "是否要卸载该应用!!!";
			option = {
				title: "卸载提示",
				onOk: function(){	
					$(handler).css('background','#1887f6');	
					$(handler).find('span').text('安装');
					$(handler).find('img').attr('src',ctx+'/custom/images/index_application_load.png');
					if($('.index_application_left_click').find('span').eq(0).text()!='全部应用'){
						$(handler).parent().parent().hide();
					}
					
					//保存到数据库
					jwAppAppsModel.jwAppsAppsActAction.insert_unInstallApp_byResourceId({
						APP_ID:$(handler).parent().parent().data('app').APP_ID
					});
					//绑定一个data来区别是否已经安装1为安装,0为未安装
					$(handler).parent().parent().data('app').CUSTOM_INSTALL='0';
					
					$('.fancybox-iframe',window.parent.document).parent().parent().parent().find('.fancybox-close').unbind().bind('click',function(event){
						event.stopPropagation();
						index_application_close();
					});
					$('.fancybox-iframe',window.parent.document).parents('.fancybox-overlay').not('.fancybox-type-iframe').unbind().bind('click',function(){
						index_application_close();
					})
				},
				onCancel:function(){
					
				}
			}
		}
		else{
			txt=  "是否要安装该应用!!!";
			option = {
				title: "安装提示",
				onOk: function(){
					$(handler).css('background','#b50000');	
					$(handler).find('span').text('卸载');
					$(handler).find('img').attr('src',ctx+'/custom/images/index_application_unLoad.png');
					if($('.index_application_left_click').find('span').eq(0).text()!='全部应用'){
						$(handler).parent().parent().hide();
					}
					
					//保存到数据库	
					jwAppAppsModel.jwAppsAppsActAction.insert_installApp_byResourceId({
						APP_ID:$(handler).parent().parent().data('app').APP_ID
					});
					//绑定一个data来区别是否已经安装1为安装,0为未安装
					$(handler).parent().parent().data('app').CUSTOM_INSTALL='1';
					
					$('.fancybox-iframe',window.parent.document).parent().parent().parent().find('.fancybox-close').unbind().bind('click',function(event){
						event.stopPropagation();	
						index_application_close();
					});
					$('.fancybox-iframe',window.parent.document).parents('.fancybox-overlay').not('.fancybox-type-iframe').unbind().bind('click',function(){
						index_application_close();
					})
				},
				onCancel:function(){
					
				}
			}
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
	}
	
//关闭后重新渲染应用中心
function index_application_close(){
	var app_data=[];
	$('.index_application_show_tabs_content>div').each(function(index,elemet){
		if($(elemet).find('.index_application_show_tabs_content_img>span').text()=='卸载'){
        	app_data.push($(elemet).data('app'));		
		}
	})
	//初始化应用,调用父元素的方法
	parent.window.init_index_application(app_data);
}

//初始化类别
function init_index_categorys(){
	var list_category = list_allApps.types.rowSet;
	var index_application_show_tabs = $('.index_application_show_tabs');
	index_application_show_tabs.append('<span class="index_application_show_tabs_click">全部应用</span>');	
	for(var i = 0 ; i<list_category.length;i++){
		var span = $('<span></span>').data('type',list_category[i]).text(list_category[i].NAME);
		index_application_show_tabs.append(span);
	}
} 
	
//初始化apps
function init_index_apps(){
	var apps = list_allApps.apps.rowSet;
	var appsContainer = $('.index_application_show_tabs_content');
	//获得默认应用的id
	var default_appId;
	$('.index_application_show_tabs>span').each(function(index,element){
		if($(element).text()=='默认应用'){
			default_appId =$(element).data('type').CATEGORY_ID;
		}
	})
	
	for(var i=0;i<apps.length;i++){
		var createContainer = $('<div></div>').data('app',apps[i]);
		appsContainer.append(createContainer);
		var index_application_show_tabs_content_div= $('<div class="index_application_show_tabs_content_div"></div>');
		index_application_show_tabs_content_div.attr('title',apps[i].NAME);
		createContainer.append(index_application_show_tabs_content_div);
		var app_img = $('<div><img src="'+ctx+'/photo/photo.jsp?ls_photo='+ apps[i].IMG_ID_S +'" width="60" height="60"/></div>');
		var app_text1=$('<div class="index_application_show_tabs_content_text"></div>').text(apps[i].NAME);
		var app_text2=$('<div class="index_application_show_tabs_content_text" style="margin-top:2px;"></div>');
		//判断是用户安装的还是系统自带的
		if(apps[i].CATEGORY==default_appId){
			app_text2.text('(默认安装) ');
		}
		else{
			app_text2.text('(用户安装 )');
		}
		var app_isInstall = $('<div class="index_application_show_tabs_content_img" onclick="index_application_isLoad(this)"><img src="'+ ctx +'/custom/images/index_application_unLoad.png" width="16" height="16"/><span>卸载</span></div>');
		//判断是否卸载
		if(!apps[i].USERID){
			//先处理下数据,如果是安装的那就加一个属性CUSTOMINSTALL为1,否则为0
			apps[i].CUSTOM_INSTALL='0';
			app_isInstall.css('background','#1887f6');
			app_isInstall.find('img').attr('src',ctx+'/custom/images/index_application_load.png');
			app_isInstall.find('span').text('安装');
		}
		else{
			//先处理下数据,如果是安装的那就加一个属性CUSTOMINSTALL为1,否则为0
			apps[i].CUSTOM_INSTALL='1';
		}
		index_application_show_tabs_content_div.append(app_img).append(app_text1).append(app_text2).append(app_isInstall);
	}
}

//apps的切换
function index_application_toggle(){
	//如果存在搜索后没有应用时的文字就去掉
	if($('.index_application_show_tabs_content>span').length!=0){
		$('.index_application_show_tabs_content>span').remove();
	}
	var type = $('.index_application_show_tabs_click').data('type');
	switch ($('.index_application_left_click>span:first-child').text()) {
		case '全部应用':
			$('.index_application_show_tabs_content>div').each(function(index,element){
				$(element).show();
				if(type&&type.CATEGORY_ID!=$(element).data('app').CATEGORY){
					$(element).hide();
				}
			})
			break;
		case '未安装':	
			$('.index_application_show_tabs_content>div').each(function(index,element){
 				$(element).show();
 				//隐藏已经安装的
	 			if($(element).data('app').CUSTOM_INSTALL=='1'){
	 				$(element).hide();
	 			}
	 			//再隐藏不符合tabs的
	 			else{
	 				if(type&&type.CATEGORY_ID!=$(element).data('app').CATEGORY){
	 					$(element).hide();
	 				}
	 			}
			})
			break;
		case '已安装':
			$('.index_application_show_tabs_content>div').each(function(index,element){
				$(element).show();
				//隐藏未安装的
	 			if($(element).data('app').CUSTOM_INSTALL=='0'){
	 				$(element).hide();
	 			}
	 			//再隐藏不符合tabs的
	 			else{
	 				if(type&&type.CATEGORY_ID!=$(element).data('app').CATEGORY){
	 					$(element).hide();
	 				}
	 			}
			})
			break;
		default:
			break;
		}
}

//搜索功能
function index_application_search(){
	var key = $('.index_application_header_right>input').val();
	//去掉前后空格
	key = $.trim(key);
	$('.index_application_left>div').eq(0).click();
	$('.index_application_show_tabs>span').eq(0).click();
	//遍历所有的应用
	//定义flag来判断是否存在搜索到的应用,trur表示没有
	var flag = true ; 
	$('.index_application_show_tabs_content>div').each(function(index,element){
		$(element).show();
		var text = $(element).find('.index_application_show_tabs_content_text').eq(0).text();
		//把不符合搜索框里面的值的app隐藏起来
		if(text.indexOf(key)==-1&&key!=''){
			$(element).hide();		
		}
		else{
			flag=false;
		}
	})
	if(flag==true){
		$('.index_application_show_tabs_content>div').hide();
		$('.index_application_show_tabs_content').append('<span>没有找到该应用,请重新搜索!!!</span>');		
	}

}

</script>
