$(function() {
	
	//去掉尾部的一个div
	$('.index_footer').next().remove();
	
	//初始化容器的最小高度
	init_index_contaner_minHeight();
	
	//初始化块状显示
	init_disk_lump();
	
	//绑定键盘shift和ctrl键来多选
	init_disk_window_multiple();
	
	//点击容器外时取消选中状态
	$(document).click(function(e){  
		//console.log($(e.target));
		
		//去掉右键的菜单
		$('#disk_menu').hide();
		$('#disk_rubbish_menu').hide();
		$('#disk_shareCode_menu').hide();
		
		//如果不需要取消选中的文件时,或者是fancybox的内容,或者是点击了菜单上面的按钮,或者是提示框时
		if($(e.target).parents('.xcConfirm').length==1||$(e.target).parents('.disk_rubbsh_menu').length==1||$(e.target).parents('.disk_menu').length==1||$(e.target).parents('.fancybox-overlay').length==1||$(e.target).hasClass('disk_document_default')||$(e.target).parent().hasClass('disk_document_default')){
			return;
		}
		
		//去掉选中状态
		$('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
		
	});
	
	//容器的右键效果
	init_disk_contextmenu();
	
})

//绑定键盘shift和ctrl键来多选
function init_disk_window_multiple(){
	$(window).keydown(function(e){
        if(e.ctrlKey||e.shiftKey){
        	$('.disk_content_lump').data('ctrlSelect',true);
        }
    }).keyup(function(){
    	$('.disk_content_lump').data('ctrlSelect',false);
    });
}

//初始化容器的最小高度
function init_index_contaner_minHeight() {
	var conrainer_height = $.jfbrother.getViewSizeWithScrollbar().height - $('.indedx_header').outerHeight(true) - $('.indedx_header_logo').outerHeight(true) - $('.index_center').outerHeight(true) - $('.index_insert_module').outerHeight(true) - $('.index_footer').outerHeight(true)- $('.disk_search').outerHeight(true) - $('.disk_content_header').outerHeight(true);
	//如果原始的高度比屏幕小时再添加最小高度(块状容器)
	if ($('.disk_content_lump').outerHeight() < conrainer_height) {
		$('.disk_content_lump').css('minHeight', conrainer_height);
	}
}

//初始化块状显示
function init_disk_lump(){
	//获得初始化文件列表
	var infos = init_disk_infos('0');
	//渲染块状
	for(var i = 0 ; i<infos.length;i++){
		init_disk_createLump(infos[i]);
	}
}

//初始化块状的文件名的单击效果
function init_disk_lump_fileName_click(){
	$('.disk_content_lump>div>div>div').each(function(index,element){
		$(element).bind('click',function(){
			disk_click_div_edit(this);
		})
	})
}

//根据一个json数据来初始化块状列表
function init_disk_createLump(lump_json){
	var $disk_content_lump = $('.disk_content_lump');
	var $create_container = $('<div></div>').addClass('col-md-2');
	$disk_content_lump.append($create_container);
	var $create_content = $('<div></div>');
	
	//把数据存放起来
	$create_content.data('lump_data',lump_json);
	
	$create_content.bind('click',function(){
		disk_lump_click(this);
	})
	
	$create_container.append($create_content);
	
	//先初始化图片
	init_disk_select_fileImg(lump_json);
	
	//如果是图片显示时
	var $create_img = $('<img height="90" />');
	if(lump_json.fileImg){
		$create_img.attr('src',ctx+'/custom/images/'+lump_json.fileImg);
	}
	else{
		$create_img.attr('src',ctx+'/photo/photo.jsp?ls_photo='+lump_json.FILE_SAVE_PATH+lump_json.FILE_SVAE_NAME);
		$create_img.css('border-radius','5px');
	}
	var $create_div = $('<div></div>').text(lump_json.FILE_NAME);
	if($('#disk_rubbish').data('rubbish')){
		//如果是回收站时,则鼠标移动到文件名时去掉原来的效果
		$create_div.hover(function(){
			$(this).addClass('disk_rubbish_fileName');
		},function(){
			$(this).removeClass('disk_rubbish_fileName');
		});
	}
	else{
		//如果不是显示回收站的时候
		//编辑
		$create_div.bind('click',function(){
			disk_click_div_edit(this);
		})
		//双击
		$create_content.bind('dblclick',function(){
			disk_lump_dbClick(this);
		})
	}
	var $create_input = $('<input type="text" class="form-control"/>').val(lump_json.FILE_NAME);
	//输入框失去焦点时
	$create_input.bind('blur',function(){
		disk_input_blur(this);
	})
	$create_input.css('display','none');
	$create_content.append($create_img).append($create_div).append($create_input);

}

//新建文件夹
function disk_addFolder(handler){
	//右键新建文件时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	//如果一开始是没有文件时,就先去掉
	if($('.disk_content_lump').find('.disk_content_lump_noFile').length!=0){
		$('.disk_content_lump').find('.disk_content_lump_noFile').remove();
	}
	
	//如果为列表时
	if($('.disk_content_toggleBtn').data('toggleList')){
		//列表的添加文件
		disk_addFolder_list();
	}
	//如果是块状的时候
	else{
		//缩略图的添加文件
		disk_addFolder_lump();
	}
}

//列表的添加文件
function disk_addFolder_list(){
	var date = $.jfbrother.dateToStr('yyyy-MM-dd');
	var list_data = {UUID:'',UPDATE_TIME:date,FILE_NAME:'新建文件夹',fileImg:'disk_module5_close.png',FILE_TYPE:'folder',FILE_SIZE:0,apiIndex:'0'};
	
	//跳到第一页
	//$('#disk_content_list').bootstrapTable('selectPage', 1); //Jump to the first page
	
	//添加一行数据
	$('#disk_content_list').bootstrapTable('insertRow',{
		index:0,
		row:list_data
	});
	
	//取消之前的选中
	$('#disk_content_list').bootstrapTable('uncheckAll');
	
	//根据uuid来选中新增的那一行
	$('#disk_content_list tr').each(function(index,element){
		if($(element).data('uniqueid')==list_data.UUID){
			$('#disk_content_list').bootstrapTable('check',$(element).data('index'));
			var $div = $(element).find('.disk_content_list_fileName>div').eq(1).find('div');
			$div.hide();
			$div.next().show();
			//输入框获得焦点
			$div.next().focus();
			//输入框的内容全选
			$div.next().select();
			return false;
		}
	})
}

//缩略图的添加文件夹
function disk_addFolder_lump(){
	var lump_data = {FILE_NAME:'新建文件夹',fileImg:'disk_module5_close.png',FILE_TYPE:'folder',FILE_SIZE:'0',apiIndex:'0'}; 
	var $disk_content_lump = $('.disk_content_lump');
	var $create_container = $('<div></div>').addClass('col-md-2');
	$disk_content_lump.append($create_container);
	var $create_content = $('<div></div>').addClass('disk_content_lump_click');
	
	$create_content.bind('click',function(){
		disk_lump_click(this);
	})
	$create_content.bind('dblclick',function(){
		disk_lump_dbClick(this);
	})
	$create_container.append($create_content);
	var $create_img = $('<img width="125" height="90" src="'+ctx+'/custom/images/'+ lump_data.fileImg +'" />');
	var $create_div = $('<div></div>').text(lump_data.FILE_NAME);
	$create_div.bind('click',function(){
		disk_click_div_edit(this);
	})
	$create_div.hide();
	var $create_input = $('<input type="text" class="form-control"/>').val(lump_data.FILE_NAME);
	//输入框失去焦点时
	$create_input.bind('blur',function(){
		disk_input_blur(this);
	})
	$create_content.append($create_img).append($create_div).append($create_input);
	//输入框获得焦点
	$create_input.focus();
	//输入框的内容全选
	$create_input.select();
}

//点击文件名时的编辑效果
function disk_click_div_edit(handler){
	var lump_data = $(handler).parent().data('lump_data');
	if($(handler).parent().hasClass('disk_content_lump_click')){
		//如果是公司文件或者是共享文件时,则不做编辑操作,直接是双击点击去的效果
		if(lump_data.apiIndex=='1'||lump_data.apiIndex=='2'){
			disk_lump_dbClick($(handler).parent());
		}
		else{
			$(handler).hide();
			$(handler).next().show();
			//输入框获得焦点
			$(handler).next().focus();
			//输入框的内容全选
			$(handler).next().select();
		}
	}
}

//文本框失去焦点时
function disk_input_blur(handler){
	var lump_data = $(handler).parent().data('lump_data');
	//隐藏输入框,显示div容器
	$(handler).hide();
	var input_val = $(handler).val();
	//如果值为空时,则默认为新建文件夹
	if(input_val==''){
		input_val = '新建文件夹';
	}
	//如果文件夹存在时,就自动加个(序号),遍历之前的容器
	disk_find_folder($(handler),input_val);
	var count = $(handler).data('count');
	count==0?input_val=input_val:input_val=input_val+'('+ count +')';
	//给input和div赋值
	$(handler).prev().show().text(input_val);
	$(handler).val(input_val)
	//如果值存在那就表示是修改操作,否则是添加操作
	if(lump_data&&lump_data.UUID!=''){
		//块状和列表的编辑
		//保存到数据库
		//文件的uuid和文件名去保存
		var result = storePersonalModule.storePersonalActAction.updateStorePersonal({
			FIELD_UUID:lump_data.UUID,
			FIELD_FILE_NAME:input_val,
			FIELD_FATHER_ID:lump_data.FATHER_ID,
			FIELD_ISFILE:lump_data.ISFILE		
		});
	}
	else{
		//列表的添加
		//获得目录的最后一个数据
		var nav_lump_data = $('.disk_search_center>a:last').data('lump_data');
		//如果不存在则父节点是根节点
		var parentId;
		if(nav_lump_data){
			parentId = nav_lump_data.UUID;
		}
		else{
			parentId = 'A';
		}
		var uuid = $.jfbrother.uuid();
		var date = $.jfbrother.dateToStr('yyyy-MM-dd');
		var list_lump_data = {apiIndex:'0',UUID:uuid,FILE_NAME:input_val,FILE_TYPE:'folder',FILE_SIZE:0,UPDATE_TIME:date,FATHER_ID:parentId,FIELD_ISFILE:'0'};
		var insert_result = storePersonalModule.storePersonalActAction.insertStorePersonal({
			FIELD_UUID:uuid,
			FIELD_MODULE_ID : '3',
			FIELD_ISFILE : '0',
			FIELD_FATHER_ID : parentId,
			FIELD_FILE_NAME : input_val
		});
		//绑定数据
		$(handler).parent().data('lump_data',list_lump_data);
		//如果是列表需要做一次更新,否则列表时的input和data绑定的值不会做修改
		if($('.disk_content_toggleBtn').data('toggleList')){
			$('#disk_content_list').bootstrapTable('updateRow',{
				index:$(handler).parents('tr').data('index'),
				row:list_lump_data
			});
		}
	}
}

//递归查找文件夹是否存在
function disk_find_folder(handler,input_val,count){
	var $handler = $(handler);
	var val = input_val;
	var count_value = count;
	if(!count_value){
		count_value = 0;
	}
	var flag = true;//表示不存在
	//遍历除了自身的文件
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		$('#disk_content_list tbody>tr .disk_content_list_fileName input').not($(handler)).each(function(index,element){
			count_value==0?result_val=val:result_val = val + '('+ count_value +')';
			if($(element).prev().text()==result_val){
				flag = false;
				return false;
			}
		})
	}
	else{
		//如果是块状时
		$(handler).parents('.disk_content_lump').children().not($(handler).parents('.col-md-2')).each(function(index,element){
			count_value==0?result_val=val:result_val = val + '('+ count_value +')';
			if($(element).find('img+div').text()==result_val){
				flag = false;
				return false;
			}
		})
	}
	if(!flag){
		count_value+=1;
		disk_find_folder($handler,val,count_value);
	}
	else{	
		$handler.data('count',count_value);
	}
}

//单击块状
function disk_lump_click(handler){
	//去掉右键的菜单
	$('#disk_menu').hide();
	$.jfbrother.stopPropagation();
	//如果是不可以多选时
	if(!$(handler).parents('.disk_content_lump').data('ctrlSelect')){
		//先去掉之前选中的
		$(handler).parents('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
	}
	//然后给自己加个样式
	$(handler).addClass('disk_content_lump_click');
}

//双击块状
function disk_lump_dbClick(handler){
	//文件的数据
	var lump_data = $(handler).data('lump_data');
	//console.log(lump_data)
	//重新渲染块状
	disk_dbClick_custom($(handler).find('input'),lump_data,function(infos){
		//先清空容器
		$('.disk_content_lump').html('');
		if(infos.length!=0){
			for(var i = 0 ;i<infos.length;i++){
				init_disk_createLump(infos[i]);
			}
		}
		//没文件时的显示
		else{	
			//初始化没文件的显示
			init_disk_lump_noFile(lump_data);					
		}
	});
	
	//如果是公司文件时,则隐藏所有的按钮
	if(lump_data.FILE_TYPE=='folder_company'){
		$('.disk_content_header>div:first-child>a').hide();
		//显示下载按钮
		//$('.disk_content_header>div:first-child>a').eq(1).show();
	}
	else if(lump_data.FILE_TYPE=='folder_share'){
		//显示取消共享的按钮
		$('.disk_content_header>div:first-child>a').hide();
		$('.disk_enjoyBtn').show();
	}
	
}

//初始化块状没文件的显示
function init_disk_lump_noFile(lump_data){
	var $disk_content_lump = $('.disk_content_lump');
	var $no_file_content = $('<div></div>').addClass('disk_content_lump_noFile');
	var $no_file_img = $('<img src='+ctx+'/custom/images/disk_lump_noFile.png width="131" height="116" />');
	var $no_file_text;
	var $no_file_btn;
	//如果是回收站处理没文件时
	if($('#disk_rubbish').data('rubbish')){
		$no_file_text = $('<p></p>').text('暂无删除数据~');
	}
	//如果是分享码处理没文件时
	if(lump_data){
		//如果是公司文件时
		if(lump_data.apiIndex=='1'){
			$no_file_text = $('<p></p>').text('暂无数据~');
		}
		//如果是共享文件时
		else if(lump_data.apiIndex=='2'){
			$no_file_text = $('<p></p>').text('暂无共享数据~');
		}
		//如果为普通文件时
		else{
			$no_file_text = $('<p></p>').text('超大空间等你来填满,快来上传吧~');
			$no_file_btn = $('<p><span onclick="disk_uploadFolder()">上传文件</span></p>');
		}
	}	
	$disk_content_lump.append($no_file_content);
	$no_file_content.append($no_file_img).append($no_file_text).append($no_file_btn);
};

//把自身的uuid当做parentId来查找下面的子目录,不穿则表示查找跟节点,获得的可以是回收站可以是正常文件delete_flag 1为回收站的文件,0是正常文件
function init_disk_infos(delete_flag,lump_data){
	var infos;
	//如果没传入值,表示是查找根目录
	if(!lump_data){
		infos = storePersonalModule.storePersonalDataAction.listAll_storePersonalnofile().rowSet;
		var results = [];
		//把重复的parentId!=A的过滤掉,以及带有删除标识的判断下
		for( var i = 0 ; i < infos.length ; i ++){
			if(delete_flag=='0'){
				if(infos[i].FATHER_ID=='A'&&infos[i].DELETE_FLAG==delete_flag){
					results.push(infos[i]);
				}
			}
			else{
				if(infos[i].DELETE_FLAG==delete_flag){
					results.push(infos[i]);
				}
			}
		}
		//做个一个标识,来标识是要调用哪个api
		for(var i = 0 ; i < results.length;i++ ){
			results[i].apiIndex = '0';
		}
		if(delete_flag=='0'){
			//把公司文件和共享文件写死
			var default_infos = [
				{UUID:'B',FILE_NAME:'公司文件',UPDATE_TIME:'',FILE_TYPE:'folder_company',FILE_SIZE:0,apiIndex:'1',ISFILE:'0'},
				{UUID:'C',FILE_NAME:'共享文件',UPDATE_TIME:'',FILE_TYPE:'folder_share',FILE_SIZE:0,apiIndex:'2',ISFILE:'0'},
			];
			results = default_infos.concat(results);
		}
		return results;
	}
	
	if(lump_data.apiIndex=='1'){
		//如果是公司文件时
		//如果uuid==B的时候为根节点
		if(lump_data.UUID=='B'){
			infos = storeModule.storeDataAction.list_storenofile({
				FIELD_FATHER_ID:'A'
			}).rowSet;
		}
		//否则为其子节点
		else{
			infos = storeModule.storeDataAction.list_storenofile({
				FIELD_FATHER_ID:lump_data.UUID
			}).rowSet;
		}
		//做个一个标识,来标识是要调用哪个api
		for(var i = 0 ; i < infos.length;i++ ){
			infos[i].apiIndex = '1';
		}
	}
	else if(lump_data.apiIndex=='2'){
		//如果是共享文件时
		//如果uuid==C的时候为根节点
		if(lump_data.UUID=='C'){
			infos = [];			
			var storeShare_list = storeShareModule.storeShareDataAction.list().rowSet;
			//先获得共享的数据,再根据FILE_UUID去查找普通文件信息
			for(var i = 0 ; i < storeShare_list.length;i++ ){
				var v_query = {} ;
				v_query.FIELD_UUID=storeShare_list[i].FILE_UUID;
				var result_storeShare_list = storePersonalModule.storePersonalDataAction.listAll_storePersonalnofile(v_query).rowSet;
				//把共享中的FILE_UUID,CREATE_NAME,CREATOR_ID,SHARE_ID,SHARE_NAME,SHARE_TIME保留下来
				result_storeShare_list[0].FILE_UUID = storeShare_list[i].UUID;
				result_storeShare_list[0].CREATE_NAME = storeShare_list[i].CREATE_NAME;
				result_storeShare_list[0].CREATOR_ID = storeShare_list[i].CREATOR_ID;
				result_storeShare_list[0].SHARE_ID = storeShare_list[i].SHARE_ID;
				result_storeShare_list[0].SHARE_NAME = storeShare_list[i].SHARE_NAME;
				result_storeShare_list[0].SHARE_TIME = storeShare_list[i].SHARE_TIME;
				infos.push(result_storeShare_list[0]);
			}
		}
		else{
			infos = storePersonalModule.storePersonalDataAction.listAll_storePersonalnofile({
				FIELD_FATHER_ID:lump_data.UUID
			}).rowSet;
			//遍历下给每个数据加上共享信息
			for(var i = 0;i<infos.length;i++){
				//用索引i来区别下,不然会出现同一个FILE_UUID
				infos[i].FILE_UUID=lump_data.FILE_UUID + i ;
				infos[i].CREATE_NAME=lump_data.CREATE_NAME;
				infos[i].CREATOR_ID=lump_data.CREATOR_ID;
				infos[i].SHARE_ID=lump_data.SHARE_ID;
				infos[i].SHARE_NAME=lump_data.SHARE_NAME;
				infos[i].SHARE_TIME=lump_data.SHARE_TIME;
			}
		}
		
		//做个一个标识,来标识是要调用哪个api
		for(var i = 0 ; i < infos.length;i++ ){
			infos[i].apiIndex = '2';
		}
	}
	else{
		//如果是普通文件时
		var infos_result = storePersonalModule.storePersonalDataAction.listAll_storePersonalnofile({
			FIELD_FATHER_ID:lump_data.UUID
		}).rowSet;
		//把删除后的文件去掉
		infos = [];
		for( var i = 0 ; i < infos_result.length ; i ++){
			if(infos_result[i].DELETE_FLAG==delete_flag){
				//做个一个标识,来标识是要调用哪个api
				infos_result[i].apiIndex = '0';
				infos.push(infos_result[i]);
			}
		}
		
	}
	return infos;
}

//容器的右键效果
function init_disk_contextmenu(){
	$('.disk_content_lump,.disk_content_list').bind('contextmenu',function(e){
	
		var $disk_menu;
		var lump_data;
		if($('#disk_rubbish').data('rubbish')){
			$disk_menu = $('#disk_rubbish_menu');
		}
		else if($('#disk_shareCode').data('shareCode')){
			$disk_menu = $('#disk_shareCode_menu'); 
		}
		else{
			$disk_menu = $('#disk_menu');
		}
		
		//console.log($(e.target));
		//如果是正在编辑的时候就不做操作,如果是没有文件时
		if($(e.target).is('input')||$(e.target).hasClass('disk_content_lump_noFile')||$(e.target).parents('.disk_content_lump_noFile').length==1){
			return false;
		}
		
		//如果是列表模式时,或者是分享码的列表时
		if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
			//点击空白的地方
			if($(e.target).hasClass('fixed-table-body')){
				//去掉之前选中的列
				//$('#disk_content_list').bootstrapTable('uncheckAll');
				var a_length = $('.disk_search_center>a').eq(1).length;
				if(a_length!=0){
					lump_data = $('.disk_search_center>a').eq(1).data('lump_data');
				}
			}
			//点击文件夹
			else if($(e.target).parents('tbody').length==1){
				//点击列表没有数据时则返回
				if($(e.target).parents('tbody').find('.no-records-found').length==1){
					return false;
				}
				//去掉之前选中的列
				$('#disk_content_list').bootstrapTable('uncheckAll');				
				//选中当前的列
				$('#disk_content_list').bootstrapTable('check',$(e.target).parents('tr').data('index'));
				lump_data = $(e.target).parents('tr').find('.disk_content_list_fileName>div').eq(1).data('lump_data');
			}
			//点击了分页和table的头部
			else if($(e.target).parents('thead').length==1||$(e.target).hasClass('fixed-table-pagination')||$(e.target).parents('.fixed-table-pagination').length==1){
				return false;
			}
		}
		//如果是缩略图的模式时
		else{
			//右键时,切换是否可以点击的按钮
			if($(e.target).hasClass('disk_content_lump')||$(e.target).hasClass('col-md-2')){
				var a_length = $('.disk_search_center>a').eq(1).length;
				if(a_length!=0){
					lump_data = $('.disk_search_center>a').eq(1).data('lump_data');
				}
			}
			else{
				//先去掉之前选中的
				$(e.target).parents('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
				//然后给自己加个样式
				$(e.target).parents('.col-md-2').children('div').addClass('disk_content_lump_click');
				lump_data = $(e.target).parents('.col-md-2').children('div').data('lump_data');								
			}
		}
		
		//菜单的显示
		init_disk_menu_toggle($disk_menu,lump_data);
		
		//显示菜单
		$disk_menu.show();
		
		var e = e || event;
	    var scrollTop=document.documentElement.scrollTop||document.body.scrollTop;
	    var scrollWidth = $.jfbrother.getScrollbarWidth();
	    //屏幕的高度与高度
	    var client_width = $.jfbrother.getViewSizeWithScrollbar().width;
	    var client_height = $.jfbrother.getViewSizeWithScrollbar().height;
	    //鼠标的位置
	    var mouse_left = e.clientX;
	    var mouse_top= e.clientY;
	    //菜单的宽高
	    var menu_width= $disk_menu.outerWidth(true);
	    var menu_height= $disk_menu.outerHeight(true);
	    //如果右边的超出了
	    if(client_width-mouse_left-scrollWidth<menu_width){
	    	mouse_left = client_width - menu_width - scrollWidth;
	    }
	    //如果高度超出时
    	if(client_height-mouse_top<menu_height){
    		mouse_top = client_height - menu_height + scrollTop;
    	}
    	else{
    		mouse_top = mouse_top + scrollTop;
    	}
	    //当滑动滚动条时也能准确获取菜单位置
    	$disk_menu.css({'top':mouse_top+"px",'left':mouse_left+"px"});
	    //阻止默认事件
	    return false;
	})
}

//菜单的切换显示
function init_disk_menu_toggle(disk_menu,lump_data){	
	var $disk_menu = disk_menu;
	if(!lump_data){
		$disk_menu.find('.disk_menu_noClickBtn').removeClass('disk_menu_noClick');
		$disk_menu.find('.disk_menu_clickBtn').addClass('disk_menu_noClick');		
		return;
	}
	else{
		$disk_menu.find('.disk_menu_noClickBtn').addClass('disk_menu_noClick');
		$disk_menu.find('.disk_menu_clickBtn').removeClass('disk_menu_noClick');
	}
	//如果是在首页点击了公司文件或共享文件则不显示重命名,分享,删除,移动到,共享,下载
	if(($('.disk_search_center>a').eq(0).next().length==0&&lump_data.FILE_TYPE=='folder_company')||($('.disk_search_center>a').eq(0).next().length==0&&lump_data.FILE_TYPE=='folder_share')){
		$disk_menu.find('.disk_menu_clickBtn').addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(2).removeClass('disk_menu_noClick');
		return;
	}	
	//普通文件的空白位置
	if(lump_data.apiIndex=='0'&&lump_data.FATHER_ID=='A'&&$('.disk_search_center>a').eq(0).next().length!=0){
		$disk_menu.find('.disk_menu_noClickBtn').removeClass('disk_menu_noClick');
		$disk_menu.find('.disk_menu_clickBtn').addClass('disk_menu_noClick');
	}
	//如果点击了公司文件的空白位置
	if(lump_data.UUID=='B'){
		$disk_menu.find('li').addClass('disk_menu_noClick');
	}
	//如果点击了共享文件的空白位置
	if(lump_data.UUID=='C'&&lump_data.apiIndex=='2'){
		$disk_menu.find('li').addClass('disk_menu_noClick');
		$disk_menu.find('li:last').hide();
	}
	else if(lump_data.apiIndex=='2'){
		$disk_menu.find('li').eq(3).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(4).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(5).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(6).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(7).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(8).addClass('disk_menu_noClick');
		//根目录显示取消共享的操作,子目录不显示
		if($('.disk_search_center>a').eq(1).next().length==0){
			$disk_menu.find('li:last').show();
			$disk_menu.find('li:last').removeClass('disk_menu_noClick');
		}
		else{
			$disk_menu.find('li:last').hide();
		}
	}
	//如果是公司文件
	if(lump_data.apiIndex=='1'){
		$disk_menu.find('li').eq(3).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(4).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(5).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(7).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(8).addClass('disk_menu_noClick');
	}
	//如果是文件时,则不显示打开文件夹的按钮,并且不能显示下载按钮
	if(lump_data.ISFILE=='1'){
		$disk_menu.find('li').eq(2).addClass('disk_menu_noClick');
		$disk_menu.find('li').eq(6).removeClass('disk_menu_noClick');
	}
	else{
		$disk_menu.find('li').eq(6).addClass('disk_menu_noClick');
	}
}

//删除文件夹
function disk_deleteFolder(handler){
	disk_confirm(handler,'删除',function(list_rows,uuids){
		//删除数据库的信息
		var result = disk_deleteFolder_sql(uuids);
	});
}

//数据库的删除文件
function disk_deleteFolder_sql(uuids){
	var result = storePersonalModule.storePersonalActAction.deleteStorePersonal({
		FIELD_CODE : uuids
	});
	return result;
}

//缩略图与列表的切换
function disk_content_toggle(handler){
	//获得文件目录的最后一个数据
	var lump_data = $('.disk_search_center>a:last').data('lump_data');
	var infos;
	//重新渲染块状
	if($('#disk_rubbish').data('rubbish')){
		infos = init_disk_infos('1',lump_data);
	}
	else{
		infos = init_disk_infos('0',lump_data);
	}
	//绑定一个data来区别切换的状态toggleList==true为切换到了list
	if(!$(handler).data('toggleList')){
		//列表形式
		$(handler).data('toggleList',true);
		$(handler).attr('title','切换到缩略图模式');
		$(handler).removeClass('glyphicon-th-large').addClass('glyphicon-th-list');
		
		//如果是共享文件的列表显示时
		if(lump_data&&lump_data.apiIndex=='2'){
			init_disk_enjoy_list(infos);
		}
		else{
			if($('#disk_rubbish').data('rubbish')){
				init_disk_rubbish_list(infos);
			}
			else{
				init_disk_list(infos);
			}
		}
	}
	else{
		//缩略图形式
		$(handler).data('toggleList',false);
		//修改分享码的shareCode属性值
		$('#disk_shareCode').data('shareCode',false);
		$(handler).attr('title','切换到列表模式');
		$(handler).removeClass('glyphicon-th-list').addClass('glyphicon-th-large');
		//先清空容器
		$('.disk_content_lump').html('');
		if(infos.length==0){
			//无数据时块状的填充
			init_disk_lump_noFile(lump_data);
		}
		else{
			//渲染块状
			for(var i = 0 ; i<infos.length;i++){
				init_disk_createLump(infos[i]);
			}
		}
		
	}
	$('.disk_content_lump,.disk_content_list').toggle();
}

//初始化共享文件的列表
function init_disk_enjoy_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
       /* showColumns:true,
       showToggle:true,
       showRefresh:true,
       search:true, */
       /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
       data:infos,
       cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
       /* striped: true,  //表格显示条纹，默认为false */
       pagination: false, // 在表格底部显示分页组件，默认false
       pageList: [5,10,15,20], // 设置页面可以显示的数据条数
       pageSize: 10, // 页面数据条数
       pageNumber: 1, // 首页页码,
       uniqueId:'FILE_UUID',
       //clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
       queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
       },
       columns: [
           {
               checkbox: true, // 显示一个勾选框
               align: 'center', // 居中显示
               valign: 'middle'
           },{
               field: 'FILE_NAME',
               title: '文件名称',
               align: 'left',
               valign: 'middle',
               width:400,
               formatter: function (value, row, index) {
              	 if(row.fileImg){
              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>'; 
              	 }
              	 else{
              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img style="border-radius:5px;" src="'+ctx+'/photo/photo.jsp?ls_photo='+row.FILE_SAVE_PATH+row.FILE_SVAE_NAME+'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>';
              	 }
               }
           }, {
               field: 'SHARE_TIME',
               title: '共享时间',
               align: 'center',
               valign: 'middle',
               order:'asc',
               sortable:'true'
           }, {
               field: 'FILE_TYPE',
               title: '类型',
               align: 'center',
               valign: 'middle'
           },{
               field: 'FILE_SIZE',
               title: '大小',
               align: 'center',
               valign: 'middle',
               formatter: function (value, row, index) {
              	 return $.jfbrother.fileSizeToStr(row.FILE_SIZE);
               }
           },{
               field: 'SHARE_NAME',
               title: '共享目标人',
               align: 'center',
               valign: 'middle'
           },{
               field: 'CREATE_NAME',
               title: '创建人',
               align: 'center',
               valign: 'middle'
           }
       ],
       //选中时隐藏菜单
       onCheck:function(row){
      	 $('#disk_menu').hide();
       },
       //当用户点击某一列的时候触发
       onClickCell:function(field, value, row, $element){
      	 if(field=='FILE_NAME'){        	
      		 //编辑,把td传入
      		 disk_editFolder_list($element);
      	 }
       },
       //当用户双击某一行的时候触发
       onDblClickRow:function(row, $element){
      	 //根据file_uuid重新渲染列表
      	 disk_list_dbClick(row,$element);
       },
       //当用户单击某一行的时候触发
       onClickRow:function(row, $element){
      	//选中这行
      	//在根据file_uuid来获得对象
   		$('#disk_content_list tr').each(function(index,element){
   			if($(element).data('uniqueid')==row.FILE_UUID){
   				var index = $(element).data('index');
   				//如果正处于编辑状态那就选中,否则就反着选
   				if($(element).find('.disk_content_list_fileName input').css('display')!='none'||!$(element).find('input[type="checkbox"]').prop('checked')){
   					$('#disk_content_list').bootstrapTable('check',index);
   				}
   				else{
   					$('#disk_content_list').bootstrapTable('uncheck',index);
   				}
   			}
   		})
       }
       //
 })
}

//初始化文件的列表
function init_disk_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
         /* showColumns:true,
         showToggle:true,
         showRefresh:true,
         search:true, */
         /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
         data:infos,
         cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
         /* striped: true,  //表格显示条纹，默认为false */
         pagination: false, // 在表格底部显示分页组件，默认false
         pageList: [5,10,15,20], // 设置页面可以显示的数据条数
         pageSize: 10, // 页面数据条数
         pageNumber: 1, // 首页页码,
         uniqueId:'UUID',
         //clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
         queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
         },
         columns: [
             {
                 checkbox: true, // 显示一个勾选框
                 align: 'center', // 居中显示
                 valign: 'middle'
             },{
                 field: 'FILE_NAME',
                 title: '文件名称',
                 align: 'left',
                 valign: 'middle',
                 width:400,
                 formatter: function (value, row, index) {
                	 if(row.fileImg){
                		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>'; 
                	 }
                	 else{
                		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img style="border-radius:5px" src="'+ctx+'/photo/photo.jsp?ls_photo='+row.FILE_SAVE_PATH+row.FILE_SVAE_NAME+'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>';
                	 }
                 }
             }, {
                 field: 'UPDATE_TIME',
                 title: '修改时间',
                 align: 'center',
                 valign: 'middle',
                 order:'asc',
                 sortable:'true'
             }, {
                 field: 'FILE_TYPE',
                 title: '类型',
                 align: 'center',
                 valign: 'middle'
             },{
                 field: 'FILE_SIZE',
                 title: '大小',
                 align: 'center',
                 valign: 'middle',
                 formatter: function (value, row, index) {
                	 return $.jfbrother.fileSizeToStr(row.FILE_SIZE);
                 }
             }
         ],
         //选中时隐藏菜单
         onCheck:function(row){
        	 $('#disk_menu').hide();
         },
         //当用户点击某一列的时候触发
         onClickCell:function(field, value, row, $element){
        	 if(field=='FILE_NAME'){        	
        		 //编辑,把td传入
        		 disk_editFolder_list($element);
        	 }
         },
         //当用户双击某一行的时候触发
         onDblClickRow:function(row, $element){
        	 //根据uuid重新渲染列表
        	 disk_list_dbClick(row,$element);
         },
         //当用户单击某一行的时候触发
         onClickRow:function(row, $element){
        	//选中这行
        	//在根据uuid来获得对象
     		$('#disk_content_list tr').each(function(index,element){
     			if($(element).data('uniqueid')==row.UUID){
     				var index = $(element).data('index');
     				//如果正处于编辑状态那就选中,否则就反着选
     				if($(element).find('.disk_content_list_fileName input').css('display')!='none'||!$(element).find('input[type="checkbox"]').prop('checked')){
     					$('#disk_content_list').bootstrapTable('check',index);
     				}
     				else{
     					$('#disk_content_list').bootstrapTable('uncheck',index);
     				}
     			}
     		})
         }
         //
   })
}

//初始化回收站的列表
function init_disk_rubbish_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
       /* showColumns:true,
       showToggle:true,
       showRefresh:true,
       search:true, */
       /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
       data:infos,
       cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
       /* striped: true,  //表格显示条纹，默认为false */
       pagination: false, // 在表格底部显示分页组件，默认false
       pageList: [5,10,15,20], // 设置页面可以显示的数据条数
       pageSize: 10, // 页面数据条数
       pageNumber: 1, // 首页页码,
       uniqueId:'UUID',
       clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
       queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
       },
       columns: [
           {
               checkbox: true, // 显示一个勾选框
               align: 'center', // 居中显示
               valign: 'middle'
           },{
               field: 'FILE_NAME',
               title: '文件名称',
               align: 'left',
               valign: 'middle',
               width:400,
               formatter: function (value, row, index) {
            	 if(row.fileImg){
              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>'; 
              	 }
              	 else{
              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img style="border-radius:5px;" src="'+ctx+'/photo/photo.jsp?ls_photo='+row.FILE_SAVE_PATH+row.FILE_SVAE_NAME+'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control" onblur="disk_input_blur(this)" /></div></div>';
              	 }  
               }
           }, {
               field: 'UPDATE_TIME',
               title: '删除时间',
               align: 'center',
               valign: 'middle',
               order:'asc',
               sortable:'true'
           }, {
               field: 'FILE_TYPE',
               title: '类型',
               align: 'center',
               valign: 'middle'
           },{
               field: 'FILE_SIZE',
               title: '大小',
               align: 'center',
               valign: 'middle'
           }
       ],
       //选中时隐藏菜单
       onCheck:function(row){
      	 $('#disk_rubbish_menu').hide();
       }
 })
}

//修改文件名
function disk_editFolder(handler){
	//右键删除时,如果是不能点击时
	if($(handler).hasClass('disk_menu_noClick')){
		return;
	}

	if($('.disk_content_toggleBtn').data('toggleList')){
		
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		//在根据id来获得对象
		$('#disk_content_list tr').each(function(index,element){
			if($(element).data('uniqueid')==list_rows[0].id){
				disk_editFolder_list($(element).find('.disk_content_list_fileName').parent());
				return false;
			}
		})
		
	}
	else{
		//如果是块状时
		var $lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		disk_click_div_edit($lump_rows.find('div'));
	}
}

//列表的编辑
function disk_editFolder_list(handler){
	var lump_data = $(handler).find('div').eq(2).data('lump_data');
	//如果是公司文件或者是共享文件则不能编辑
	if(lump_data.apiIndex=='1'||lump_data.apiIndex=='2'){
		return;
	}
	var $input = $(handler).find('input');
	$input.prev().hide();
	$input.show();
	$input.focus();
	$input.select();
}

//双击列表时
function disk_list_dbClick(row,handler){
	disk_dbClick_custom($(handler).find('.disk_content_list_fileName input'),row,function(infos){
		//如果是共享文件,那就显示共享的列表
		if(row.apiIndex=='2'){
			init_disk_enjoy_list(infos);
		}
		else{
			init_disk_list(infos);
		}
	});
	//如果是公司文件时
	if(row.FILE_TYPE=='folder_company'){
		$('.disk_content_header>div:first-child>a').hide();
		//显示下载按钮
		//$('.disk_content_header>div:first-child>a').eq(1).show();
	}
	else if(row.FILE_TYPE=='folder_share'){
		//显示取消共享的按钮
		$('.disk_content_header>div:first-child>a').hide();
		$('.disk_enjoyBtn').show();
	}
}

//块状以及列表的双击点击事件的提取,返回一个数组,callback回调
function disk_dbClick_custom(edit_input,lump_data,callback){
	//正处在编辑时不能双击
	if($(edit_input).css('display')!='none'){
		return;
	}
	//如果是文件时,则不能做点击效果
	if(lump_data.ISFILE=='1'){
		alert('在线预览')
		return;
	}
	//添加目录的导航效果
	var $search_center =  $('.disk_search_center');
	var $create_a = $('<a onclick="disk_backFolder(this)"></a>').data('lump_data',lump_data);;
	var $create_span1 = $('<span></span>').text($(edit_input).val());
	var $create_span2 = $('<span></span>').addClass('glyphicon glyphicon-triangle-right');
	$create_a.append($create_span1).append($create_span2);
	$search_center.append($create_a);
	var infos = init_disk_infos('0',lump_data);
	if(typeof callback == 'function'){
		callback(infos);
	}
}

//进入文件夹
function disk_enterFolder(handler){
	//右键进入文件夹时,如果是不能点击时
	if($(handler).hasClass('disk_menu_noClick')){
		return;
	}

	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		var uuid;
		//如果是共享文件,并且是共享文件的子目录,则根据file_uuid来获得对象
		if(list_rows[0].apiIndex=='2'&&$('.disk_search_center>a').eq(0).next().length!=0){
			uuid = list_rows[0].FILE_UUID;
		}
		//否则就用uuid来获得对象
		else{
			uuid = list_rows[0].UUID;
		}
		$('#disk_content_list tr').each(function(index,element){
			if($(element).data('uniqueid')==uuid){
				disk_list_dbClick(list_rows[0],$(element));				
				return false;
			}
		})
	}
	else{
		//如果是块状时
		var $lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		disk_lump_dbClick($lump_rows);
	}
}

//返回到最开始的展示情况
function disk_backFolder(handler){
	//如果已经是最后一个了
	if($(handler).next().length==0){
		return;
	}
	//清除之后的a
	$(handler).nextAll('a').remove();
	var lump_data = $(handler).data('lump_data');
	//获得数据列表
	var lump_infos = init_disk_infos('0',lump_data);
	//重新渲染数据
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		//重新渲染列表
		//如果是共享文件,那就显示共享的列表
		if(lump_data.apiIndex=='2'){
			init_disk_enjoy_list(lump_infos);
		}
		else{
			init_disk_list(lump_infos);
		}
	}
	else{
		//如果是块状时
		//根据一个json数据去渲染块状		
		//渲染块状
		//先清空容器		
		$('.disk_content_lump').html('');	
		for(var i = 0 ; i<lump_infos.length;i++){
			init_disk_createLump(lump_infos[i]);
		}
	}
}

//移动文件
function disk_moveFolder(handler){
	disk_confirm(handler,'移动文件',null,function(list_rows,uuids,list_data){			
		var strVar = "";
	    strVar += "<div style=\"width:650px;padding:0px;border-radius:5px;overflow:hidden;\">\n";
	    strVar += "	<div class=\"disk_move_title\"><span>移动文件<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
	    strVar += "	<div class=\"disk_move_search\"><input id=\"disk_move_key\" placeholder=\"搜索文件夹\" type=\"text\" ><span id=\"disk_move_btn\">搜索</span><\/div>\n";
	    strVar += "	<div id=\"disk_move_tree\" style=\"height:300px;overflow:auto;\" class=\"ztree disk_move_tree\"><\/div>\n";
	    strVar += "	<div class=\"disk_move_btn\">\n";
	    strVar += "		<span>确定<\/span><span onclick=\"$.fancybox.close()\">取消<\/span>\n";
	    strVar += "	<\/div>\n";
	    strVar += "<\/div>\n";
	    
	    $.fancybox.open(strVar,{
	    	//显示之前触发
	    	beforeShow : function( instance, current ) {
	    		//去掉fancybox原来的间距
	    		/*$('.fancybox-opened').css('width','268px');*/
	    		$('.fancybox-skin').css('padding','0');
			},
			//显示之后触发
	    	afterShow : function( instance, current ){
	    		//隐藏右上角的X
	    		$('.fancybox-close').hide();
	    	}
	    });
		
	    //绑定确定按钮的操作
	    $('.disk_move_btn>span').eq(0).bind('click',function(){
	    	disk_moveFolder_save(list_data);
	    })
	    
		//初始化文件目录
		init_disk_move_tree(list_data);
		
	    //树的查询功能
	    $.jfbrother.fuzzySearch('disk_move_tree','#disk_move_key',true,true,'#disk_move_btn'); 
	});     
}

//文件移动的保存
function disk_moveFolder_save(lump_data_list){
	var treeObj = $.fn.zTree.getZTreeObj("disk_move_tree");
	//获取选中的树数据
	var nodes = treeObj.getSelectedNodes();
	if(nodes.length!=0){
		for(var i = 0;i<lump_data_list.length;i++){
			var result = storePersonalModule.storePersonalActAction.updateStorePersonal({
				FIELD_UUID:lump_data_list[i].UUID,
				FIELD_FATHER_ID:nodes[0].UUID		
			});			
		}		
		
		//获得目录的最后一个数据
		var nav_lump_data = $('.disk_search_center>a:last').data('lump_data');
		var infos = init_disk_infos('0',nav_lump_data);
		//重新渲染显示的内容
		if($('.disk_content_toggleBtn').data('toggleList')){
			init_disk_list(infos);
		}
		else{	
			//先清空容器
			$('.disk_content_lump').html('');
			if(infos.length==0){
				//无数据时块状的填充
				init_disk_lump_noFile(nav_lump_data);
			}
			else{
				//渲染块状
				for(var i = 0 ; i<infos.length;i++){
					init_disk_createLump(infos[i]);
				}
			}			
		}		
	}
	
	$.fancybox.close();
}

//选择共享人之后的保存,做了多选文件的共享(暂时只能单文件)
function disk_enjoyUser_save(lump_data){
	//选择人员数据
	var infos = $('#disk_selectUser_list').bootstrapTable('getSelections');
	var query = {};
	var uuids = '';
	var userIds = '';
	for(var i = 0 ; i< lump_data.length;i++){
		uuids = uuids + lump_data[i].UUID+',';
	}
	for(var i = 0 ; i< infos.length;i++){
		userIds = userIds + infos[i].USER_ID+',';
	}
	uuids = uuids.substring(0, uuids.length-1);
	userIds = userIds.substring(0, userIds.length-1);
	if(userIds == ''){
		$('.disk_selectUser_table_title>label').fadeIn().delay(3000).fadeOut();	
		return;
	}
	query.FIELD_CODE = uuids;
	query.FIELD_USER_ID = userIds;
	var result = storePersonalModule.storePersonalActAction.shareStorePersonal(query);
	$.fancybox.close();
}

//取消共享操作
function disk_cancelEnjoy(handler){
	//如果是子目录中的共享,则做个提示操作
	if($('.disk_search_center>a').eq(1).next().length!=0){
		var txt =  '只能取消共享根目录!!!';
		var option = {
			title: '取消共享提示',
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.error,option);
		return;
	}
	disk_confirm(handler,'取消共享',function(list_rows,uuids){
		//数据库的取消共享信息
		var result = disk_cancelEnjoy_sql(uuids);
	});
}

//取消共享的数据库操作
function disk_cancelEnjoy_sql(uuids){
	var query = {};
	query.FIELD_CODE=uuids;
	//先软删除
	var result1 = storeShareModule.storeShareActAction.deleteStoreShare(query);
	//再真正的删除
	var result2 = storeShareModule.storeShareActAction.deleteTrueStoreShare(query);
}

//初始化文件时移动的目录
function init_disk_move_tree(rows_data){
	var ztreeData = storePersonalModule.storePersonalDataAction.listTreeEasyui().rowSet;
	
	//处理下返回来的数据
	ztreeData = disk_custom_moveTree_data(rows_data,ztreeData); 
	//console.log(ztreeData);
	for(var i =0;i<ztreeData.length;i++){
		init_disk_select_fileImg(ztreeData[i]);
	}
	
	var zTreeObj;
	// zTree 的参数配置，深入使用请参考 API 文档（setting 配置详解）
	var setting = {
		callback : {
			onClick : function(event, treeId, treeNode) {
				//$('#' + treeNode.tId).find('.curSelectedNode').removeClass('curSelectedNode');
			}
		},
		data : {
			simpleData : {
				enable : true,
				idKey : "UUID",
				pIdKey : "FATHER_ID",
				rootPId : 'A'
			},
			key:{
				name:'FILE_NAME'
			}
		},
		view : {
			nameIsHTML : true,
			showTitle : true,
			//双击节点时，是否自动展开父节点的标识,true / false 分别表示双击节点 切换 / 不切换 展开状态
			dblClickExpand : true,
			//点击节点时，按下 Ctrl 或 Cmd 键是否允许取消选择操作。
			autoCancelSelected : false,
			//是否显示连线
			showLine: false
		}
	};

	// zTree 的数据属性，深入使用请参考 API 文档（zTreeNode 节点数据详解）

	zTreeObj = $.fn.zTree.init($("#disk_move_tree"), setting, ztreeData);

	//展开根节点
	/*function filter(node) {
		return (node.pid == 0);
	}
	var filter_nodes = zTreeObj.getNodesByFilter(filter); // 查找根节点集合 
	for (var i = 0; i < filter_nodes.length; i++) {
		zTreeObj.expandNode(filter_nodes[i], true, true, true);
	}*/

}

//处理下返回来的数据
function disk_custom_moveTree_data(lump_data_list,ztreeData){
	var new_data = [];
	//初步过滤掉已经软删除的文件夹,并且修改了根节点的显示文字和图标
	for(var i = 0 ; i<ztreeData.length;i++){
		//修改根节点
		if(ztreeData[i].UUID=='A'){
			ztreeData[i].icon = 'custom/images/disk_module5_close.png';
			ztreeData[i].FILE_NAME = '根目录';
		}
		//多个被选中时
		var flag = true;
		for(var j = 0 ; j < lump_data_list.length;j++){			
			//把删除的文件夹过滤掉,把自身也过滤掉
			if((ztreeData[i].DELETE_FLAG&&ztreeData[i].DELETE_FLAG=='1')||ztreeData[i].UUID==lump_data_list[j].UUID){
				flag = false ;
				break;
			}
		}
		if(flag){	
			new_data.push(ztreeData[i]);
		}
	}
	//根据点击的uuid去做递归过滤掉其子目录
	var list =  disk_custom_moveTree_data_filter(lump_data_list,new_data);
	return list;
}

//移动文件时的递归过滤数据
function disk_custom_moveTree_data_filter(lump_data_list,ztreeData){	
	var new_ztreeDate = [];
	var fatherId_list = [];
	for(var i = 0 ; i < lump_data_list.length;i++){
		for(var j = 0 ; j < ztreeData.length;j++){
			if(ztreeData[j].FATHER_ID&&ztreeData[j].FATHER_ID==lump_data_list[i].UUID){
				var new_uuid = {};
				new_uuid.UUID=ztreeData[j].UUID;
				fatherId_list.push(new_uuid);
			}
		}		
	}
	if(fatherId_list.length==0){
		return ztreeData;
	}
	for(var i = 0 ; i < ztreeData.length;i++){
		var isFilter = false ;
		for(var j = 0 ; j < fatherId_list.length;j++){
			if(ztreeData[i].UUID == fatherId_list[j].UUID){
				//表示该数据要过滤掉
				isFilter = true;
			}
		}
		if(isFilter==false){
			new_ztreeDate.push(ztreeData[i]);
		}
	}
	return disk_custom_moveTree_data_filter(fatherId_list,new_ztreeDate);
}


//初始化共享人的树
function init_disk_enjoyUser_tree(rows_data){	
	var ztreeData = userchoiceModule.userchoiceDataAction.listUnitAll().rowSet;
	for(var i = 0 ;i<ztreeData.length;i++){
		ztreeData[i].icon = 'custom/images/disk_selectUser_unit.png';
		//所有都显示文件夹的样子
		//ztreeData[i].isParent=true; 
	}
	
	//还要做一步过滤
	//1.把自身及以下文件过滤掉
	//2.所有节点不是文件夹的过滤掉
	
	var zTreeObj;
	// zTree 的参数配置，深入使用请参考 API 文档（setting 配置详解）
	var setting = {
		callback : {
			onClick : function(event, treeId, treeNode) {
				//查询
				init_disk_enjoyUser_list_search();
			}
		},
		data : {
			simpleData : {
				enable : true,
				idKey : "UNIT_ID",
				pIdKey : "PARENT_UNITID",
				rootPId : "A"
			},
			key: {
				name: "NAME"
			}
		},
		view : {
			nameIsHTML : true,
			showTitle : true,
			//双击节点时，是否自动展开父节点的标识,true / false 分别表示双击节点 切换 / 不切换 展开状态
			dblClickExpand : true,
			//点击节点时，按下 Ctrl 或 Cmd 键是否允许取消选择操作。
			autoCancelSelected : false,
			//是否显示连线
			showLine: false
		}
	};

	// zTree 的数据属性，深入使用请参考 API 文档（zTreeNode 节点数据详解）
	zTreeObj = $.fn.zTree.init($("#disk_enjoyUser_tree"), setting, ztreeData);

	//展开根节点下面的第一层
	function filter(node) {
		return (node.UNIT_ID == 0);
	}
	var filter_nodes = zTreeObj.getNodesByFilter(filter); // 查找根节点集合 
	for (var i = 0; i < filter_nodes.length; i++) {
		zTreeObj.expandNode(filter_nodes[i], true, false, true);
	}
	
	//去掉加载的效果
	$('#disk_enjoyUser_tree').prev().remove();
}

//初始化某个单位的人员列表
function init_disk_enjoyUser_list(rows_data){
	/*var infos = userchoiceModule.userchoiceDataAction.listUser().rowSet;
	console.log(infos)*/
	$('#disk_selectUser_list').bootstrapTable('destroy').bootstrapTable({
	     /* showColumns:true,
	     showToggle:true,
	     showRefresh:true,
	     search:true, */
	     url: ctx+"/userchoiceData_listUser", // 获取表格数据的url
		 /*data:infos,*/
	     cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
	     /* striped: true,  //表格显示条纹，默认为false */
	     sidePagination: "server", //分页方式：client客户端分页，server服务端分页（*）
	     responseHandler: function(res) {
	    	 return {  
	    		 "total": res.total,//总页数	
                 "rows": res.rowSet   //数据
              };
	     },//加载服务器数据之前的处理程序，可以用来格式化数据。  参数：res为从服务器请求到的数据。
	     pagination: true, // 在表格底部显示分页组件，默认false
	     pageList: [5,10,15,20], // 设置页面可以显示的数据条数
	     pageSize: 10, // 页面数据条数
	     pageNumber: 1, // 首页页码,
	     uniqueId:'UNIT_ID',
	     clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
	     queryParams:function(params){
			var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				//limit: params.limit,   //页面大小  
				//offset: params.offset,  //页码  
				rows:this.pageSize,  
				FIELD_USER_NAME:$('#disk_enjoyUser_list_search_key').val(),
				FIELD_UNIT_ID:$.fn.zTree.getZTreeObj("disk_enjoyUser_tree").getSelectedNodes()[0]?$.fn.zTree.getZTreeObj("disk_enjoyUser_tree").getSelectedNodes()[0].UUID:''
				/* projectId: $("#projectId").val(),  
				requirement_Id:$("#requirement_Id").val(),  
				length: 6  */ 
			};  
			return temp;
	     },
	     columns: [
	         {
	             checkbox: true, // 显示一个勾选框
	             align: 'center', // 居中显示
	             valign: 'middle'
	         },{
	             field: 'ID_NUMBER',
	             title: '人员账号',
	             align: 'left',
	             valign: 'middle'
	         }, {
	             field: 'REAL_NAME',
	             title: '姓名',
	             align: 'center',
	             valign: 'middle'/*,
	             order:'asc',
	             sortable:'true'*/
	         },{
	             field: 'USER_SEX',
	             title: '性别',
	             align: 'center',
	             valign: 'middle',
	             formatter: function (value, row, index) {
            		 //0无性别,1为男,2为女
	            	 if(value=='1'){
	            		 return '男';
	            	 }
	            	 else if(value == '2'){
	            		 return '女';
	            	 }
	            	 else{
	            		 return '-';
	            	 }
	             }
	         },{
	             field: 'MOBILE',
	             title: '手机号',
	             align: 'center',
	             valign: 'middle'
	         },{
	             field: 'EMAIL',
	             title: '邮箱',
	             align: 'center',
	             valign: 'middle'
	         }
	     ],
	     onLoadSuccess:function(){
	    	 //去掉加载的效果
	    	 $('.disk_selectUser_content>div').eq(1).children('div').children('img').parent('div').remove();	   
	     }
	})
}

//选择人员的查询功能
function init_disk_enjoyUser_list_search(){
    $("#disk_selectUser_list").bootstrapTable('selectPage',1);
}

//初始化文件的图片
function init_disk_select_fileImg(ztreeData){
	if(',jpg,png,jpeg,gif,'.indexOf(','+ ztreeData.FILE_TYPE +',')==-1){
		//非图片类型需要判断显示的图片
		//iconOpen:文件夹树形结构打开图片
		//iconClose:文件夹树形结构关闭图片
		//icon:文件夹树形结构叶子图片
		//fileImg:桌面显示图片
		switch (ztreeData.FILE_TYPE) {
		case 'folder_company':
			ztreeData.iconOpen='custom/images/disk_module1.png';
			ztreeData.iconClose='custom/images/disk_module1_close.png';
			ztreeData.icon='custom/images/disk_module1_close.png';
			ztreeData.fileImg='disk_module1_close.png';
			break;
		case 'folder_share':
			ztreeData.iconOpen='custom/images/disk_module2.png';
			ztreeData.iconClose='custom/images/disk_module2_close.png';
			ztreeData.icon='custom/images/disk_module2_close.png';
			ztreeData.fileImg='disk_module2_close.png';
			break;
		/*case 'folder_myFile':
			ztreeData.iconOpen='custom/images/disk_module3.png';
			ztreeData.iconClose='custom/images/disk_module3_close.png';
			ztreeData.icon='custom/images/disk_module3_close.png';
			ztreeData.fileImg='disk_module3_close.png';
			break;
		case 'folder_myShare':
			ztreeData.iconOpen='custom/images/disk_module4.png';
			ztreeData.iconClose='custom/images/disk_module4_close.png';
			ztreeData.icon='custom/images/disk_module4_close.png';
			ztreeData.fileImg='disk_module4_close.png';
			break;*/
		case 'folder':
			ztreeData.iconOpen='custom/images/disk_module5.png';
			ztreeData.iconClose='custom/images/disk_module5_close.png';
			ztreeData.icon='custom/images/disk_module5_close.png';
			ztreeData.fileImg='disk_module5_close.png';
			break;
		case 'rar':
			ztreeData.fileImg='disk_rar.png';
			break;
		case 'txt':
			ztreeData.fileImg='disk_txt.png';
			break;
		case 'ppt':
			ztreeData.fileImg='disk_ppt.png';
			break;
		case 'pdf':
			ztreeData.fileImg='disk_pdf.png';
			break;
		case 'excel':
			ztreeData.fileImg='disk_excel.png';
			break;
		case 'word':
			ztreeData.fileImg='disk_word.png';
			break;
		default:
			ztreeData.fileImg='disk_unknow.png';
			break;
		}
	}
}

//文件的下载
function disk_downFolder(handler){
	//右键下载文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	var list_rows;
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		list_rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		//如果是块状时
		list_rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	
	if(list_rows.length==0){
		var txt =  "请选择要下载的文件!!!";
		var option = {
			title: "下载提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.confirm,option);
	}
	else{
		var txt2 =  "是否要下载选中的文件!!!";
		var option2 = {
			title: "下载提示",
			onOk: function(){
				var lump_data_obj ;
				if($(list_rows).data('lump_data')){
					lump_data_obj = $(list_rows).data('lump_data');
				}
				else{
					lump_data_obj = list_rows[0];
				}
				//下载文件
				var uploadnew = lump_data_obj.FILE_SVAE_NAME;
				var uploadpath = lump_data_obj.FILE_SAVE_PATH;
				var uploadold = lump_data_obj.FILE_NAME;
				var uuid = lump_data_obj.UUID;				
				if(uploadpath == null || uploadpath == ""){
					var txt4 =  "没有文件可以下载!!!";
					var option4 = {
						title: "下载提示",
						btn:parseInt("0001",2)
					}
					window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.confirm,option4);
					return;
				}
				//如果是公司文件时,调的接口不一样
				if(lump_data_obj.apiIndex='1'){
					fileDownloadURL(uploadnew,uploadpath,uploadold,uuid,'storeAct_download');
				}
				else{
					fileDownloadURL(uploadnew,uploadpath,uploadold,uuid,'storePersonalAct_download');
				}
				//end
			}
		}
		window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.warning,option2);
	}
}

//上传文件的显示
function disk_uploadFolder(handler){
	//右键上传文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	var strVar = "";
    strVar += "<div class=\"row\" style=\"margin:0px;width:800px;padding: 0px;border-radius: 5px;overflow: hidden;\">\n";
    strVar += "	<div class=\"disk_move_title\"><span>选择文件上传<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
    strVar += "	<div class=\"disk_upload_content col-md-12\">\n";
    strVar += "		<div class=\"col-md-6 disk_upload_left_content\">\n";
    strVar += "			<div class=\"disk_upload_left_content_container\" id=\"disk_upload_drop\" >\n";
    strVar += "				<img src=\"custom/images/disk_uploadBg.png\" width=\"70\" height=\"60\" />\n";
    strVar += "				<div><span id=\"disk_upload_btn\">选择文件上传<\/span><input id=\"disk_upload_btn_input\" type=\"file\" style=\"display:none;\" multiple=\"multiple\" /><\/div>\n";
    strVar += "				<div>或者将文件拖拽到此处<\/div>\n";
    strVar += "				<div>可一次选择多个文件( <span style=\"color:#999;font-weight:bold\">目前最大单个上传支持10M!<span> )<\/div>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div class=\"col-md-6\">\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_header\">\n";
    strVar += "				<div class=\"col-md-7\">文件名<\/div>\n";
    strVar += "				<div class=\"col-md-5\">文件大小<\/div>\n";
    strVar += "			<\/div>\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_content\">\n";
    /*strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>1.<\/span><span title=\"ASP操作手册ASP操作手册ASP操作手册.doc\">ASP操作手册ASP操作手册ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>12KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\" style=\"display:none;\">\n";
    strVar += "						 	<div style='width:50%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\" style=\"display:inline-block;\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";
    strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>10.<\/span><span title=\"ASP操作手册.doc\">ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>1024KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\">\n";
    strVar += "						 	<div style='width:90%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";
    strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>110.<\/span><span title=\"ASP操作手册.doc\">ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>12KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\">\n";
    strVar += "						 	<div style='width:20%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";*/
    strVar += "			<\/div>\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_bottom\">\n";
    strVar += "				已选择<span id=\"disk_upload_fileCount\">0<\/span>个文件,共<span id=\"disk_upload_fileSize\">0B<\/span>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "	<div id=\"disk_upload_message\" style=\"text-align: center;margin-bottom: 0px;display:none;\" class=\"alert alert-danger col-md-12\" role=\"alert\">\n";
    strVar += "		<a href=\"#\" class=\"alert-link\">上传失败<\/a>\n";
    strVar += "	<\/div>\n";
    strVar += "	<div class=\"disk_upload_btn col-md-12\">\n";
    strVar += "		<div class=\"col-md-6\"><\/div>\n";
    strVar += "		<div class=\"col-md-6\"><span>上传<\/span><span onclick='$.fancybox.close()'>取消<\/span><\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "<\/div>\n";
    
    var webupload;
	$.fancybox.open(strVar,{
		//显示之前触发
    	beforeShow : function( instance, current ) {
    		//去掉fancybox原来的间距
    		$('.fancybox-skin').css('padding','0');
		},
		//显示之后触发
    	afterShow : function( instance, current ){
    		//隐藏右上角的X
    		$('.fancybox-close').hide();
    		
    		//初始化上传按钮
    		webupload = init_disk_upload();
    	},
    	//关闭之前触发
    	beforeClose : function( instance, current ) {
    		if(webupload.getFiles('progress').length!=0){
    			$('#disk_upload_message>a').text('文件正在上传,请等待...');
				$('#disk_upload_message').fadeIn().delay('3000').fadeOut();
    			return false;
    		}
    		if($('.disk_upload_right_content>div').length!=0){
    			var flag = false;
    			$('.disk_upload_right_content>div').each(function(index,element){
    				//如果有文件上传完,则要重新加载页面
    				if($(element).find('.glyphicon-ok').css('visibility')!='hidden'){
    					flag = true ;
        			}
        		})        	
        		if(flag == true){
        			var lump_data = $('.disk_search_center>a:last').data('lump_data');
        			infos = init_disk_infos('0',lump_data);
        			if($('.disk_content_toggleBtn').data('toggleList')){
        				//如果是列表时
    					init_disk_list(infos);
        			}
        			else{
        				//如果是块状时
        				//根据一个json数据去渲染块状		
        				//先清空容器		
        				$('.disk_content_lump').html('');	
        				for(var i = 0 ; i<infos.length;i++){
        					init_disk_createLump(infos[i]);
        				}
        			}
        			//
        		}
    		}
    		//
		},
	});
	
	//初始化文件的拖拉上传
	init_disk_drop();
}

//初始化上传按钮
function init_disk_upload(){
	var max_size = 1024 * 1024 * 10;//10M
	//渲染上传按钮
	var webupload = $('#disk_upload_btn_input').webupload({
		server: 'storePersonalAct_upload',
		dnd:'#disk_upload_drop',
		auto:false,
		pick:{
			multiple:true
		},
		accept : {
			/*title : 'Images',
			extensions : 'gif,jpg,jpeg,bmp,png',
			mimeTypes : 'image/*'*/
			title: 'intoTypes',
            extensions: 'rar,zip,doc,xls,docx,xlsx,pdf,txt,gif,jpg,jpeg,bmp,png',
            mimeTypes: '.rar,.zip,.doc,.xls,.docx,.xlsx,.pdf,.txt,image/*' 
		},
		fileVal : "userFile" ,//指明参数名称，后台也用这个参数接收文件
		fileSingleSizeLimit : max_size,   //验证单个文件大小是否超出限制, 超出则不允许加入队列。10M
		fileSizeLimit : undefined,  //验证文件总大小是否超出限制, 超出则不允许加入队列。
		fileNumLimit:undefined,		
		filesQueued:function(files){
			for(var i=0;i<files.length;i++){
				disk_create_uploadList(files[i],webupload);
			}
		},	
		//加入队列之前
		beforeFileQueued:function(file){
			if(file.size>max_size){
				$('#disk_upload_message>a').text('单个文件超出了最大值!!!');
				$('#disk_upload_message').fadeIn().delay('3000').fadeOut();
			}
		},		
		uploadSuccess:function(file,ret){
			var result_obj = JSON.parse(ret._raw.replace('<textarea>','').replace('</textarea>','')).file;
			var fpath = result_obj.split(',')[0];
			var fileOld = result_obj.split(',')[1];
			var filePath = fpath.substring(0,fpath.lastIndexOf("/")+1);
			var filenew = fpath.substring(fpath.lastIndexOf("/")+1);
			var fatherId ;
			var last_lump_data = $('.disk_search_center>a:last').data('lump_data');
			if(!last_lump_data){
				fatherId = 'A';
			}
			else{
				fatherId = last_lump_data.UUID;
			}
			var is_entity = {};
			is_entity.FIELD_FILE_NAME = fileOld;
			is_entity.FIELD_FILE_SVAE_NAME = filenew;
			is_entity.FIELD_FILE_SAVE_PATH = filePath;
			is_entity.FIELD_MODULE_ID = '3';
			is_entity.FIELD_ISFILE = '1';
			is_entity.FIELD_FATHER_ID = fatherId;
			var v_result = storePersonalModule.storePersonalActAction.insertStorePersonal(is_entity);
			if(v_result.NAME='999'){
				var fileId = file.id;
				$('.disk_upload_right_content>div').each(function(index,element){
					var data = $(element).data('upload_data');
					if(data.id==fileId){					
						$(element).find('.glyphicon-ok').css('visibility','visible');
					}
				})
			}
			else{
				$('#disk_upload_message>a').text('上传失败!!!');
				$('#disk_upload_message').fadeIn().delay('3000').fadeOut();
			}
			//
		}
	});
	//点击图片时
	$('#disk_upload_btn').bind('click',function(){
		$('#disk_upload_btn_input').find('label').click();
	});
	
	//绑定一个上传的操作
	$('.disk_upload_btn').find('span').eq(0).bind('click',function(){
		disk_uploadFile_save(webupload);
	})

	return webupload;
}

//初始化文件的拖拉上传
function init_disk_drop(){
	var drop_content = $('#disk_upload_drop')[0];
	//当被鼠标拖动的对象进入其容器范围内时触发此事件
	drop_content.ondragenter = function(event) {  
		//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#ccc');
    }
	//当被鼠标拖动的对象离开其容器范围内时触发此事件
	drop_content.ondragleave = function(event) {  
		//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#eee');
    }
	//当某被拖动的对象在另一对象容器范围内拖动时触发此事件
    drop_content.ondragover = function(event) {  
    	//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#ccc');
    }  
    //在一个拖动过程中，释放鼠标键时触发此事件
	drop_content.ondrop = function(event) {
		$(this).css('borderColor','#eee');
		//阻止默认行为
		$.jfbrother.preventDefualt();  
        //拖入的文件必须是外部的，不能使浏览器内的  
    }
}

//根据一个json来渲染上传文件的列表
function disk_create_uploadList(json_data,webupload){
	var $contaner = $('<div></div>').addClass('col-md-12');
	$contaner.data('upload_data',json_data);
	
	var $contaner_left = $('<div></div>').addClass('col-md-7');
	var $contaner_right = $('<div></div>').addClass('col-md-5');
	$contaner.append($contaner_left).append($contaner_right);
	
	//索引
	var $index_span = $('<span></span>');
	var file_index = $('.disk_upload_right_content>div').length+1;
	$index_span.text(file_index+'.');
	//文件名
	var $file_name = $('<span></span>');
	$file_name.attr('title',json_data.name);
	$file_name.text(json_data.name);
	$contaner_left.append($index_span).append($file_name);
	
	//文件大小
	var $file_size = $('<span></span>');
	$file_size.text($.jfbrother.fileSizeToStr(json_data.size));
	$file_size.attr('title',$.jfbrother.fileSizeToStr(json_data.size));
	/*//进度条
	var $progress = $('<div></div>').addClass('progress disk_progress');
	var $progress_value = $('<div class="progress-bar progress-bar-striped active" role="progressbar"></div>');
	$progress_value.css('width','0%');
	$progress.append($progress_value);*/
	//ok
	var $ok_span = $('<span></span>').addClass('glyphicon glyphicon-ok');
	/*//pause
	var $pause_span = $('<span></span>').addClass('glyphicon glyphicon-pause');
	$pause_span.bind('click',disk_uploadFile_stop);*/
	//remove
	var $remove_span = $('<span></span>').addClass('glyphicon glyphicon-remove');
	$remove_span.bind('click',function(){
		//删除前先清空队列中的
		/*var file = webupload.getFile(json_data.id);
		console.log(file)
		console.log(json_data)*/
		webupload.removeFile(json_data,true);
		disk_uploadFile_remove($(this));
	});
	
	$contaner_right.append($file_size).append($ok_span).append($remove_span);
	//$contaner_right.append($file_size).append($progress).append($ok_span).append($pause_span).append($remove_span);
	
	$('.disk_upload_right_content').append($contaner);
	
	//计算文件的大小以及个数
	$('#disk_upload_fileCount').text(file_index);
	var old_size = $('#disk_upload_fileSize').data('old_size') || 0;
	var new_size = old_size + json_data.size;
	$('#disk_upload_fileSize').text($.jfbrother.fileSizeToStr(new_size));
	//把原来的大小存放起来,便于以后的计算
	$('#disk_upload_fileSize').data('old_size',new_size);
}

//上传文件的删除
function disk_uploadFile_remove(handler){
	//去掉上传信息
	var $container = $(handler).parent().parent();
	var file_size = $container.data('upload_data').size;
	//删除节点之后的所有文件信息的索引都减一
	$container.nextAll().each(function(index,element){
		var $span_index = $(element).children('div').eq(0).find('span').eq(0);
		var index = $span_index.text();
		$span_index.text(index.substring(0, index.length-1)-1+'.');
	})
	$container.remove();
	
	//修改文件个数和大小
	$('#disk_upload_fileCount').text($('#disk_upload_fileCount').text()-1);
	var old_size = $('#disk_upload_fileSize').data('old_size');
	var new_size = old_size-file_size;
	$('#disk_upload_fileSize').text($.jfbrother.fileSizeToStr(new_size));
	//把原来的大小存放起来,便于以后的计算
	$('#disk_upload_fileSize').data('old_size',new_size);
}

/*//文件上传的暂停和开始
function disk_uploadFile_stop(){
	if($(this).hasClass('glyphicon-pause')){
		//暂停
		
	}
	else{
		//开始
		
	}
	//进度条的动态效果
	$(this).prev().prev().find('.progress-bar').toggleClass('active');
	//修改图标
	$(this).toggleClass('glyphicon-play');
	$(this).toggleClass('glyphicon-pause');	 
}*/

//文件的真正上传按钮的操作
function disk_uploadFile_save(webupload){
	//先判断容量是否超限
	var is_full_size = storePersonalModule.storePersonalDataAction.isfullsize();
	var is_full_size_value = "";
	if(is_full_size.rowSet.length==0){
		is_full_size_value = '1';
	}else{
		is_full_size_value = is_full_size.rowSet[0].IS_FULL;
	}
	if(is_full_size_value=='0'){
		$('#disk_upload_message>a').text('当前用户容量超限,无法新增文件,请整理自已的文件!');
		$('#disk_upload_message').fadeIn().delay('3000').fadeOut();
		return;
	}
	webupload.upload();
}

//显示回收站
function disk_rubbish(){
	//删掉目录导航栏
	$('.disk_search_center>a').eq(0).nextAll().remove();
	
	//显示切换按钮
	$('.disk_content_toggleBtn').show();
	//标记下是否是切换到了回收站
	$('#disk_rubbish').data('rubbish',true);
	
	//获取回收站的列表
	var infos = init_disk_infos('1');
	
	$('.disk_content_header>div:first-child>a').hide();
	$('.disk_rubbishBtn').show();
	
	//如果是列表时,或者是在分享码的列表时
	if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
		//渲染列表
		init_disk_rubbish_list(infos);
	}
	else{
		//渲染块状
		//先清空容器
		$('.disk_content_lump').html('');
		//渲染块状
		if(infos.length==0){
			//为文件时的显示
			init_disk_lump_noFile();
		}
		for(var i = 0 ; i<infos.length;i++){
			init_disk_createLump(infos[i]);
		}	
	}
}

//还原文件
function disk_reductionFolder(handler){
	disk_confirm(handler,'还原',function(list_rows,uuids){
		//删除数据库的信息
		var result = disk_reductionFolder_sql(uuids);
	});
}

//数据库的还原操作
function disk_reductionFolder_sql(uuids){
	var result = storePersonalModule.storePersonalActAction.resumeStorePersonal({
		FIELD_CODE : uuids
	});
	return result;
}

//彻底删除文件
function disk_thoroughDeleteFolder(handler){
	disk_confirm(handler,'彻底删除',function(list_rows,uuids){
		//删除数据库的信息
		var result = disk_thoroughDeleteFolder_sql(uuids);
	});
}

//数据库的彻底删除操作
function disk_thoroughDeleteFolder_sql(uuids){
	var result = storePersonalModule.storePersonalActAction.deleteTrueStorePersonal({
		FIELD_CODE : uuids
	});
	return result;
}

//提示操作的提取
function disk_confirm(handler,txt,sqlCallback,customCallback){
	//右键操作时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	var list_rows ;
	//如果是普通列表或者是分享码的列表时
	if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
		list_rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		list_rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	if(list_rows.length==0){
		var txt1 =  '请选择要'+txt+'的文件或文件夹!!!';
		var option1 = {
			title: txt+'提示',
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt1, window.wxc.xcConfirm.typeEnum.confirm,option1);
		return;
	}
	var txt3 =  '是否要'+txt+'选中的文件或文件夹!!!';
	var option3 = {
		title: txt+'提示',
		onOk: function(){
			//获得删除的数据列表
			var lump_datas = [];
			var uuids = '';
			for(var i = 0 ; i < list_rows.length ; i++){
				var list_row_obj;				
				if($(list_rows[i]).data('lump_data')){
					list_row_obj = $(list_rows[i]).data('lump_data');
				}
				else{
					list_row_obj = list_rows[i] ;
				}
				
				//存在公司文件或者是共享文件则退出
				if(list_row_obj.FILE_TYPE=='folder_company'||list_row_obj.FILE_TYPE=='folder_share'){
					var txt2 =  '存在无法'+txt+'的文件夹!!!';
					var option2 = {
						title: txt+'提示',
						btn:parseInt("0001",2)
					}
					window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.error,option2);
					return;
				}
				
				//删除的时候做的判断
				if(txt=='删除'){
					//存在下级目录或文件,已共享文件,已分享文件时则退出
					var error_txt = '';				
					if(list_row_obj.apiIndex=='0'&&list_row_obj.FILENUMBER>0){
						error_txt = '存在下级文件或目录或回收站里存在下级文件或目录,无法删除!';
					}
					if(list_row_obj.apiIndex=='0'&&list_row_obj.GXCOUNT>0){
						error_txt = '存在已共享文件或目录,无法删除!';
					}
					if(list_row_obj.apiIndex=='0'&&list_row_obj.FXCOUNT>0){
						error_txt = '存在已分享文件或目录,无法删除!';
					}
					if(error_txt!=''){
						var txt4 =  error_txt;
						var option4 = {
							title: '删除提示',
							btn:parseInt("0001",2)
						}
						window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.error,option4);
						return;
					}
				}
				
				//如果是共享文件时,则FILE_UUID是真正的UUID
				if(list_row_obj.apiIndex=='2'){
					uuids = uuids + list_row_obj.FILE_UUID + ',';
				}
				else{
					uuids = uuids + list_row_obj.UUID + ',';	
				}
				lump_datas.push(list_row_obj);
			}
			uuids = uuids.substring(0, uuids.length-1);
			if(typeof sqlCallback == 'function'){
				//把选中的行,uuids和选中的数据都传回去
				sqlCallback(list_rows,uuids,lump_datas);
			}				
			if(typeof customCallback == 'function'){
				//把选中的行,uuids和选中的数据都传回去
				customCallback(list_rows,uuids,lump_datas);
			}
			else{
				//删除页面的
				for(var i = 0 ; i < list_rows.length ; i ++){
					//如果是普通列表或者是分享码的列表时
					if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
						//如果是共享文件那就根据file_uuid来删除行
						if(list_rows[i].apiIndex=='2'){
							$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].FILE_UUID);
						}
						//否则根据uuid来删除行
						else{
							$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].UUID);
						}
					}
					else{
						$(list_rows[i]).parent().remove();
					}
				}
				var last_lump_data = $('.disk_search_center>a:last').data('lump_data');
				if($('.disk_content_lump>div').length==0){
					//如果没文件时的显示
					init_disk_lump_noFile(last_lump_data);
				}
			}
		}
	}
	window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.warning,option3);
}

//文件的分享
function disk_shareFolder(handler){
	disk_confirm(handler,'分享',null,function(list_rows,uuids,list_data){			
			var strVar = "";
		    strVar += "<div class=\"row\" style=\"margin:0px;width:468px;padding: 0px;border-radius: 5px;overflow: hidden;\">\n";
		    strVar += "	<div class=\"disk_move_title\">分享文件/文件夹 : <span><\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
		    strVar += "	<div class=\"disk_createShare\">\n";
		    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
		    strVar += "			<div class=\"col-md-3\">分享的形式 : <\/div>\n";
		    strVar += "			<div class=\"col-md-9\">\n";
		    strVar += "				<select class=\"form-control\" id=\"disk_createShare_after_password\">\n";
		    strVar += "					 <option value=\"0\">加密<\/option>\n";
		    strVar += "					 <option value=\"1\">公开<\/option>\n";
		    strVar += "		    	<\/select>\n";
		    strVar += "			<\/div>\n";
		    strVar += "		<\/div>\n";
		    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
		    strVar += "			<div class=\"col-md-3\">有效期选择 : <\/div>\n";
		    strVar += "			<div class=\"col-md-9\">\n";
		    strVar += "				<select class=\"form-control\" id=\"disk_createShare_after_date\">\n";
		    strVar += "					 <option value=\"0\">永久有效<\/option>\n";
		    strVar += "					 <option value=\"1\">7天<\/option>\n";
		    strVar += "					 <option value=\"2\">1天<\/option>\n";
		    strVar += "		    	<\/select>\n";
		    strVar += "			<\/div>\n";
		    strVar += "		<\/div>\n";
		    strVar += "		<div class=\"col-md-12 disk_createShare_btn\">			\n";
		    strVar += "			<span>创建链接<\/span><span onclick=\"$.fancybox.close()\">取消<\/span>\n";
		    strVar += "		<\/div>\n";
		    strVar += "		<div id=\"disk_share_copy_error_message\" style=\"display:none;text-align:center;margin-bottom:0px;\" class=\"col-md-12 alert alert-danger\" role=\"alert\">\n";
		    strVar += "  		<a href=\"#\" class=\"alert-link\">存在已经分享过的文件<\/a>\n";
		    strVar += "		<\/div>\n";
		    strVar += "	<\/div>\n";
		    strVar += "	<div class=\"disk_createShare_after\">\n";
		    strVar += "		<div class=\"disk_createShare_after_title\"><span class=\"glyphicon glyphicon-ok\"><\/span><span>分享文件链接创建成功 , <\/span><span id=\"disk_createShare_after_time\"><\/span><\/div>\n";
		    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
		    strVar += "			<div class=\"col-md-3\">分享链接 : <\/div>\n";
		    strVar += "			<div class=\"col-md-9\">\n";
		    strVar += "				<input type=\"text\" oninput=\"$(this).val($(this).data('value'));$(this).select()\" onfocus=\"$(this).select();\" class=\"form-control\" id=\"disk_createShare_after_link\"/>\n";
		    strVar += "			<\/div>\n";
		    strVar += "		<\/div>\n";
		    strVar += "		<div class=\"col-md-12 disk_createShare_content\" style=\"margin-bottom:30px;\">\n";
		    strVar += "			<div class=\"col-md-3\">分享密码 : <\/div>\n";
		    strVar += "			<div class=\"col-md-9\">\n";
		    strVar += "				<div class=\"col-md-6\"><input oninput=\"$(this).val($(this).data('value'));$(this).select()\" onfocus=\"$(this).select();\" type=\"text\" class=\"form-control\" id=\"disk_createShare_after_pwd\"/><\/div>\n";
		    strVar += "				<div class=\"col-md-6\"><span onclick=\"disk_share_copy()\">复制链接和分享码<\/span><\/div>\n";
		    strVar += "			<\/div>\n";
		    strVar += "		<\/div>\n";
		    strVar += "		<div id=\"disk_share_copy_message\" style=\"display:none;text-align:center;margin-bottom:0px;\" class=\"col-md-12 alert alert-success\" role=\"alert\">\n";
		    strVar += "  		<a href=\"#\" class=\"alert-link\">复制成功<\/a>\n";
		    strVar += "		<\/div>\n";
		    strVar += "	<\/div>\n";
		    strVar += "<\/div>\n";			
			//分享文件
			$.fancybox.open(strVar,{
		    	//显示之前触发
		    	beforeShow : function( instance, current ) {
		    		//去掉fancybox原来的间距
		    		$('.fancybox-skin').css('padding','0');
				},
				//显示之后触发
		    	afterShow : function( instance, current ){
		    		//隐藏右上角的X
		    		$('.fancybox-close').hide();
		    		
		    		//绑定创建链接的点击事件
		    		$('.disk_createShare_btn>span').eq(0).bind('click',function(){
		    			disk_createShare(uuids);
		    		})
		    	}
		    });
			
			//显示多个文件名
			if(list_data.length==1){
				$('.disk_move_title>span').eq(0).text(list_data[0].FILE_NAME);
				$('.disk_move_title>span').eq(0).attr('title',list_data[0].FILE_NAME);
			} 
			else{
				var fileNames = '';
				for(var i = 0 ;i<list_data.length;i++){
					fileNames += list_data[i].FILE_NAME + ',';
				}
				//截取掉最后一个','并且加个总个数
				fileNames = fileNames.substring(0, fileNames.length-1) + '(共'+ list_data.length +'项)';
				$('.disk_move_title>span').eq(0).text(fileNames);
				$('.disk_move_title>span').eq(0).attr('title',fileNames);
			}  
	});  		
}

//创建分享链接
function disk_createShare(uuids){		
	//有效时间
	var time = $('#disk_createShare_after_date').val();
	var randPwd; 
	var uuid = $.jfbrother.uuid();
	//如果分享为加密时
	if($('#disk_createShare_after_password').val()==0){
		//随机产生4位的随机数
		randPwd = $.jfbrother.randomWord(true,4,4);
		$('#disk_createShare_after_pwd').val(randPwd);
	}
	else{
		randPwd = '666666';
		//如果为公开时
		$('#disk_createShare_after_pwd').parent().css('visibility','hidden');
		$('#disk_createShare_after_pwd').parent().parent().prev().css('visibility','hidden');
		$('#disk_createShare_after_pwd').parent().next().find('span').text('复制链接');
	}
	
	//插入到数据库
	var v_query = {};
	v_query.FIELD_CODE = uuids;
	v_query.FIELD_PARTOOK_PASS = randPwd;
	v_query.FIELD_PARTOOK_CODE = uuid;
	//失效时间
	v_query.LIMIT_TIME = time;
	var result = storePersonalModule.storePersonalActAction.partookStorePersonal(v_query);
	if(result.VALUE=='存在已经分享过的文件/文件夹'){
		$('#disk_share_copy_error_message').fadeIn().text('存在已经分享过的文件/文件夹').delay('3000').fadeOut();
		return;
	}
	$('.disk_createShare').hide();
	$('.disk_createShare_after').show();
	
	//分享形式
	var pwd = $('#disk_createShare_after_password').val();
	var limit_time;
	switch (time) {
	case '1':
		limit_time = '链接7天后失效';
		break;
	case '2':
		limit_time = '链接1天后失效';
		break;
	default:
		limit_time = '永久有效'
		break;
	}
	$('#disk_createShare_after_time').text(limit_time);	
		
	//把原来的值存放起来
	$('#disk_createShare_after_pwd').data('value',$('#disk_createShare_after_pwd').val());
	//链接
	var old_href = location.href;
	var new_href = old_href.substring(0, old_href.lastIndexOf('/'));	
	$('#disk_createShare_after_link').val(new_href+'/share?code='+uuid);
	//把原来的值存放起来
	$('#disk_createShare_after_link').data('value',$('#disk_createShare_after_link').val());
	
}

//分享文件的链接和分享码
function disk_share_copy(){
	//要复制的内容
	var value;
	if($('#disk_createShare_after_pwd').val()==''){
		value = '链接 : '+$('#disk_createShare_after_link').val();
	}
	else{
		value ='链接 : '+$('#disk_createShare_after_link').val()+' 密码 : '+$('#disk_createShare_after_pwd').val();
	}
	//创建一个新的输入框来存放
	var oInput = $('<input type="text" />').val(value);
	$('body').append(oInput);
	//选中对象
	oInput.select();
	//执行浏览器复制命令
	document.execCommand("Copy");
	//复制后移除
	oInput.remove();
	//显示提示
	$('#disk_share_copy_message').fadeIn().delay('3000').fadeOut();
}

//共享文件
function disk_enjoyFolder(handler){
	disk_confirm(handler,'共享',null,function(list_rows,uuids,list_data){			
		var strVar = "";
	    strVar += "<div style=\"width:900px;padding:0px;border-radius:5px;overflow:hidden;\">\n";
	    strVar += "			<div class=\"disk_move_title\"><span>选择人员<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>			\n";
	    strVar += "			<div class=\"col-md-12 disk_selectUser_content\">\n";
	    strVar += "				<div class=\"col-md-3\">\n";
	    strVar += "					<div><img src=\"custom/images/loading.gif\"/><\/div>\n";
	    strVar += "					<div id=\"disk_enjoyUser_tree\" class=\"ztree disk_move_tree\"><\/div>\n";
	    strVar += "				<\/div>\n";
	    strVar += "				<div class=\"col-md-9\">\n";
	    strVar += "					<div class=\"disk_selectUser_table_title\">\n";
	    strVar += "						<input id=\"disk_enjoyUser_list_search_key\" type=\"text\" class=\"form-control\" placeholder=\"请输入关键字\" /><span onclick=\"init_disk_enjoyUser_list_search(this)\">查询<\/span><span>确定<\/span><label>至少要选择一个人员...<\/label>\n";
	    strVar += "					<\/div>\n";
	    strVar += "					<div><img src=\"custom/images/loading.gif\"/><\/div>\n";
	    strVar += "					<div class=\"disk_selectUser_table\">\n";
	    strVar += "						<table id=\"disk_selectUser_list\"><\/table>\n";
	    strVar += "					<\/div>\n";
	    strVar += "				<\/div>	\n";
	    strVar += "			<\/div>\n";
	    strVar += "		<\/div>\n";
	    
	    $.fancybox.open(strVar,{
	    	//显示之前触发
	    	beforeShow : function( instance, current ) {
	    		//去掉fancybox原来的间距
	    		$('.fancybox-skin').css('padding','0');
	    		
			},
			//显示之后触发
	    	afterShow : function( instance, current ){
	    		//隐藏右上角的X
	    		$('.fancybox-close').hide();	    	   	    	
	    		
	    		//初始化单位的目录
	    	    init_disk_enjoyUser_tree(list_data);
	    	    
	    	    //初始化某个单位的人员列表
	    	    init_disk_enjoyUser_list(list_data);
	    	    
	    	    //搜索框
	    	    $('#disk_enjoyUser_list_search_key').bind('keydown',function(e){
	    	    	var ev = document.all ? window.event : e;
	    			if (ev.keyCode == 13) {
	    				$(this).next().click();
	    			}
	    	    })
	    	    
	    	    $('#disk_enjoyUser_list_search_key').next().next().bind('click',function(){
	    	    	disk_enjoyUser_save(list_data);
	    	    })
	    	    
	    	}
	    });
		
	});  
}

//我的分享码
function disk_shareCode(){
	$('#disk_shareCode').data('shareCode',true);
	$('.disk_content_toggleBtn').data('toggleList',true);
	//删掉目录导航栏
	$('.disk_search_center>a').eq(0).nextAll().remove();
	//隐藏切换视图的功能
	$('.disk_content_toggleBtn').hide();
	
	var infos = storePartookModule.storePartookDataAction.listAll().rowSet;
	//定义一个过滤后的数组
	var result_infos = [];
	//先获得分享的数据,再根据FILE_UUID去查找普通文件信息
	for(var i = 0 ; i < infos.length;i++ ){
		if(infos[i].DELETE_FLAG=='1'){
			//过滤掉软删除的数据
			continue;
		}		
		var v_query = {} ;
		v_query.FIELD_UUID = infos[i].FILE_UUID;
		var result_list = storePersonalModule.storePersonalDataAction.listAll_storePersonalnofile(v_query).rowSet;
		//把普通文件FILE_SAVE_PATH,FILE_SVAE_NAME,FILE_TYPE保留下来
		infos[i].FILE_SAVE_PATH = result_list[0].FILE_SAVE_PATH;
		infos[i].FILE_SVAE_NAME = result_list[0].FILE_SVAE_NAME;
		infos[i].FILE_TYPE = result_list[0].FILE_TYPE;
		//初始化文件的图片
		init_disk_select_fileImg(infos[i]);
		result_infos.push(infos[i]);
	}	
	
	//显示取消分享的按钮
	$('.disk_content_header>div:first-child>a').hide();
	$('.disk_shareCodeBtn').show();
	
	//显示列表
	$('.disk_content_list').show();
	$('.disk_content_lump').hide();
	
	//渲染列表
	init_disk_shareCode_list(result_infos);	
}

//取消分享
function disk_cancelShareCode(handler){
	disk_confirm(handler,'取消分享',function(list_rows,uuids){
		//数据库的取消分享信息
		var result = disk_cancelShareCode_sql(uuids);
	});	
}

//取消分享的数据库操作
function disk_cancelShareCode_sql(uuids){
	var query = {};
	query.FIELD_CODE = uuids;
	//先软删除
	var result1 = storePartookModule.storePartookActAction.deleteStorePartook(query);
	//再真正的删除
	var result2 = storePartookModule.storePartookActAction.deleteTrueStorePartook(query);
}

//初始化我的分享码的列表
function init_disk_shareCode_list(infos){
	//console.log(infos)
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
	     /* showColumns:true,
	     showToggle:true,
	     showRefresh:true,
	     search:true, */
	     /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
	     data:infos,
	     cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
	     /* striped: true,  //表格显示条纹，默认为false */
	     pagination: false, // 在表格底部显示分页组件，默认false
	     pageList: [5,10,15,20], // 设置页面可以显示的数据条数
	     pageSize: 10, // 页面数据条数
	     pageNumber: 1, // 首页页码,
	     uniqueId:'UUID',
	     clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
	     queryParams:function(params){
				  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
					   // limit: params.limit,   //页面大小  
					    offset: params.offset,  //页码  
					    pageSize:this.pageSize,  
					    pageNumber:this.pageNumber
					    /* projectId: $("#projectId").val(),  
					    requirement_Id:$("#requirement_Id").val(),  
					    length: 6  */ 
					};  
					return temp;
	     },
	     columns: [
	         {
	             checkbox: true, // 显示一个勾选框
	             align: 'center', // 居中显示
	             valign: 'middle'
	         },{
	             field: 'FILE_NAME',
	             title: '文件名称',
	             align: 'left',
	             valign: 'middle',
	             width: '400',
	             formatter: function (value, row, index) { 
	            	 if(row.fileImg){
	              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control"/></div></div>'; 
	              	 }
	              	 else{
	              		 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img style="border-radius:5px;" src="'+ctx+'/photo/photo.jsp?ls_photo='+row.FILE_SAVE_PATH+row.FILE_SVAE_NAME+'" height="44" ></div><div class="col-md-10" data-lump_data=\''+JSON.stringify(row)+'\'><div>'+ value +'</div><input type="text" value=\''+ value +'\' class="form-control"/></div></div>';
	              	 } 
	             }
	         }, {
	             field: 'CREATE_TIME',
	             title: '分享时间',
	             align: 'center',
	             valign: 'middle',
	             order:'asc',
	             sortable:'true'
	         },{
	             field: 'PARTOOK_PASS',
	             title: '分享密码',
	             align: 'center',
	             valign: 'middle',
	             formatter: function (value, row, index) {
	            	 if(value=='666666'){
	            		 return '-';
	            	 }
	            	 else{
	            		 return value;
	            	 }
	             }
	         },{
	             field: 'shareLink',
	             title: '分享链接',
	             align: 'center',
	             valign: 'middle',
	             formatter: function (value, row, index) {
	            	 //如果截止时间过时了
	            	 var now_data = $.jfbrother.dateToStr('yyyy-MM-dd');
	            	 var limit_time = $.jfbrother.countTime(now_data,row.PARTOOK_TIME);
	            	 if(limit_time<0){
	            		 return '链接已过期...';
	            	 }
	            	 var old_href = location.href;
	            	 var new_href = old_href.substring(0, old_href.lastIndexOf('/'));
	            	 return new_href + '/share?code=' + row.PARTOOK_CODE;
	             }
	         },{
	             field: 'PARTOOK_TIME',
	             title: '分享截止时间',
	             align: 'center',
	             valign: 'middle',
	             formatter: function (value, row, index) {
	            	 if(value == row.CREATE_TIME){
	            		 return '-';
	            	 }
	            	 else{
	            		 return value;
	            	 }
	             }
	         }
	     ],
	     //选中时隐藏菜单
	     onCheck:function(row){
	    	 $('#disk_shareCode_menu').hide();
	     }
	})
}

//返回主页面效果
function disk_back_home(){
	var infos = init_disk_infos('0');
	//清除所有的导航
	$('.disk_search_center>a').eq(0).nextAll('a').remove();
	//切换操作按钮
	$('.disk_content_header>div:first-child>a').show();
	$('.disk_rubbishBtn,.disk_shareCodeBtn,.disk_enjoyBtn').hide();
	
	//初始化其他切换的data属性标志
	var shareCodeFlag = $('#disk_shareCode').data('shareCode');
	$('#disk_shareCode').data('shareCode',false);
	$('#disk_rubbish').data('rubbish',false);
	//显示切换视图的功能,防止是从分享码切过来时隐藏了切换视图的功能
	$('.disk_content_toggleBtn').show();
	//重新渲染数据
	if($('.disk_content_toggleBtn').data('toggleList')||shareCodeFlag){
		//如果是列表时
		init_disk_list(infos);			
	}
	else{
		//如果是块状时
		//根据一个json数据去渲染块状		
		//渲染块状
		//先清空容器		
		$('.disk_content_lump').html('');	
		for(var i = 0 ; i<infos.length;i++){
			init_disk_createLump(infos[i]);
		}
	}
}

