<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%
String procApp=com.gaowj.business.util.PropUtil.getValue("lcyq_app_url", "quartz_service", "");
 %>
<c:set var="ctx" value="${pageContext.request.contextPath}" />
<html>
<head>
<title>办事大厅</title>
<jsp:include page="header.jsp"></jsp:include>
<script type="text/javascript" src="${pageContext.request.contextPath}/jwapp/pages/portlet/js/jwAppPortletModule.js" charset="utf-8"></script>
<script src="${ctx}/jwapp/pages/process/js/processModule.js"></script>
<script src="${ctx}/jfcas04/js/office.js"></script>
</head>
<body>
	<!-- 头部 -->
	<jsp:include page="/nav4.jsp"></jsp:include>

	<!-- 内容部分1 -->
	<div class="container-fluid" id="process_content1">

		<!--背景图-->
		<div class="row office_bg">
			<div class="office_bg_content col-md-12">
				<div class="col-md-3">
					<div class="office_bg_content_click" >
						<img src="${ctx}/custom/images/office_apply.png" width="100" height="100" />
						<div>我要申请</div>
					</div>
				</div>
				<div class="col-md-3">
					<div class="" src="<%=procApp %>?redirectUrl=processView_approval" iframeId="approval">
						<img src="${ctx}/custom/images/office_examine.png" width="100" height="100" />
						<div>我要审批</div>
					</div>
				</div>
				<div class="col-md-3">
					<div class="" src="<%=procApp %>?redirectUrl=processView_progressRate" iframeId="progressRate">
						<img src="${ctx}/custom/images/office_progress.png" width="100" height="100" />
						<div>进度查询</div>
					</div>
				</div>
				<div class="col-md-3">
					<div class="" src="<%=procApp %>?redirectUrl=processView_progressHistory" iframeId="progressHistory">
						<img src="${ctx}/custom/images/office_history.png" width="100" height="100" />
						<div>历史查询</div>
					</div>
				</div>
			</div>
		</div>

		<!-- 申请模块 -->
		<div class="office_module row">
			<div class="office_module_title col-md-12">
				<img src="${ctx}/custom/images/office_title.png" height="16" width="16" /> <span>我要申请</span>
			</div>
			<div class="office_apply col-md-12">
				<div class="office_apply_content"></div>
			</div>
		</div>

		<!-- 审批模块 -->
		<div class="office_module row" style="display:none">
			<iframe id="approval" style="width:100%" ></iframe>
		</div>

		<!-- 进度查询模块 -->
		<div class="office_module row" style="display:none">
			<iframe id="progressRate" style="width:100%" ></iframe>
		</div>
		<!-- 历史查询模块 -->
		<div class="office_module row" style="display:none">
			<iframe id="progressHistory" style="width:100%" ></iframe>
		</div>

		<!--主容器结尾-->
	</div>
	<input type="text" id="procAppUrl" value="<%=procApp%>" style="display:none;">
	<!-- 内容部分2 -->
	<div class="container-fluid" id="process_content2" style="display:none;">

		<!-- 背景图 -->
		<div class="row officeDetail_bg"></div>

		<!-- 详情 -->
		<div class="row officeDetail_content">
			<div class="officeDetail_content_title col-md-12">
				<span class="officeDetail_content_title_text">请假申请</span>
				<div onclick="backOfficeList();">
					<img src="${ctx}/custom/images/officeDetail_back.png" width="16" height="16" /><span>返回</span>
				</div>
				<div>
					<span>*</span><span>必填</span>
				</div>
			</div>
			<div class="officeDetail_content_div col-md-12" style="text-align: center;">
				<img id="proc_iframe_loading" src="${ctx}/custom/images/loading.gif" />
				<iframe id="proc_iframe" style="width:100%;"></iframe>
			</div>
		</div>

		<!-- 流程图 -->
		<div class="row officeDetail_flow">
			<div class="officeDetail_flow_toggole" onClick="officeDetail_changeFlow(this)">
				<img src="${ctx}/custom/images/officeDetail_up.png" width="7" height="4" /><span>展开</span>
			</div>
			<div class="col-md-12 officeDetail_flow_content">
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<div>流程图</div>
				<!-- <div style="height:500px;background:red;">流程图</div> -->
			</div>
		</div>

		<!--主容器结尾-->
	</div>

	<!-- 尾部 -->
	<jsp:include page="/footer.jsp"></jsp:include>
</body>
</html>
