var commonutil = {
	/**
	 * 往object的所有key统一添加前缀
	 */
	keyAddStr : function(object, str) {
		if (typeof str == 'undefined' || str == null || str == '') {
			str = 'FIELD_';
		}
		var news = {};
		for (key in object) {
			news[str + key] = object[key];
		}
		return news;
	}
};

/**
 * easyui  datagrid方法封装
 */
var easyui = {
	datagrid : function(options) {
		var opts = $.extend({
			pagination : true,
			checkOnSelect : false,
			selectOnCheck : false,
			rownumbers : true,
			fitColumns : false,
			striped : true,
			scrollbarSize : 0,
			tableId : options.tableId,
			autoRowHeight : false,
			isSingleSelect : true,
			singleSelect : true,
			//如果需要自定义计算最后一列,则需要设置customLastCellWidth属性为true
			customLastCellWidth : true
		/*,
		border:false*/
		}, options);
		opts.onClickRow = function(rowIndex, rowData) {
			if (typeof options.onClickRow == 'function') {
				options.onClickRow.call(null, rowIndex, rowData);
			}
		//如果用户传入了isSingleSelect属性为true，则设置点击事件时候只能单行选中
		/*if (opts.isSingleSelect) {
			if (typeof datagridSingleSelect == 'function') {
				datagridSingleSelect(opts.tableId, rowIndex);
			}
		}*/
		};

		opts.onRowContextMenu = function(e, rowIndex, rowData) {
			if (typeof options.onRowContextMenu == 'function') {
				options.onRowContextMenu.call(null, e, rowIndex, rowData);
			}
		//如果用户传入了isSingleSelect属性为true，则设置右击事件时候只能单行选中
		/*if (opts.isSingleSelect) {
			datagridSingleSelect(opts.tableId, rowIndex);
		}*/
		}

		opts.onBeforeLoad = function(param) {
			if (typeof options.onBeforeLoad == 'function') {
				options.onBeforeLoad.call(null, param);
			}
			//提交参数前，将每个参数的两边空格都去除
			for (var key in param) {
				param[key] = (param[key] + "").trim();
			}
		};
		opts.onLoadSuccess = function(data) {
			if (typeof options.onLoadSuccess == 'function') {
				options.onLoadSuccess.call();
			}
			//如果回传值有checkedIds属性，则将这些id的记录进行勾选操作
			var checkedIds = data.checkedIds;
			if (!stringutil.isEmpty(checkedIds) && checkedIds.length > 0) {
				var rows = data.rows;
				for (var i = 0; i < rows.length; i++) {
					for (var j = 0; j < checkedIds.length; j++) {
						if (checkedIds[j] == rows[i].id) {
							$("#" + opts.tableId).datagrid("checkRow", i);
						}
					}
				}
			}
		};
		return $('#' + opts.tableId).datagrid(opts);
	},
	dialog : function(options) {
		var opts = $.extend({
			modal : true,
			shadow : false,
			onClose : function() {
				$(this).dialog('destroy');
			}
		}, options);

		opts.onLoad = function() {
			if (typeof options.onLoad == 'function') {
				options.onLoad.call();
			}
			$.messager.defaults.onClose = function() {};

		//$.messager.progress('close')
		};

		opts.onOpen = function() {
			if (typeof options.onOpen == 'function') {
				options.onOpen.call();
			}

		//数据加载
		/*$.messager.progress({
			text : '数据加载中....',
			interval : 100
		});*/
		};

		if (opts.dialogSelector) {
			//如果是自定义选择器生成dialog，就不需要调用销毁
			opts.onClose = function() {};
			return opts.dialogSelector.dialog(opts);
		} else {
			return $('<div/>').dialog(opts);
		}
	},
	combobox : function(options) {
		if (!options.selector) {
			alert('selector必须设置');
			return;
		}

		var opts = $.extend({
			valueField : 'id',
			textField : 'text',
			defaultEmptyValue : '',
			defaultEmptyText : '-- 请选择 --',
			//空值行是否需要，默认为true，需要
			needEmpty : true
		}, options);

		//如果key，value传进来的属性名一致，则强制改变textField属性名
		var same = false;
		if (opts.valueField == opts.textField) {
			same = true;
			opts.textField = "c_" + opts.textField;
		}

		var responseInfo;
		$.ajax({
			url : opts.url,
			async : false,
			success : function(data) {
				responseInfo = data;
			}
		});

		//设置第一个空行
		var data = [];
		if (opts.needEmpty) {
			var d = {};
			d[opts.valueField] = opts.defaultEmptyValue;
			d[opts.textField] = opts.defaultEmptyText;
			data.push(d);
		}
		var complete_data = stringutil.toJson(responseInfo.data);
		for (var i = 0; i < complete_data.length; i++) {
			var d = {};
			d[opts.valueField] = complete_data[i][opts.valueField];
			var textFieldName;
			if (same) {
				//如果key，value属性名一致，则获取数据的时候，多了一个"c_"字符，要给予去除
				textFieldName = opts.textField.split("c_")[1];
			} else {
				textFieldName = opts.textField;
			}
			d[opts.textField] = complete_data[i][textFieldName];
			data.push(d);
		}
		
		if (responseInfo.code == '0000') {
			if ($(opts.selector).length == 0) {
				alert('selector设置错误');
			}
			opts.data = data;
			delete opts.url;
			var handle = $(opts.selector).combobox(opts);
			return handle;
		}

		return null;
	},
	calendar : function(options) {
		if (!options.selector) {
			alert('selector必须设置');
			return;
		}

		var opts = $.extend({
			current : new Date()
		}, options);

		$(opts.selector).calendar({
			current : new Date()
		});
	},
	datebox : function(options) {
		if (!options.selector) {
			alert('selector必须设置');
			return;
		}

		var opts = $.extend({
			formatter : function(date) {
				var y = date.getFullYear();
				var m = date.getMonth() + 1;
				var d = date.getDate();
				return y + '-' + (m < 10 ? ('0' + m) : m) + '-' + (d < 10 ? ('0' + d) : d);
			}
		}, options);
		$(opts.selector).datebox(opts);
	},
	treegrid : function(options) {
		var opts = $.extend({
			animate : true,
			rownumbers : true,
			idField : 'id',
			treeField : 'name',
			tableId : options.tableId,
			autoRowHeight:false,
			fitColumns:true,
			scrollbarSize:0
		}, options);
		opts.onLoadSuccess = function() {
			if (typeof options.onLoadSuccess == 'function') {
				options.onLoadSuccess.call();
			}
		};
		opts.onDblClickRow=function(row){
			if (typeof options.onDblClickRow == 'function') {
				options.onDblClickRow.call();
			}
			$('#' + opts.tableId).treegrid('toggle',row.id);
		};
		
		opts.onLoadError=function(){
			if (typeof options.onLoadError == 'function') {
				options.onLoadError.call();
			}
			alert('数据获取失败!');
		}

		return $('#' + opts.tableId).treegrid(opts);
	},
	tree : function(options) {
		var opts = $.extend({
			checkbox : false,
			lines : false,
			animate : true,
			treeId : options.treeId
		}, options);
		return $('#' + opts.treeId).tree(opts);
	}
}

/**
 * tree数据中，如果不是叶节点，则将checked属性设置为false
 */
function notleafToUnchecked(data){
	for(var i=0;i<data.length;i++){
		if(!stringutil.isEmpty(data[i].children)&&data[i].children.length!=0){
			//表示非叶子节点
			//将checked属性设置为false
			data[i].checked=false;
			data[i]._checked=false;
			//继续判断子节点
			notleafToUnchecked(data[i].children);
		}
	}
}

/**
 * 流程编辑页面
 * @returns {Boolean}
 */
function openProcEditRow(editUrl,is_row,is_title,is_max,is_width,is_height,is_left,is_top){
	$('#detail').dialog( {
		title : is_title,
		iconCls : $.getJwWindowPic(),
		width : ls_width * is_width,
		height :ls_height * is_height,
		closed : false,
		cache : false,
		maximizable:is_max,
		left:is_left,
		top:is_top,
		href : editUrl,
		queryParams:get_FIELD(is_row),
		modal : true,
		buttons : [ {
			text : '保存',
			iconCls : 'icon-ok',
			handler : function() {
				saveBox('detail','list');
			}
		}, {
			text : '退回',
			iconCls : 'icon-ext-44_08',
			handler : function() {
				lastBox('detail','list');
			}
		}, {
			text : '下一步',
			iconCls : 'icon-ext-44_08',
			handler : function() {
				nextBox('detail','list');
			}
		}, {
			text : '关闭',
			iconCls : 'icon-back',
			handler : function() {
				closeBox('detail');
			}
		} ],
		onLoad:function editUrlOnload(){
			if(is_row.OPETYPE=='insert'){
				addUrlOnloadCallback(is_row);
			}else{
				updateUrlOnloadCallback(is_row);
			}
		}
	});
}
/****/

//弹出层流程编辑上一步（退回）按扭
function lastBox(Box_id,List_id) {
	if(Box_id==null||Box_id==''||Box_id==undefined)
		Box_id='detail';
	if(List_id==null||List_id==''||List_id==undefined)
		List_id='list';
	var returnIsValid = $('#inputForm').form('validate');
	if (returnIsValid) {
		//$("#inputForm").submit();
		var query = $("#inputForm").getFormVal();
		var v_result = backProc(query);
		if (v_result != null && v_result != undefined) {
			closeBox(Box_id);
			$.messager.alert('提示', v_result.VALUE);	
		}
	}
}

//弹出层流程编辑下一步按扭
function nextBox(Box_id,List_id) {
	if(Box_id==null||Box_id==''||Box_id==undefined)
		Box_id='detail';
	if(List_id==null||List_id==''||List_id==undefined)
		List_id='list';
	var returnIsValid = $('#inputForm').form('validate');
	if (returnIsValid) {
		//$("#inputForm").submit();
		var query = $("#inputForm").getFormVal();
		var v_result;
		if ($('#OPETYPE').val() == null || $('#OPETYPE').val() == undefined
				|| $('#OPETYPE').val() == '' || $('#OPETYPE').val()=='insert'){
			v_result = insertDataToNext(query);
		}
		else{
			v_result = updateDataToNext(query);
		}
		if (v_result != null && v_result != undefined) {
			closeBox(Box_id);
			$.messager.alert('提示', v_result.VALUE);	
		}
	}
}
/****/
/**
 * 模块初始化
 */
function initModule(listFunction,strutsRoutes) {
	//此乃本模块与后台交互的方法接口部分
	var currency_module = function(format) {
		this.module = "";
		this.action = "";
		this.format = format;
	};
	//定义数据交互
	currency_module.prototype = BusinessObject;
	
	for(k in listFunction){
		eval('currency_module.prototype.'+listFunction[k]+' = function() {};');
	}

	//创建一个数据操作对象，然后再后续使用
	for(k in strutsRoutes){
		eval('currency_module.'+k+' = new currency_module("json").delegate("'+strutsRoutes[k]+'");');
	}
	
	return currency_module;
}