package com.gaowj.business.base;

import java.util.List;
import java.util.Map;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

/**
 * 业务层基准接口（包含通用的增删改查方法）
 * 
 * @author luosz
 *
 */
public interface BaseBusiness {
	/**
	 * 插入
	 * 
	 * @param entity
	 *            插入的对象
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:13:49
	 * @author luosz@jfbrother.com
	 */
	void insert(Map<String, Object> entity) throws BusinessException;

	/**
	 * 更新
	 * 
	 * @param entity
	 *            更新的对象
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:13:54
	 * @author luosz@jfbrother.com
	 */
	void update(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param list
	 *            需要删除的对象的主键uuid组成的list
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:13:59
	 * @author luosz@jfbrother.com
	 */
	void delete(List<String> list) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param pageNo
	 *            页码
	 * @param pageSize
	 *            每页显示多少条
	 * @param query
	 *            查询条件
	 * @return 分页记录
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:14:03
	 * @author luosz@jfbrother.com
	 */
	Page<Map<String, Object>> list(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param query
	 *            查询条件
	 * @return 记录
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:14:08
	 * @author luosz@jfbrother.com
	 */
	List<Map<String, Object>> list(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录数
	 * 
	 * @param query
	 *            查询条件
	 * @return 记录数
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:14:13
	 * @author luosz@jfbrother.com
	 */
	int listCount(Map<String, Object> query) throws BusinessException;
}
