package com.gaowj.business.base.impl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.base.BaseBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.DaoUtil;
import com.gaowj.business.util.Page;

/**
 * 业务层基准接口的默认实现
 * 
 * @author luosz
 *
 */
public abstract class BaseBusinessImpl implements BaseBusiness {

	public BaseDAO dao;

	@Override
	public void insert(Map<String, Object> entity) throws BusinessException {
		DaoUtil.addCreateInfo(entity);
		makeInsertEntity(entity);
		DaoUtil.addFieldsInfo(entity);
		dao.insertInfo(entity);
	}

	@Override
	public void update(Map<String, Object> entity) throws BusinessException {
		DaoUtil.addUpdateInfo(entity);
		makeUpdateEntity(entity);
		DaoUtil.addFieldsInfo(entity, "UUID");
		dao.updateInfo(entity);
	}

	@Override
	public void delete(List<String> list) throws BusinessException {
		dao.deleteInfo(list);
	}

	@Override
	public Page<Map<String, Object>> list(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
		makeQuery(query);
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = dao.listInfo(new RowBounds(pageStart, pageSize), query);
		// 获取列表个数
		int count = dao.listInfoCount(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public List<Map<String, Object>> list(Map<String, Object> query) throws BusinessException {
		makeQuery(query);
		// 获取列表
		List<Map<String, Object>> items = dao.listInfo(query);
		return items;
	}

	@Override
	public int listCount(Map<String, Object> query) throws BusinessException {
		makeQuery(query);
		return dao.listInfoCount(query);
	}

	/**
	 * 查询条件的设置，需要用户自己实现
	 * 
	 * @param query
	 * @throws BusinessException
	 * @date 2018-09-01 下午6:22:56
	 * @author luosz@jfbrother.com
	 */
	public abstract void makeQuery(Map<String, Object> query) throws BusinessException;

	/**
	 * 处理插入数据
	 * 
	 * @param entity
	 * @date 2018-09-01 下午7:30:24
	 * @author luosz@jfbrother.com
	 */
	public abstract void makeInsertEntity(Map<String, Object> entity) throws BusinessException;

	/**
	 * 处理更新数据
	 * 
	 * @param entity
	 * @date 2018-09-01 下午7:30:36
	 * @author luosz@jfbrother.com
	 */
	public abstract void makeUpdateEntity(Map<String, Object> entity) throws BusinessException;
}
