package com.gaowj.business.base.impl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;

/**
 * DAO接口基类
 * 
 * @author luosz@jfbrother.com
 *
 */
public interface BaseDAO {
	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:31
	 * @author luosz@jfbrother.com
	 */
	void insertInfo(Map<String, Object> entity) throws BusinessException;

	/**
	 * 修改
	 * 
	 * @param entity
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:37
	 * @author luosz@jfbrother.com
	 */
	void updateInfo(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除
	 * 
	 * @param entity
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:41
	 * @author luosz@jfbrother.com
	 */
	void deleteInfo(List<String> list) throws BusinessException;

	/**
	 * 列表及详情（带翻页）
	 * 
	 * @param rowbounds
	 * @param query
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:47
	 * @author luosz@jfbrother.com
	 */
	List<Map<String, Object>> listInfo(RowBounds rowbounds, Map<String, Object> query) throws BusinessException;

	/**
	 * 列表及详情
	 * 
	 * @param query
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:52
	 * @author luosz@jfbrother.com
	 */
	List<Map<String, Object>> listInfo(Map<String, Object> query) throws BusinessException;

	/**
	 * 列表数量
	 * 
	 * @param query
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-01 下午3:08:56
	 * @author luosz@jfbrother.com
	 */
	int listInfoCount(Map<String, Object> query) throws BusinessException;
}
