package com.jw.app.attendance.action;

import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;


import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.standard.utils.CacheKit;
import com.jw.app.business.AttendanceBusiness;

public class actAction extends BasicAction {



	private static final long serialVersionUID = 1407459954477199670L;
	/**
	 * 
	 */


	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertAttendance() throws BusinessException {

		AttendanceBusiness business = BusinessManager.getBusiness(AttendanceBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);
				
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//新增
			business.insert_attendance(entity);
			
			// 操作日志
			//sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
				sysbusiness.insert_logBusiness("insertAttendance", "" + entity,
						"增加考勤记录", (String) entity.get("UUID"), (String) entity.get("NAME"), "attendancedemo1");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateAttendance() throws BusinessException {

		AttendanceBusiness business = BusinessManager.getBusiness(AttendanceBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_attendance(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateAttendance", "" + entity, 
					"修改考勤记录",(String) entity.get("UUID"), (String) entity.get("NAME"),"attendancedemo1");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteAttendance() throws BusinessException {

		AttendanceBusiness business = BusinessManager.getBusiness(AttendanceBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_attendance(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteAttendance", "" + ListKey,
					"删除考勤记录", deletekey, "多个流水号","attendancedemo1");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}

}
