package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface AttendanceBusiness {

		/**
		 * 插入
		 * @param entity
		 * @throws BusinessException
		 */
		void insert_attendance(Map<String,Object> entity) throws BusinessException ;

		/**
		 * 更新
		 * @param entity
		 * @throws BusinessException
		 */
	    void update_attendance(Map<String,Object> entity) throws BusinessException ;
	    
	    /**
		 * 删除记录
		 * @param entity
		 * @throws BusinessException
		 */
	    void delete_attendance(List<String> list)throws BusinessException;
	    
	    /**
		 * 分页获取记录
		 * @param entity
		 * @throws BusinessException
		 */
	    Page<Map<String, Object>> list_attendance(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
	    
	    /**
		 * 获取所有记录
		 * @param entity
		 * @throws BusinessException
		 */
	    List<Map<String,Object>> list_attendance(Map<String, Object> query) throws BusinessException ;
	    
	    /**
		 * 获取所有记录数
		 * @param entity
		 * @throws BusinessException
		 */
	    int listCount_attendance(Map<String, Object> query) throws BusinessException ;
	    
	    
	    
	    
	    //员工考勤
	    Page<Map<String, Object>> list_attendanceEmployee(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
	    
	    /**
		 * 获取所有记录
		 * @param entity
		 * @throws BusinessException
		 */
	    List<Map<String,Object>> list_attendanceEmployee(Map<String, Object> query) throws BusinessException ;
	    
	    /**
		 * 获取所有记录数
		 * @param entity
		 * @throws BusinessException
		 */
	    int listCount_attendanceEmployee(Map<String, Object> query) throws BusinessException ;

	}


