package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface BgmkBusiness {
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_bgmk(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_bgmk(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_bgmk(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_bgmk(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_bgmk(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_bgmk(Map<String, Object> query) throws BusinessException ;
    
   
    
    //个人报工
    Page<Map<String, Object>> list_bgmk_employee(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_bgmk_employee(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_bgmk_employee(Map<String, Object> query) throws BusinessException ;

}
