package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface LogBusiness {

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_log(Map<String, Object> entity) throws BusinessException;

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void update_log(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void delete_log(List<String> list) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_log(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_log(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录数
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	int listCount_log(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_reply(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录数
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	int listCount_reply(Map<String, Object> query) throws BusinessException;

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_reply(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void delete_reply(List<String> list) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_reply(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException;

}
