package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface MeetingBusiness {

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_meeting(Map<String, Object> entity) throws BusinessException;

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void update_meeting(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void delete_meeting(List<String> list) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_meeting(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_meeting(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录数
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	int listCount_meeting(Map<String, Object> query) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_check_in(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_check_in(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录数
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	int listCount_check_in(Map<String, Object> query) throws BusinessException;

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_check_in(Map<String, Object> entity) throws BusinessException;

}
