package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface StoreBusiness {
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_store(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_store(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 设置binary_data大字段为空
	 * @param entity
	 * @throws BusinessException
	 */
    void setnull_binary_data(List<String> list) throws BusinessException ;
    
    /**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_store(List<String> list)throws BusinessException;
    
    /**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
    void resume_store(List<String> list)throws BusinessException;
    
    /**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_true_store(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录没有file大字段
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_storenofile(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录没有file大字段
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_storenofile(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_store(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_store(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_store(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取文件目录树
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_storetree(Map<String,Object> query) throws BusinessException ;
    
    /**---------------供其它模块接口使用-------------------**/
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_storenofile_webservices(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_storenofile_webservices(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_store_common(Map<String, Object> query)throws BusinessException;
    
    /**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
    void resume_store_common(Map<String, Object> query)throws BusinessException;
    
    /**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_true_store_common(Map<String, Object> query)throws BusinessException;
}
