package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface StoreShareBusiness {
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_share(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_share(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_share(List<String> list)throws BusinessException;
    
    /**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
    void resume_share(List<String> list)throws BusinessException;
    
    /**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_true_share(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_share(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_share(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_share(Map<String, Object> query) throws BusinessException ;
}
