package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface StoreUserBusiness {
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_user(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_user(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_user(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_user(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_user(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_user(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 重新检正用户容量
	 * @param entity
	 * @throws BusinessException
	 */
    void update_user_size(Map<String, Object> query) throws BusinessException ;

    /**
	 * 判断容量是否超限
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> is_full_size(Map<String, Object> query) throws BusinessException ;
}
