package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface VoteBusiness {

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_vote(Map<String, Object> entity) throws BusinessException;

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_userVote(Map<String, Object> entity) throws BusinessException;

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void update_vote(Map<String, Object> entity) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void delete_vote(List<String> list) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_vote(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_vote(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取选项
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_item(Map<String, Object> query) throws BusinessException;

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void delete_item(List<String> list) throws BusinessException;

	/**
	 * 提前结束投票
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	void update_endVote(Map<String, Object> entity) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_ongoing(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_ongoing(Map<String, Object> query) throws BusinessException;

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	Page<Map<String, Object>> list_ended(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException;

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_ended(Map<String, Object> query) throws BusinessException;

	/**
	 * 获取用户选择
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	List<Map<String, Object>> list_userChecked(Map<String, Object> query) throws BusinessException;

}
