package com.jw.app.business.apps;

import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.AppsBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.portal.role.appsRoleDAO;

public class AppsBusinessImpl implements AppsBusiness {
	
	private AppsDAO appsDAO;
	
	private appsRoleDAO appsRoleDAO;

	public AppsDAO getAppsDAO() {
		return appsDAO;
	}

	public void setAppsDAO(AppsDAO appsDAO) {
		this.appsDAO = appsDAO;
	}
	
	public appsRoleDAO getAppsRoleDAO() {
		return appsRoleDAO;
	}

	public void setAppsRoleDAO(appsRoleDAO appsRoleDAO) {
		this.appsRoleDAO = appsRoleDAO;
	}

	@Override
	public List<Map<String, Object>> list_allApps_by_user(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> listData = null;
		try {
			//根据当前登陆人id获取所有的角色id
			Map<String, Object> query2=new HashMap<String, Object>();
			query2.put("USER_ID", SessionUtil.getEmid());
			List<Map<String, Object>> listRole=appsRoleDAO.list_all_role_by_userId(query2);
			List<String> listRoleId=new ArrayList<String>();
			for(Map<String, Object> role:listRole){
				listRoleId.add("%"+role.get("ROLE_ID").toString()+"%");
			}
			
			
			query.put("USER_ID", SessionUtil.getEmid());
			query.put("G_IDS", listRoleId);
			listData = QueryParamUtil.ClobToString(appsDAO.list_allApps_by_user(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}
	
	@Override
	public List<Map<String, Object>> list_allCategory(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> listData = null;
		try {
			listData = QueryParamUtil.ClobToString(appsDAO.list_allCategory(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

	@Override
	public void insert_unInstallApp(Map<String, Object> query) {
		//1.先删除安装表里面的数据
		appsDAO.delete_installApp(query);
		//2.添加未安装表的数据
		private_insert_unInstallApp(query);
	}
	
	/**添加未安装的数据
	 * 
	 * @param query
	 */
	private void private_insert_unInstallApp(Map<String, Object> query) {
		Map<String, Object> insertQuery = new HashMap<String, Object>();
		insertQuery.put("APP_ID", query.get("APP_ID"));
		insertQuery.put("USERID", SessionUtil.getEmid());
		insertQuery.put("RESOURCE_ID", UUID.randomUUID().toString());
		appsDAO.insert_unInstallApp(mapToList(insertQuery));
	}
	
	@Override
	public void insert_installApp(Map<String, Object> query) {
		//1.先删除未安装表里面的数据
		appsDAO.delete_unInstallApp(query);
		//2.添加安装表的数据
		private_insert_installApp(query);
	}

	/**添加安装的数据
	 * 
	 * @param query
	 */
	private void private_insert_installApp(Map<String, Object> query) {
		Map<String, Object> insertQuery = new HashMap<String, Object>();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String now = formatter.format(new Date());
		insertQuery.put("APP_ID", query.get("APP_ID"));
		insertQuery.put("INSTALL_TIME", now);
		insertQuery.put("USERID", SessionUtil.getEmid());
		insertQuery.put("RESOURCE_ID", UUID.randomUUID().toString());
		appsDAO.insert_installApp(mapToList(insertQuery));
	}
	
	private List<Map<String, Object>> mapToList(Map<String, Object> map) {
		List<Map<String, Object>> entity = new ArrayList<Map<String, Object>>();
		for (Map.Entry<String, Object> entry : map.entrySet()) {
			Map<String, Object> field = new HashMap<String, Object>();
			field.put("key", entry.getKey());
			field.put("value", entry.getValue());
			entity.add(field);
		}
		return entity;
	}

	@Override
	public List<Map<String, Object>> list_allUninstallApps_by_user(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> listData = null;
		try {
			listData = QueryParamUtil.ClobToString(appsDAO.list_allUninstallApps_by_user(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

	@Override
	public List<Map<String, Object>> list_AllApps(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> listData = null;
		try {
			//根据当前登陆人id获取所有的角色id
			Map<String, Object> query2=new HashMap<String, Object>();
			query2.put("USER_ID", SessionUtil.getEmid());
			List<Map<String, Object>> listRole=appsRoleDAO.list_all_role_by_userId(query2);
			List<String> listRoleId=new ArrayList<String>();
			for(Map<String, Object> role:listRole){
				listRoleId.add("%"+role.get("ROLE_ID").toString()+"%");
			}
			
			//只能查看有权限的
			query.put("G_IDS", listRoleId);
			listData = QueryParamUtil.ClobToString(appsDAO.list_AllApps(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

	@Override
	public void init_defaultApps(Map<String, Object> query) throws BusinessException {
		try {
			//1.先获得所有的apps应用
			List<Map<String, Object>> listData = QueryParamUtil.ClobToString(appsDAO.list_AllApps(query));
			for(Map<String, Object> data : listData){
				Map<String, Object> defaultQuery = new HashMap<String, Object>();
				defaultQuery.put("APP_ID",data.get("APP_ID"));
				if("0".equals(data.get("IS_DEFAULT"))){
					//2.遍历所有的app,如果是默认应用,则添加到install表中
					private_insert_installApp(defaultQuery);
				}
				else{
					//3.否则添加到uninstall表中
					private_insert_unInstallApp(defaultQuery);
				}
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
