package com.jw.app.business.attendance;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;


import com.gaowj.business.exception.BusinessException;

import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;
import com.jw.app.business.AttendanceBusiness;

import oracle.net.aso.f;

public class AttendanceBusinessImpl implements AttendanceBusiness {

	private attendanceDAO attendanceDAO;

	public attendanceDAO getattendanceDAO() {
		return attendanceDAO;
	}

	public void setattendanceDAO(attendanceDAO attendanceDAO) {
		this.attendanceDAO = attendanceDAO;
	}

	@Override
	public void insert_attendance(Map<String, Object> entity) throws BusinessException {
		entity.put("UUID", java.util.UUID.randomUUID().toString());
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", SessionUtil.getEmid());
		}
		if(entity.get("USER_NAME")==null){
			entity.put("USER_NAME", SessionUtil.getCode());
		}
		if(entity.get("DEPT_ID")==null){
			entity.put("DEPT_ID", SessionUtil.getEmdepart());
		}
		if(entity.get("DEPT_NAME")==null){
			entity.put("DEPT_NAME", SessionUtil.getEmdepartname());
		}
		if(entity.get("ATTENDANCE_TIME")==null){
			entity.put("ATTENDANCE_TIME", new Date());
		}
		if(entity.get("ATTENDANCE_ADDRESS")==null){
			entity.put("ATTENDANCE_ADDRESS", 0);
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATE_ID")==null){
			entity.put("CREATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
					   
		
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          attendanceDAO.insert_attendance(entity);
        }
	}

	@Override
	public void update_attendance(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    attendanceDAO.update_attendance(entity);
		}

	}

	@Override
	public void delete_attendance(List<String> list) throws BusinessException {
		attendanceDAO.delete_attendance(list);
		
	}

	@Override
	public Page<Map<String, Object>> list_attendance(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = attendanceDAO.list_attendance(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_attendance(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_attendance(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "attendance"+query);
		if(list_data==null || list_data.size()==0){
			list_data=attendanceDAO.list_attendance(query);
			CacheKit.put("ehcache10", "attendance"+query, list_data);
		}
		return list_data;
	}

	@Override
	public int listCount_attendance(Map<String, Object> query) throws BusinessException {

		return attendanceDAO.listCount_attendance(query);
	}
//员工考勤
	
	@Override
	public Page<Map<String, Object>> list_attendanceEmployee(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		query.put("USER_ID", SessionUtil.getEmid());
		
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = attendanceDAO.list_attendanceEmployee(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_attendanceEmployee(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);
  		return page;
	}

	@Override
	public List<Map<String, Object>> list_attendanceEmployee(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "attendanceEmployee"+query);
		if(list_data==null || list_data.size()==0){
			list_data=attendanceDAO.list_attendanceEmployee(query);
			CacheKit.put("ehcache10", "attendanceEmployee"+query, list_data);
		}
		return list_data;
	}

	@Override
	public int listCount_attendanceEmployee(Map<String, Object> query) throws BusinessException {

		return attendanceDAO.listCount_attendanceEmployee(query);
	}

}
