package com.jw.app.business.bgmk;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;


import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;
import com.jw.app.business.BgmkBusiness;

public class BgmkBusinessImpl implements BgmkBusiness {
	
	private bgmkDAO bgmkDAO;

	public bgmkDAO getBgmkDAO() {
		return bgmkDAO;
	}

	public void setBgmkDAO(bgmkDAO bgmkDAO) {
		this.bgmkDAO = bgmkDAO;
	}

	@Override
	public void insert_bgmk(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", SessionUtil.getCode());
		}
		if(entity.get("DEPT_ID")==null){
			entity.put("DEPT_ID", SessionUtil.getEmdepart());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("USER_NAME")==null){
			entity.put("USER_NAME", SessionUtil.getCode());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		
		if(entity.get("DEPT_NAME")==null){
			entity.put("DEPT_NAME", SessionUtil.getEmdepartname());
		}
		
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          bgmkDAO.insert_bgmk(entity);
        }
	}
	@Override
	public void update_bgmk(Map<String, Object> entity) throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    bgmkDAO.update_bgmk(entity);
		}

	}

	@Override
	public void delete_bgmk(List<String> list) throws BusinessException {
		bgmkDAO.delete_bgmk(list);
		
	}
	
	
	//管理类报工
	@Override
	public Page<Map<String, Object>> list_bgmk(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = bgmkDAO.list_bgmk(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_bgmk(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_bgmk(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "bgmk"+query);
		if(list_data==null || list_data.size()==0){
			list_data=bgmkDAO.list_bgmk(query);
			CacheKit.put("ehcache10", "bgmk"+query, list_data);
		}
		return list_data;
	}

	@Override
	public int listCount_bgmk(Map<String, Object> query) throws BusinessException {
		return bgmkDAO.listCount_bgmk(query);
	}

	//个人报工
		@Override
		public Page<Map<String, Object>> list_bgmk_employee(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
			query.put("USER_NAME", SessionUtil.getEmid());
			//计算起始记录
	  		int pageStart = (pageNo - 1) * pageSize;
	  		
	  		//获取列表
	  		List<Map<String, Object>> items = bgmkDAO.list_bgmk(new RowBounds(pageStart, pageSize), query);
	  		//获取列表个数
	  		int count = listCount_bgmk_employee(query);
	  		
	  		//创建分页对象
	  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
	  		page.setStart(pageStart);
	  		page.setLimit(pageSize);
	  		page.setCount(count);
	  		page.setItems(items);

	  		return page;
		}

		@Override
		public List<Map<String, Object>> list_bgmk_employee(Map<String, Object> query) throws BusinessException {
			List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "bgmk_employee"+query);
			if(list_data==null || list_data.size()==0){
				list_data=bgmkDAO.list_bgmk(query);
				CacheKit.put("ehcache10", "bgmk_employee"+query, list_data);
			}
			return list_data;
		}

		@Override
		public int listCount_bgmk_employee(Map<String, Object> query) throws BusinessException {
			return bgmkDAO.listCount_bgmk(query);
		}
	
}

