package com.jw.app.business.calendar;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.CalendarBusiness;
import com.jw.app.business.utils.DateTools;

public class CalendarBusinessImpl implements CalendarBusiness {

	private calendarDAO calendarDAO;

	public calendarDAO getCalendarDAO() {
		return calendarDAO;
	}

	public void setCalendarDAO(calendarDAO calendarDAO) {
		this.calendarDAO = calendarDAO;
	}

	@Override
	public Page<Map<String, Object>> list_calendar_by_user(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
		if (query.get("START_TIME") != null) {
			try {
				query.put("START_TIME", new Date(Long.valueOf(query.get("START_TIME").toString())));
			} catch (NumberFormatException e) {
				try {
					query.put("START_TIME", DateTools.strToDate(query.get("START_TIME").toString()));
				} catch (ParseException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}
		if (query.get("END_TIME") != null) {
			try {
				query.put("END_TIME", new Date(Long.valueOf(query.get("END_TIME").toString())));
			} catch (NumberFormatException e) {
				try {
					query.put("END_TIME", DateTools.strToDate(query.get("END_TIME").toString()));
				} catch (ParseException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}

		if (query.get("TITLE") != null && !"".equals(query.get("TITLE"))) {
			query.put("TITLE_LIKE", "%" + query.get("TITLE") + "%");
		}

		if (query.get("USER_ID") == null || "".equals(query.get("USER_ID"))) {
			// 默认查询当前登陆人
			query.put("USER_ID", SessionUtil.getEmid());
		}

		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		List<Map<String, Object>> items = calendarDAO.list_calendar_by_user(new RowBounds(pageStart, pageSize), query);
		int count = calendarDAO.list_count_calendar_by_user(query);
		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);
		return page;
	}

	@Override
	public Map<String, Object> save_calendar(Map<String, Object> info) throws BusinessException {
		if (info.get("UUID") == null || "".equals(info.get("UUID"))) {
			// 表示新增
			info.put("UUID", UUID.randomUUID().toString());
			if (info.get("USER_ID") == null || "".equals(info.get("USER_ID"))) {
				// 如果没有传USER_ID过来，则使用当前登录人id
				info.put("USER_ID", SessionUtil.getEmid());
			}

			info.put("CREATE_USER", SessionUtil.getEmid());
			info.put("CREATE_TIME", new Date());
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			calendarDAO.insert_calendar(info);
		} else {
			// 表示更新
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			// 防止修改记录的所属人
			info.remove("USER_ID");
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				if ("UUID".equals(k)) {
					continue;
				}
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			calendarDAO.update_calendar(info);
		}

		return info;
	}

	@Override
	public void delete_calendar(String uuid) throws BusinessException {
		for (String u : uuid.split(",")) {
			calendarDAO.delete_calendar(u);
		}
	}

	@Override
	public Page<Map<String, Object>> list_calendar_by_company(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
		if (query.get("START_TIME") != null) {
			try {
				query.put("START_TIME", new Date(Long.valueOf(query.get("START_TIME").toString())));
			} catch (NumberFormatException e) {
				try {
					query.put("START_TIME", DateTools.strToDate(query.get("START_TIME").toString()));
				} catch (ParseException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}
		if (query.get("END_TIME") != null) {
			try {
				query.put("END_TIME", new Date(Long.valueOf(query.get("END_TIME").toString())));
			} catch (NumberFormatException e) {
				try {
					query.put("END_TIME", DateTools.strToDate(query.get("END_TIME").toString()));
				} catch (ParseException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}

		if (query.get("TITLE") != null && !"".equals(query.get("TITLE"))) {
			query.put("TITLE_LIKE", "%" + query.get("TITLE") + "%");
		}

		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		List<Map<String, Object>> items = calendarDAO.list_calendar_by_company(new RowBounds(pageStart, pageSize), query);
		int count = calendarDAO.list_count_calendar_by_company(query);
		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);
		return page;
	}

	@Override
	public Map<String, Object> save_calendar_by_company(Map<String, Object> info) throws BusinessException {
		if (info.get("UUID") == null || "".equals(info.get("UUID"))) {
			// 表示新增
			info.put("UUID", UUID.randomUUID().toString());
			info.put("CREATE_USER", SessionUtil.getEmid());
			info.put("CREATE_TIME", new Date());
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			calendarDAO.insert_calendar_by_company(info);
		} else {
			// 表示更新
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				if ("UUID".equals(k)) {
					continue;
				}
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			calendarDAO.update_calendar_by_company(info);
		}

		return info;
	}

	@Override
	public void delete_calendar_company(String uuid) throws BusinessException {
		for (String u : uuid.split(",")) {
			calendarDAO.delete_calendar_by_company(u);
		}
	}

}
