package com.jw.app.business.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.jw.app.business.LogBusiness;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;

public class LogBusinessImpl implements LogBusiness {

	private logDAO logDAO;

	public logDAO getlogDAO() {
		return logDAO;
	}

	public void setlogDAO(logDAO logDAO) {
		this.logDAO = logDAO;
	}

	@Override
	public void insert_log(Map<String, Object> entity) throws BusinessException {

		entity.put("UUID", java.util.UUID.randomUUID().toString());
		entity.put("CREATE_NAME", SessionUtil.getEmname());
		entity.put("CREATE_ID", SessionUtil.getCode());
		entity.put("CREATE_TIME", new Date());
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("UPDATE_TIME", new Date());
		// 动态传值插入
		List<String> infoListKey = new ArrayList<String>();
		List<Object> infoList = new ArrayList<Object>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				infoList.add(entity.get(str));
				infoListKey.add(str);
			}
			entity.put("infoListKey", infoListKey);
			entity.put("infoList", infoList);
			// 插入
			logDAO.insert_log(entity);
		}
	}

	@Override
	public void update_log(Map<String, Object> entity) throws BusinessException {
		// 动态传值修改
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("UPDATE_TIME", new Date());
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				Map<String, Object> updateMap = new HashMap<String, Object>();
				if (StringUtils.equalsIgnoreCase("UUID", str))
					continue;
				updateMap.put("key", str);
				updateMap.put("value", entity.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
			//
			logDAO.update_log(entity);
		}

	}

	@Override
	public void delete_log(List<String> list) throws BusinessException {
		logDAO.delete_log(list);
		logDAO.delete_byLogId(list);

	}

	@Override
	public Page<Map<String, Object>> list_log(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = logDAO.list_log(new RowBounds(pageStart, pageSize),

				query);
		// 获取列表个数
		int count = listCount_log(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public List<Map<String, Object>> list_log(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = null;
		if (list_data == null || list_data.size() == 0) {
			list_data = logDAO.list_log(query);
		}
		return list_data;
	}

	@Override
	public int listCount_log(Map<String, Object> query) throws BusinessException {
		return logDAO.listCount_log(query);
	}
	
	@Override
	public Page<Map<String, Object>> list_reply(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = logDAO.list_reply(new RowBounds(pageStart, pageSize),

				query);
		// 获取列表个数
		int count = listCount_reply(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public List<Map<String, Object>> list_reply(Map<String, Object> query) throws BusinessException {
		return logDAO.list_reply(query);
	}

	@Override
	public int listCount_reply(Map<String, Object> query) throws BusinessException {
		return logDAO.listCount_reply(query);
	}

	@Override
	public void insert_reply(Map<String, Object> entity) throws BusinessException {
		entity.put("UUID", java.util.UUID.randomUUID().toString());
		entity.put("CODE", SessionUtil.getCode());
		entity.put("REPLY_NAME", SessionUtil.getEmname());
		entity.put("REPLY_TIME", new Date());
		entity.put("CREATE_ID", SessionUtil.getCode());
		entity.put("CREATE_TIME", new Date());
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("UPDATE_TIME", new Date());
		List<String> itemListKey = new ArrayList<String>();
		List<Object> itemList = new ArrayList<Object>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				itemList.add(entity.get(str));
				itemListKey.add(str);
			}
			entity.put("itemListKey", itemListKey);
			entity.put("itemList", itemList);
			// 插入
			logDAO.insert_reply(entity);
		}
	}

	@Override
	public void delete_reply(List<String> list) throws BusinessException {
		logDAO.delete_reply(list);
	}

}