package com.jw.app.business.meeting;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.jw.app.business.MeetingBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;

public class MeetingBusinessImpl implements MeetingBusiness {

	private meetingDAO meetingDAO;

	public meetingDAO getmeetingDAO() {
		return meetingDAO;
	}

	public void setmeetingDAO(meetingDAO meetingDAO) {
		this.meetingDAO = meetingDAO;
	}

	@Override
	public void insert_meeting(Map<String, Object> entity) throws BusinessException {
		entity.put("UUID", java.util.UUID.randomUUID().toString());
		entity.put("CREATE_ID", SessionUtil.getCode());
		entity.put("CREATE_TIME", new Date());
		entity.put("UPDATE_ID", SessionUtil.getCode());

		entity.put("UPDATE_TIME", new Date());
		// 动态传值插入
		List<String> infoListKey = new ArrayList<String>();
		List<Object> infoList = new ArrayList<Object>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				infoList.add(entity.get(str));
				infoListKey.add(str);
			}
			entity.put("infoListKey", infoListKey);
			entity.put("infoList", infoList);
			// 插入
			meetingDAO.insert_meeting(entity);
		}
	}

	@Override
	public void insert_check_in(Map<String, Object> entity) throws BusinessException {
		List<Map<String, Object>> items = meetingDAO.list_check_in(entity);
		if (items.size() == 0) {
			entity.put("UUID", java.util.UUID.randomUUID().toString());
			entity.put("PARTICIPANTS_ID", SessionUtil.getCode());
			entity.put("PARTICIPANTS_NAME", SessionUtil.getEmname());
			entity.put("CHECK_IN_TIME", new Date());
			entity.put("CREATE_ID", SessionUtil.getCode());
			entity.put("CREATE_TIME", new Date());
			entity.put("UPDATE_ID", SessionUtil.getCode());
			entity.put("UPDATE_TIME", new Date());
			// 动态传值插入
			List<String> infoListKey = new ArrayList<String>();
			List<Object> infoList = new ArrayList<Object>();
			if (entity.keySet() != null) {
				Set<String> key = entity.keySet();
				// 将map集合中的key和value 取出来分别放到list集合里
				for (String str : key) {
					infoList.add(entity.get(str));
					infoListKey.add(str);
				}
				entity.put("infoListKey", infoListKey);
				entity.put("infoList", infoList);
				// 插入
				meetingDAO.insert_check_in(entity);
			}
		}
	}

	@Override
	public void update_meeting(Map<String, Object> entity) throws BusinessException {
		// 动态传值修改
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("UPDATE_TIME", new Date());
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				Map<String, Object> updateMap = new HashMap<String, Object>();
				if (StringUtils.equalsIgnoreCase("UUID", str))
					continue;
				updateMap.put("key", str);
				updateMap.put("value", entity.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
			//
			meetingDAO.update_meeting(entity);
		}

	}

	@Override
	public void delete_meeting(List<String> list) throws BusinessException {
		meetingDAO.delete_meeting(list);
		meetingDAO.delete_check_in(list);

	}

	@Override
	public Page<Map<String, Object>> list_meeting(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = meetingDAO.list_meeting(new RowBounds(pageStart, pageSize), query);
		// 获取列表个数
		int count = listCount_meeting(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public Page<Map<String, Object>> list_check_in(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = meetingDAO.list_check_in(new RowBounds(pageStart, pageSize), query);
		// 获取列表个数
		int count = listCount_check_in(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public List<Map<String, Object>> list_check_in(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = null;
		if (list_data == null || list_data.size() == 0) {
			list_data = meetingDAO.list_check_in(query);
		}
		return list_data;
	}

	@Override
	public int listCount_check_in(Map<String, Object> query) throws BusinessException {
		return meetingDAO.listCount_check_in(query);
	}

	@Override
	public List<Map<String, Object>> list_meeting(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "meeting" + query);
		if (list_data == null || list_data.size() == 0) {
			list_data = meetingDAO.list_meeting(query);
			CacheKit.put("ehcache10", "kqmk" + query, list_data);
		}
		return list_data;
	}

	@Override
	public int listCount_meeting(Map<String, Object> query) throws BusinessException {
		return meetingDAO.listCount_meeting(query);
	}

}
