package com.jw.app.business.notice;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;


import com.jw.app.business.NoticeBusiness;
import com.jw.app.business.utils.DateTools;

import groovy.sql.InParameter;

public class NoticeBusinessImpl implements NoticeBusiness {

	private noticeDAO noticeDAO;

	public noticeDAO getNoticeDAO() {
		return noticeDAO;
	}

	public void setNoticeDAO(noticeDAO noticeDAO) {
		this.noticeDAO = noticeDAO;
	}

	@Override
	public Page<Map<String, Object>> list_notice(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
		
		if (query.get("USER_ID") == null || "".equals(query.get("USER_ID"))) {
			// 默认查询当前登陆人
			query.put("USER_ID", SessionUtil.getEmid());
		}

		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		List<Map<String, Object>> items = noticeDAO.list_notice(new RowBounds(pageStart, pageSize), query);
		int count = noticeDAO.list_count_notice(query);
		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);
		return page;
	}

	@Override
	public Map<String, Object> save_notice(Map<String, Object> info) throws BusinessException {
		if (info.get("UUID") == null || "".equals(info.get("UUID"))) {
			// 表示新增
			info.put("UUID", UUID.randomUUID().toString());
			if (info.get("USER_ID") == null || "".equals(info.get("USER_ID"))) {
				// 如果没有传USER_ID过来，则使用当前登录人id
				info.put("USER_ID", SessionUtil.getEmid());
			}	
			info.put("CREATE_ID", SessionUtil.getEmid());
			info.put("CREATE_TIME", new Date());
			info.put("UPDATE_ID", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			noticeDAO.insert_notice(info);
		} else {
			// 表示更新
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			// 防止修改记录的所属人
			info.remove("USER_ID");
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				if ("UUID".equals(k)) {
					continue;
				}
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			noticeDAO.update_notice(info);
		}

		return info;
	}

	@Override
	public void delete_notice(String uuid) throws BusinessException {
		for (String u : uuid.split(",")) {
			noticeDAO.delete_notice(u);
		}
	}
}
