package com.jw.app.business.portal.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortalAppsBusiness;

public class AppsBusinessImpl implements PortalAppsBusiness {
	
	private appsDAO appsDAO;

	public appsDAO getAppsDAO() {
		return appsDAO;
	}

	public void setAppsDAO(appsDAO appsDAO) {
		this.appsDAO = appsDAO;
	}
	
	/**--------------APPS_APP app详细信息---------------- **/
	@Override
	public String insert_app_account(Map<String, Object> entity)
			throws BusinessException {
		String new_id = java.util.UUID.randomUUID().toString();
		if(entity.get("IDU")==null){
			entity.put("IDU", new_id);
		}
		if(entity.get("USERID")==null){
			entity.put("USERID", SessionUtil.getCode());
		}
		if(entity.get("SIGN")==null){
			entity.put("SIGN", "1");
		}
		if(entity.get("ALIAS")==null){
			entity.put("ALIAS", SessionUtil.getEmname());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          appsDAO.insert_app_account(entity);
        }
		//
		
        return new_id;
	}

	@Override
	public void update_app_account(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("IDU",str)) continue;
			   if (StringUtils.equalsIgnoreCase("USERID",str)) continue;
			   if (StringUtils.equalsIgnoreCase("APP_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    appsDAO.update_app_account(entity);
		}
		//

	}

	@Override
	public void delete_app_account(List<String> list)
			throws BusinessException {
		appsDAO.delete_app_account(list);	
	}

	@Override
	public Page<Map<String, Object>> list_app_account(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_app_account(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_app_account(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_app_account(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_app_account(query);
	}

	@Override
	public int listCount_app_account(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_app_account(query);
	}

	/**--------------APPS_APP app详细信息---------------- **/
	@Override
	public String insert_app(Map<String, Object> entity)
			throws BusinessException {
		String new_id = java.util.UUID.randomUUID().toString();
		if(entity.get("APP_ID")==null){
			entity.put("APP_ID", new_id);
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("NEED_HEAD")==null){
			entity.put("NEED_HEAD", "0");
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          appsDAO.insert_app(entity);
        }
		//
		
        return new_id;
	}

	@Override
	public void update_app(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//删除原来的图片
	    if(entity.get("OLD_IMAGE")!=null){
			String delFileName = (String) entity.get("OLD_IMAGE");
			File delFile = new File(delFileName);
			if(delFile.exists()){
				System.out.println("(OLD_IMAGE)图片:"+delFileName+" 存在!");
				if(delFile.delete()){
					System.out.println("(OLD_IMAGE)图片:"+delFileName+" 删除成功!");
				}else{
					System.out.println("(OLD_IMAGE)图片:"+delFileName+" 删除失败!");
				}
			}else{
				System.out.println("(OLD_IMAGE)图片:"+delFileName+" 不存在!");
			}
			entity.remove("OLD_IMAGE");
		}
	    //
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("APP_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    appsDAO.update_app(entity);
		}
		//

	}

	@Override
	public void delete_app(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_app = appsDAO.list_delete_app(list);
		appsDAO.delete_app(list);
		for(Map<String, Object> mfile : list_delete_app){
			
			if(mfile.get("IMG_ID_L")!=null){
				String delFileName = (String) mfile.get("IMG_ID_L");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("(IMG_ID_L)图片:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("(IMG_ID_L)图片:"+delFileName+" 删除成功!");
					}else{
						System.out.println("(IMG_ID_L)图片:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("(IMG_ID_L)图片:"+delFileName+" 不存在!");
				}
			}else if(mfile.get("IMG_ID_M")!=null){
				String delFileName = (String) mfile.get("IMG_ID_M");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("(IMG_ID_M)图片:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("(IMG_ID_M)图片:"+delFileName+" 删除成功!");
					}else{
						System.out.println("(IMG_ID_M)图片:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("(IMG_ID_M)图片:"+delFileName+" 不存在!");
				}
			}else if(mfile.get("IMG_ID_S")!=null){
				String delFileName = (String) mfile.get("IMG_ID_S");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("(IMG_ID_S)图片:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("(IMG_ID_S)图片:"+delFileName+" 删除成功!");
					}else{
						System.out.println("(IMG_ID_S)图片:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("(IMG_ID_S)图片:"+delFileName+" 不存在!");
				}
			}
		}
		
	}

	@Override
	public Page<Map<String, Object>> list_app(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_app(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_app(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_app(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_app(query);
	}

	@Override
	public int listCount_app(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_app(query);
	}
	
	/**--------------APPS_CATEGORY app分类信息---------------- **/
	@Override
	public void insert_category(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("CATEGORY_ID")==null){
			entity.put("CATEGORY_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          appsDAO.insert_category(entity);
        }
		//
		

	}

	@Override
	public void update_category(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("CATEGORY_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    appsDAO.update_category(entity);
		}
		//

	}

	@Override
	public void delete_category(List<String> list)
			throws BusinessException {
		appsDAO.delete_category(list);	
	}

	@Override
	public Page<Map<String, Object>> list_category(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_category(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_category(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_category(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_category(query);
	}

	@Override
	public int listCount_category(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_category(query);
	}
	
	/**--------------APP_INSTALL app用户安装信息 ---------------- **/
	@Override
	public void insert_install(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("USERID")==null){
			entity.put("USERID", SessionUtil.getCode());
		}
		if(entity.get("INSTALL_TIME")==null){
			entity.put("INSTALL_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          appsDAO.insert_install(entity);
        }
		//
		

	}

	@Override
	public void update_install(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("RESOURCE_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    appsDAO.update_install(entity);
		}
		//

	}

	@Override
	public void delete_install(List<String> list)
			throws BusinessException {
		appsDAO.delete_install(list);	
	}
	
	@Override
	public void delete_install_app_id(List<String> list)
			throws BusinessException {
		appsDAO.delete_install_app_id(list);	
	}
	
	@Override
	public void delete_install_app_user(Map<String, Object> query)
			throws BusinessException {
		if(query.get("USERID")==null){
			query.put("USERID", SessionUtil.getCode());
		}
		appsDAO.delete_install_app_user(query);	
	}

	@Override
	public Page<Map<String, Object>> list_install(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_install(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_install(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_install(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_install(query);
	}

	@Override
	public int listCount_install(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_install(query);
	}
	
	/**--------------APPS_UNINSTALL app用户卸载信息 ---------------- **/
	@Override
	public void insert_uninstall(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("USERID")==null){
			entity.put("USERID", SessionUtil.getCode());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          appsDAO.insert_uninstall(entity);
        }
		//
		

	}


	@Override
	public void update_uninstall(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("RESOURCE_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    appsDAO.update_uninstall(entity);
		}
		//

	}

	@Override
	public void delete_uninstall(List<String> list)
			throws BusinessException {
		appsDAO.delete_uninstall(list);	
	}
	
	@Override
	public void delete_uninstall_app_id(List<String> list)
			throws BusinessException {
		appsDAO.delete_uninstall_app_id(list);	
	}
	
	@Override
	public void delete_uninstall_app_user(Map<String, Object> query)
			throws BusinessException {
		if(query.get("USERID")==null){
			query.put("USERID", SessionUtil.getCode());
		}
		appsDAO.delete_uninstall_app_user(query);	
	}

	@Override
	public Page<Map<String, Object>> list_uninstall(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_uninstall(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_uninstall(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_uninstall(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_uninstall(query);
	}

	@Override
	public int listCount_uninstall(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_uninstall(query);
	}
	
	/**--------------APPS_USERALLAPP用户所有已安装和未安装app信息  ---------------- **/
	@Override
	public Page<Map<String, Object>> list_userallapp(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = appsDAO.list_userallapp(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = appsDAO.listCount_userallapp(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	/**--------------APPS_USERALLAPP_NEWUSER找出所有未安装app的信息 ---------------- **/
	@Override
	public List<Map<String, Object>> list_userallapp(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_userallapp(query);
	}

	@Override
	public int listCount_userallapp(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.listCount_userallapp(query);
	}
	
	@Override
	public List<Map<String, Object>> list_userallapp_newuser(Map<String, Object> query)
			throws BusinessException {
		return appsDAO.list_userallapp_newuser(query);
	}

	@Override
	public List<Map<String, Object>> list_apps_portal(Map<String, Object> query) throws BusinessException {
		return appsDAO.list_apps_portal(query);
	}

}
