package com.jw.app.business.portal.portlet;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortalPortletBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class PortletBusinessImpl implements PortalPortletBusiness {
	
	private PortletDAO portletDAO;	

	public PortletDAO getPortletDAO() {
		return portletDAO;
	}

	public void setPortletDAO(PortletDAO portletDAO) {
		this.portletDAO = portletDAO;
	}

	@Override
	public void insert_portlet_template(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("PORTLET_ID")==null){
			entity.put("PORTLET_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_NAME")==null){
			entity.put("CREATOR_NAME", SessionUtil.getEmname());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入

		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里

          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          portletDAO.insert_portlet_template(entity);
        }
		//
		

	}

	@Override
	public void update_portlet_template(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改

		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里

		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("PORTLET_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    portletDAO.update_portlet_template(entity);
		}
		//

	}

	@Override
	public void delete_portlet_template(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_user_ext = portletDAO.list_delete_portlet_template(list);
		portletDAO.delete_portlet_template(list);
		for(Map<String, Object> mfile : list_delete_user_ext){
			if(mfile.get("ICON")!=null){
				String delFileName = (String) mfile.get("ICON");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("图标文件:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("图标文件:"+delFileName+" 删除成功!");
					}else{
						System.out.println("图标文件:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("图标文件:"+delFileName+" 不存在!");
				}
			}
		}
		
	}
	
	@Override
	public Page<Map<String, Object>> list_portlet_template(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = portletDAO.list_portlet_template(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = portletDAO.listCount_portlet_template(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_portlet_template(Map<String, Object> query)
			throws BusinessException {
		List<Map<String, Object>> listData=null;
		try {
			listData = QueryParamUtil.ClobToString(portletDAO.list_portlet_template(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}
	
	@Override
	public List<Map<String, Object>> list_portlet_template_by_user(Map<String, Object> query)
			throws BusinessException {
		List<Map<String, Object>> listData=null;
		try {
			listData = QueryParamUtil.ClobToString(portletDAO.list_portlet_template_user(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

	@Override
	public int listCount_portlet_template(Map<String, Object> query)
			throws BusinessException {
		return portletDAO.listCount_portlet_template(query);
	}
	
	@Override
	public List<Map<String, Object>> list_portlet_mytemplate_notall(Map<String, Object> query) throws BusinessException {
		return portletDAO.list_portlet_mytemplate_notall(query);
	}
	
	@Override
	public List<Map<String, Object>> list_portlet_mytemplate_all(Map<String, Object> query) throws BusinessException {
		return portletDAO.list_portlet_mytemplate_all(query);
	}
	
	@Override
	public void insert_portlet_setup(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", SessionUtil.getCode());
		}
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入

		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里

          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          portletDAO.insert_portlet_setup(entity);
        }
		//
		

	}

	@Override
	public void update_portlet_setup(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", SessionUtil.getCode());
		}
		//动态传值修改

		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里

		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str) || StringUtils.equalsIgnoreCase("USER_ID",str) || StringUtils.equalsIgnoreCase("LOCATION",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    portletDAO.update_portlet_setup(entity);
		}
		//

	}

	@Override
	public void delete_portlet_setup(List<String> list)
			throws BusinessException {
		portletDAO.delete_portlet_setup(list);
	}

	@Override
	public Page<Map<String, Object>> list_portlet_setup(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		if(query.get("USER_ID")==null){
  			query.put("USER_ID", SessionUtil.getCode());
  		}
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = portletDAO.list_portlet_setup(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = portletDAO.listCount_portlet_setup(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_portlet_setup(Map<String, Object> query)
			throws BusinessException {
		if(query.get("USER_ID")==null){
  			query.put("USER_ID", SessionUtil.getCode());
  		}
		return portletDAO.list_portlet_setup(query);
	}

	@Override
	public int listCount_portlet_setup(Map<String, Object> query)
			throws BusinessException {
		if(query.get("USER_ID")==null){
  			query.put("USER_ID", SessionUtil.getCode());
  		}
		return portletDAO.listCount_portlet_setup(query);
	}

	@Override
	public List<Map<String, Object>> listBaseApps(Map<String, Object> query) throws BusinessException {
		return portletDAO.listBaseApps(query);
	}

}
