package com.jw.app.business.portal.role;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortalAppsRoleBusiness;
import com.jw.app.business.portal.apps.appsDAO;

public class AppsRoleBusinessImpl implements PortalAppsRoleBusiness {

	private appsRoleDAO appsRoleDAO;

	private appsDAO appsDAO;

	public appsRoleDAO getAppsRoleDAO() {
		return appsRoleDAO;
	}

	public void setAppsRoleDAO(appsRoleDAO appsRoleDAO) {
		this.appsRoleDAO = appsRoleDAO;
	}

	public appsDAO getAppsDAO() {
		return appsDAO;
	}

	public void setAppsDAO(appsDAO appsDAO) {
		this.appsDAO = appsDAO;
	}

	@Override
	public Page<Map<String, Object>> list_apps_role(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 查询条件处理
		if (query.get("ROLE_NAME") != null && !"".equals(query.get("ROLE_NAME"))) {
			query.put("ROLE_NAME_LIKE", "%" + query.get("ROLE_NAME") + "%");
		}
		if (query.get("DESCRIBE_INFO") != null && !"".equals(query.get("DESCRIBE_INFO"))) {
			query.put("DESCRIBE_INFO_LIKE", "%" + query.get("DESCRIBE_INFO") + "%");
		}

		List<Map<String, Object>> items = appsRoleDAO.list_apps_role(new RowBounds(pageStart, pageSize), query);
		int count = appsRoleDAO.list_count_apps_role(query);
		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);
		return page;
	}

	@Override
	public List<Map<String, Object>> list_all_apps_role(Map<String, Object> query) throws BusinessException {
		// 查询条件处理
		if (query.get("ROLE_NAME") != null && !"".equals(query.get("ROLE_NAME"))) {
			query.put("ROLE_NAME_LIKE", "%" + query.get("ROLE_NAME") + "%");
		}
		if (query.get("DESCRIBE_INFO") != null && !"".equals(query.get("DESCRIBE_INFO"))) {
			query.put("DESCRIBE_INFO_LIKE", "%" + query.get("DESCRIBE_INFO") + "%");
		}

		return appsRoleDAO.list_apps_role(query);
	}

	@Override
	public Map<String, Object> save_apps_role(Map<String, Object> info) throws BusinessException {
		if (info.get("UUID") == null || "".equals(info.get("UUID"))) {
			// 表示新增
			info.put("UUID", UUID.randomUUID().toString());
			info.put("CREATE_USER", SessionUtil.getEmid());
			info.put("CREATE_TIME", new Date());
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			appsRoleDAO.insert_apps_role(info);
		} else {
			// 表示更新
			info.put("UPDATE_USER", SessionUtil.getEmid());
			info.put("UPDATE_TIME", new Date());
			List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
			for (String k : info.keySet()) {
				if ("UUID".equals(k)) {
					continue;
				}
				Map<String, Object> field = new HashMap<String, Object>();
				field.put("key", k);
				field.put("value", info.get(k));
				listField.add(field);
			}
			info.put("list", listField);
			appsRoleDAO.update_apps_role(info);
		}

		return info;
	}

	@Override
	public void delete_apps_role(String uuids) throws BusinessException {
		List<String> listUuid = new ArrayList<String>();
		for (String uuid : uuids.split(",")) {
			listUuid.add(uuid);
			appsRoleDAO.delete_apps_role_user_by_roleId(uuid);
		}
		appsRoleDAO.delete_apps_role(listUuid);
	}

	@Override
	public List<Map<String, Object>> list_all_user(Map<String, Object> query) throws BusinessException {
		return appsRoleDAO.list_all_user(query);
	}

	@Override
	public List<Map<String, Object>> list_all_user_by_roleId(Map<String, Object> query) throws BusinessException {
		return appsRoleDAO.list_all_user_by_roleId(query);
	}

	@Override
	public void saveUserByRoleId(String roleId, String users) throws BusinessException {
		// 查询该角色下原本有的人员
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("ROLE_ID", roleId);
		List<Map<String, Object>> listUsersOld = appsRoleDAO.list_all_user_by_roleId(query);

		// 查询该角色用于哪些app
		Map<String, Object> query2 = new HashMap<String, Object>();
		query2.put("G_ID", roleId);
		List<Map<String, Object>> listApp = appsDAO.list_app(query2);

		// 删除原先该角色下所有的用户
		appsRoleDAO.delete_apps_role_user_by_roleId(roleId);

		// 重新添加用户
		String[] arrayUser = null;
		if (users != null && !"".equals(users)) {
			arrayUser = users.split(",");
			for (String userId : arrayUser) {
				Map<String, Object> info = new HashMap<String, Object>();
				info.put("USER_ID", userId);
				info.put("ROLE_ID", roleId);
				info.put("UUID", UUID.randomUUID().toString());
				info.put("CREATE_USER", SessionUtil.getEmid());
				info.put("CREATE_TIME", new Date());
				info.put("UPDATE_USER", SessionUtil.getEmid());
				info.put("UPDATE_TIME", new Date());

				List<Map<String, Object>> listField = new ArrayList<Map<String, Object>>();
				for (String k : info.keySet()) {
					Map<String, Object> field = new HashMap<String, Object>();
					field.put("key", k);
					field.put("value", info.get(k));
					listField.add(field);
				}
				info.put("list", listField);
				appsRoleDAO.insert_apps_role_user(info);
			}
		}
		if (arrayUser == null) {
			arrayUser = new String[] {};
		}
		// 获取少了哪些用户
		List<String> listLessUser = new ArrayList<String>();
		outer: for (Map<String, Object> user : listUsersOld) {
			for (String userId : arrayUser) {
				if (userId.equals(user.get("USER_ID"))) {
					continue outer;
				}
			}
			listLessUser.add(user.get("USER_ID").toString());
		}

		// 获取多了哪些用户
		List<String> listMuchUser = new ArrayList<String>();
		outer: for (String userId : arrayUser) {
			for (Map<String, Object> user : listUsersOld) {
				if (userId.equals(user.get("USER_ID"))) {
					continue outer;
				}
			}
			listMuchUser.add(userId);
		}

		// 循环遍历这些app，如果这些app是默认需要安装的，则给多了的用户添加安装数据
		List<String> listAppId = new ArrayList<String>();
		for (Map<String, Object> app : listApp) {
			listAppId.add(app.get("APP_ID").toString());
			// 判断是否需要默认安装
			if ("1".equals(app.get("IS_DEFAULT"))) {
				// 需要安装
				for (String userId : listMuchUser) {
					Map<String, Object> entityNew = new HashMap<String, Object>();
					entityNew.put("APP_ID", app.get("APP_ID").toString());
					entityNew.put("USERID", userId);
					insert_install(entityNew);
				}
			}
		}

		// 删除少了的用户对应这些app的安装记录
		Map<String, Object> query4 = new HashMap<String, Object>();
		query4.put("USERIDS", listLessUser);
		query4.put("APP_IDS", listAppId);
		appsDAO.delete_install_app_byuser(query4);

	}

	private void insert_install(Map<String, Object> entity) throws BusinessException {
		if (entity.get("RESOURCE_ID") == null) {
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if (entity.get("USERID") == null) {
			entity.put("USERID", SessionUtil.getCode());
		}
		if (entity.get("INSTALL_TIME") == null) {
			entity.put("INSTALL_TIME", new Date());
		}
		// 动态传值插入
		List<String> infoListKey = new ArrayList<String>();
		List<Object> infoList = new ArrayList<Object>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				infoList.add(entity.get(str));
				infoListKey.add(str);
			}
			entity.put("infoListKey", infoListKey);
			entity.put("infoList", infoList);
			// 插入
			appsDAO.insert_install(entity);
		}
		//

	}

}
