package com.jw.app.business.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.StoreBusiness;

public class StoreBusinessImpl implements StoreBusiness {

	private storeDAO storeDAO;

	public storeDAO getStoreDAO() {
		return storeDAO;
	}

	public void setStoreDAO(storeDAO storeDAO) {
		this.storeDAO = storeDAO;
	}

	@Override
	public void insert_store(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          storeDAO.insert_store(entity);
        }
	}

	@Override
	public void update_store(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    storeDAO.update_store(entity);
		}

	}

	@Override
	public void setnull_binary_data(List<String> list) throws BusinessException {
		storeDAO.setnull_binary_data(list);
		
	}
	
	@Override
	public void delete_store(List<String> list) throws BusinessException {
		storeDAO.delete_store(list);
		
	}
	
	@Override
	public void resume_store(List<String> list) throws BusinessException {
		storeDAO.resume_store(list);
		
	}
	
	@Override
	public void delete_true_store(List<String> list) throws BusinessException {
		storeDAO.delete_true_store(list);
		
	}
	
	@Override
	public Page<Map<String, Object>> list_storenofile(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storeDAO.list_storenofile(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_store(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_storenofile(Map<String, Object> query) throws BusinessException {
		return storeDAO.list_storenofile(query);
	}

	@Override
	public Page<Map<String, Object>> list_store(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storeDAO.list_store(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_store(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_store(Map<String, Object> query) throws BusinessException {
		return storeDAO.list_store(query);
	}

	@Override
	public int listCount_store(Map<String, Object> query) throws BusinessException {
		return storeDAO.listCount_store(query);
	}
	
	@Override
	public List<Map<String, Object>> list_storetree(Map<String, Object> query) throws BusinessException {
		return storeDAO.list_storetree(query);
	}
	
	 /**---------------供其它模块接口使用-------------------**/
	
	
	@Override
	public Page<Map<String, Object>> list_storenofile_webservices(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storeDAO.list_storenofile_webservices(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_store(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_storenofile_webservices(Map<String, Object> query) throws BusinessException {
		return storeDAO.list_storenofile_webservices(query);
	}

	@Override
	public void delete_store_common(Map<String, Object> query) throws BusinessException {
		storeDAO.delete_store_common(query);
		
	}
	
	@Override
	public void resume_store_common(Map<String, Object> query) throws BusinessException {
		storeDAO.resume_store_common(query);
		
	}
	
	@Override
	public void delete_true_store_common(Map<String, Object> query) throws BusinessException {
		storeDAO.delete_true_store_common(query);
		
	}

}
