package com.jw.app.business.store.partook;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.StorePartookBusiness;

public class StorePartookBusinessImpl implements StorePartookBusiness {
	
	private storePartookDAO storePartookDAO;
	
	public storePartookDAO getStorePartookDAO() {
		return storePartookDAO;
	}

	public void setStorePartookDAO(storePartookDAO storePartookDAO) {
		this.storePartookDAO = storePartookDAO;
	}

	@Override
	public void insert_partook(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("PARTOOK_TIME")==null){
			entity.put("PARTOOK_TIME", new Date());
		}
		if(entity.get("PARTOOK_CODE")==null){
			entity.put("PARTOOK_CODE", java.util.UUID.randomUUID().toString());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          storePartookDAO.insert_partook(entity);
        }
	}

	@Override
	public void update_partook(Map<String, Object> entity) throws BusinessException {
		if(entity.get("PARTOOK_CODE")==null){
			entity.put("PARTOOK_CODE", java.util.UUID.randomUUID().toString());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    storePartookDAO.update_partook(entity);
		}

	}
	
	@Override
	public void delete_partook(List<String> list) throws BusinessException {
		storePartookDAO.delete_partook(list);
		
	}
	
	@Override
	public void resume_partook(List<String> list) throws BusinessException {
		storePartookDAO.resume_partook(list);
		
	}
	
	@Override
	public void delete_true_partook(List<String> list) throws BusinessException {
		storePartookDAO.delete_true_partook(list);
		
	}

	@Override
	public Page<Map<String, Object>> list_partook(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storePartookDAO.list_partook(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_partook(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_partook(Map<String, Object> query) throws BusinessException {
		return storePartookDAO.list_partook(query);
	}

	@Override
	public int listCount_partook(Map<String, Object> query) throws BusinessException {
		return storePartookDAO.listCount_partook(query);
	}

}
