package com.jw.app.business.store.personal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.StorePersonalBusiness;

public class StorePersonalBusinessImpl implements StorePersonalBusiness {


	private storePersonalDAO storePersonalDAO;
	
	public storePersonalDAO getStorePersonalDAO() {
		return storePersonalDAO;
	}

	public void setStorePersonalDAO(storePersonalDAO storePersonalDAO) {
		this.storePersonalDAO = storePersonalDAO;
	}

	@Override
	public void insert_storePersonal(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          storePersonalDAO.insert_storePersonal(entity);
        }
	}

	@Override
	public void update_storePersonal(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    storePersonalDAO.update_storePersonal(entity);
		}

	}

	@Override
	public void setnull_binary_data(List<String> list) throws BusinessException {
		storePersonalDAO.setnull_binary_data(list);
		
	}
	
	@Override
	public void delete_storePersonal(List<String> list) throws BusinessException {
		storePersonalDAO.delete_storePersonal(list);
		
	}
	
	@Override
	public void resume_storePersonal(List<String> list) throws BusinessException {
		storePersonalDAO.resume_storePersonal(list);
		
	}
	
	@Override
	public void delete_true_storePersonal(List<String> list) throws BusinessException {
		storePersonalDAO.delete_true_storePersonal(list);
		
	}
	
	@Override
	public Page<Map<String, Object>> list_storePersonalnofile(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//只能操作个人数据
		
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storePersonalDAO.list_storePersonalnofile(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_storePersonal(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_storePersonalnofile(Map<String, Object> query) throws BusinessException {
		return storePersonalDAO.list_storePersonalnofile(query);
	}

	@Override
	public Page<Map<String, Object>> list_storePersonal(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = storePersonalDAO.list_storePersonal(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_storePersonal(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_storePersonal(Map<String, Object> query) throws BusinessException {
		return storePersonalDAO.list_storePersonal(query);
	}

	@Override
	public int listCount_storePersonal(Map<String, Object> query) throws BusinessException {
		return storePersonalDAO.listCount_storePersonal(query);
	}
	
	@Override
	public List<Map<String, Object>> list_storePersonaltree(Map<String, Object> query) throws BusinessException {
		return storePersonalDAO.list_storePersonaltree(query);
	}

}
