package com.jw.app.business.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.jw.app.business.TableBusiness;
import com.jw.app.business.table.utils.Common;
import com.jw.app.business.utils.QueryParamUtil;

public class TableBusinessImpl implements TableBusiness{
	private TableDAO tableDAO;	

	public TableDAO getTableDAO() {
		return tableDAO;
	}

	public void setTableDAO(TableDAO tableDAO) {
		this.tableDAO = tableDAO;
	}

	@Override
	public void insert_tables_info(Map<String, Object> entity)
			throws BusinessException {
		// TODO Auto-generated method stub
		List<Map<String, Object>> list = (List<Map<String, Object>>) entity
				.get("insertInfoList");
		entity.remove("insertInfoList");
		for (Map<String, Object> map : list) {
			if (map.keySet() != null) {
				Set<String> key = map.keySet();
				for (Iterator<String> it = key.iterator(); it.hasNext();) {
					String s = it.next();
					if (map.get(s) == null) {
						map.put(s, "");
					}
				}
			}
		}
		List<String> infoListKey = new ArrayList<String>();
		List<Object> infoList = new ArrayList<Object>();
		Set<String> key = null;
		for (Map<String, Object> m : list) {

			key = m.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				if (StringUtils.equalsIgnoreCase("tableName", str))
					continue;
				infoList.add(m.get(str));
				infoListKey.add(str);
			}
			entity.put("infoListKey", infoListKey);
			entity.put("infoList", infoList);
			// 插入
			tableDAO.insert_tables_info(entity);
			infoList.removeAll(infoList);
			infoListKey.removeAll(infoListKey);
		}
	}

	@Override
	public void update_tables_info(Map<String, Object> entity)
			throws BusinessException {
		// TODO Auto-generated method stub
		List<Map<String, Object>> list = (List<Map<String, Object>>) entity
				.get("updateInfoList");
		entity.remove("updateInfoList");
		for (Map<String, Object> map : list) {
			if (map.keySet() != null) {
				Set<String> key = map.keySet();
				for (Iterator<String> it = key.iterator(); it.hasNext();) {
					String s = it.next();
					if (map.get(s) == null) {
						map.put(s, "");
					}
				}
			}
		}
		Set<String> key = null;
		for (Map<String, Object> m : list) {
			List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
			key = m.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里

			for (String str : key) {
				if (StringUtils.equalsIgnoreCase("UUID", str)) {
					entity.put("UUID", m.get(str));
					continue;
				} else if (StringUtils.equalsIgnoreCase("CODELIST", str)) {
					entity.put("CODELIST", QueryParamUtil
							.StringToList((String) m.get(str)));
					continue;
				} else if (StringUtils.equalsIgnoreCase("tableName", str))
					continue;
				Map<String, Object> updateMap = new HashMap<String, Object>();
				updateMap.put("key", str);
				updateMap.put("value", m.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
			//
			tableDAO.update_tables_info(entity);
		}
	}

	@Override
	public void delete_tables_info(Map<String, Object> entity)
			throws BusinessException {
		// TODO Auto-generated method stub
		tableDAO.delete_tables_info(entity);
	}


	@Override
	public int list_tables_info_Count(
			Map<String, Object> entity) throws BusinessException {
		// TODO Auto-generated method stub
		if (entity != null&&entity.get("selectInfoList")!=null) {
			List<Map<String, Object>> list = (List<Map<String, Object>>) entity
					.get("selectInfoList");
			entity.remove("selectInfoList");
			for (Map<String, Object> map : list) {
				if (map.keySet() != null) {
					Set<String> key = map.keySet();
					for (Iterator<String> it = key.iterator(); it.hasNext();) {
						String s = it.next();
						if (map.get(s) == null) {
							map.put(s, "");
						}
					}
				}
			}
			Set<String> key = null;
			for (Map<String, Object> m : list) {
				List<Map<String, Object>> selectList = new ArrayList<Map<String, Object>>();
				key = m.keySet();
				// 将map集合中的key和value 取出来分别放到list集合里

				for (String str : key) {
					if (StringUtils.equalsIgnoreCase("tableName", str))
						continue;
					Map<String, Object> selectMap = new HashMap<String, Object>();
					selectMap.put("key", str);
					selectMap.put("value", m.get(str));

					selectList.add(selectMap);
				}
				entity.put("infoList", selectList);
			}
		}
		return tableDAO.list_tables_info_Count(entity);
	}

	@Override
	public List<Map<String, Object>> list_tables_info(Map<String, Object> entity)
			throws BusinessException {
		// TODO Auto-generated method stub
		if (entity != null&&entity.get("selectInfoList")!=null) {
			List<Map<String, Object>> list = (List<Map<String, Object>>) entity
					.get("selectInfoList");
			entity.remove("selectInfoList");
			for (Map<String, Object> map : list) {
				if (map.keySet() != null) {
					Set<String> key = map.keySet();
					for (Iterator<String> it = key.iterator(); it.hasNext();) {
						String s = it.next();
						if (map.get(s) == null) {
							map.put(s, "");
						}
					}
				}
			}
			Set<String> key = null;
			for (Map<String, Object> m : list) {
				List<Map<String, Object>> selectList = new ArrayList<Map<String, Object>>();
				key = m.keySet();
				// 将map集合中的key和value 取出来分别放到list集合里

				for (String str : key) {
					if (StringUtils.equalsIgnoreCase("tableName", str))
						continue;
					Map<String, Object> selectMap = new HashMap<String, Object>();
					selectMap.put("key", str);
					selectMap.put("value", m.get(str));

					selectList.add(selectMap);
				}
				entity.put("infoList", selectList);
			}
		}
		
		try {
			return Common.ClobToString(tableDAO.list_tables_info(entity));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			
			e.printStackTrace();
			return null;
		}
	}

	@Override
	public Page<Map<String, Object>> list_tables_info(int pageNo, int pageSize,
			Map<String, Object> entity) throws BusinessException{
		// TODO Auto-generated method stub
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		if (entity != null&&entity.get("selectInfoList")!=null) {
			List<Map<String, Object>> list = (List<Map<String, Object>>) entity
					.get("selectInfoList");
			entity.remove("selectInfoList");
			for (Map<String, Object> map : list) {
				if (map.keySet() != null) {
					Set<String> key = map.keySet();
					for (Iterator<String> it = key.iterator(); it.hasNext();) {
						String s = it.next();
						if (map.get(s) == null) {
							map.put(s, "");
						}
					}
				}
			}
			Set<String> key = null;
			for (Map<String, Object> m : list) {
				List<Map<String, Object>> selectList = new ArrayList<Map<String, Object>>();
				key = m.keySet();
				// 将map集合中的key和value 取出来分别放到list集合里

				for (String str : key) {
					if (StringUtils.equalsIgnoreCase("tableName", str))
						continue;
					Map<String, Object> selectMap = new HashMap<String, Object>();
					selectMap.put("key", str);
					selectMap.put("value", m.get(str));

					selectList.add(selectMap);
				}
				entity.put("infoList", selectList);
			}
		}
		List<Map<String, Object>> items=null;
		try {
			items = Common.ClobToString(tableDAO.list_tables_info(
					new RowBounds(pageStart, pageSize), entity));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// 获取列表个数
		int count = tableDAO.list_tables_info_Count(entity);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);
		return page;
	}
}
