package com.jw.app.business.table.utils;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.TableBusiness;

public class Common {
	public static TableBusiness business = BusinessManager.getBusiness(TableBusiness.class);

	/**
	 * 查询详细信息
	 */
	public static Page<Map<String, Object>> list_table_info(String tableName,
			int pageNo, int pageSize, Map<String, Object> query) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		list.add(query);
		Map<String, Object> entity = new HashMap<String, Object>();
		entity.put("tableName", tableName);
		entity.put("selectInfoList", list);
		return business.list_tables_info(pageNo, pageSize, entity);
	}

	/**
	 * 查询详细信息
	 */
	public static List<Map<String, Object>> list_table_info(String tableName,
			Map<String, Object> query) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		list.add(query);
		Map<String, Object> entity = new HashMap<String, Object>();
		entity.put("tableName", tableName);
		entity.put("selectInfoList", list);
		return business.list_tables_info(entity);
	}

	/**
	 * 查询详细信息
	 */
	public static int list_table_info_Count(String tableName,Map<String, Object> query) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		list.add(query);
		Map<String, Object> entity = new HashMap<String, Object>();
		entity.put("tableName", tableName);
		entity.put("selectInfoList", list);
		return business.list_tables_info_Count(entity);
	}

	/**
	 * 新增
	 */
	public static void insert_table_info(String tableName,Map<String, Object> query) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		list.add(query);
		Map<String, Object> entity = new HashMap<String, Object>();
		entity.put("tableName", tableName);
		entity.put("insertInfoList", list);
		business.insert_tables_info(entity);
	}

	/**
	 * 修改
	 */
	public static void update_table_info(String tableName,
			Map<String, Object> query) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		list.add(query);
		Map<String, Object> entity = new HashMap<String, Object>();
		entity.put("tableName", tableName);
		entity.put("updateInfoList", list);
		business.update_tables_info(entity);
	}

	/**
	 * 删除
	 */
	public static void delete_table_info(String tableName,
			HttpServletRequest request) {
		Map<String, Object> dateMap = new HashMap<String, Object>();
		List<String> idList = new ArrayList<String>();
		String uuids = RequestUtils.getString(request, "deletekey");
		String[] arrUuids;
		arrUuids = uuids.split("\\,");
		System.out.println(uuids);
		for (String UUID : arrUuids) {
			idList.add(UUID);
		}
		dateMap.put("CODELIST", idList);
		dateMap.put("tableName", tableName);
		business.delete_tables_info(dateMap);
	}

	/**
	 * 将list内的clob类型转为String
	 * 
	 * @param dataList
	 * @return
	 * @throws Exception
	 */
	public static List<Map<String, Object>> ClobToString(
			List<Map<String, Object>> dataList) throws Exception {
		List<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
		Map<String, Object> returnMap = new HashMap<String, Object>();
		for (Map<String, Object> map : dataList) {
			returnMap = new HashMap<String, Object>();
			Set entrySet = map.entrySet(); // 这个Set集合中放的是Map.entry对象
			Iterator it2 = entrySet.iterator();
			while (it2.hasNext()) {// 第二种迭代方式取键值
				Map.Entry entry = (Map.Entry) it2.next();
				String key = entry.getKey().toString();
				Object value = entry.getValue();
				value = oracleClob2Str(value);
				returnMap.put(key, value);
			}
			returnList.add(returnMap);
		}
		return returnList;
	}

	/**
	 * 判断object是否为clob 转换
	 * 
	 * @param object
	 * @return
	 * @throws Exception
	 */
	public static Object oracleClob2Str(Object object) throws Exception {
		boolean res = object instanceof Clob;
		if (res == true) {
			Clob clob = (Clob) object;
			// Java_tool jt = new Java_tool();
			// Clob clob=jt.clob2String((Clob) object);
			return (clob != null ? clob.getSubString(1, (int) clob.length()): null);
		} else {
			return object;
		}
	}
}
