package com.jw.app.business.todo;

import java.util.Date;
import java.util.Map;

import com.gaowj.business.base.impl.BaseBusinessImpl;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.TodoBusiness;

public class TodoBusinessImpl extends BaseBusinessImpl implements TodoBusiness {

	public void setTodoDAO(TodoDAO todoDAO) {
		this.dao = todoDAO;
	}

	@Override
	public void makeQuery(Map<String, Object> query) throws BusinessException {
		//主题
		if (query.get("TITLE") != null && !"".equals(query.get("TITLE"))) {
			query.put("TITLE", "%" + query.get("TITLE") + "%");
		}
		//代办状态
		if (!"0".equals(query.get("DO_STATE"))&&!"1".equals(query.get("DO_STATE"))) {
			query.remove("DO_STATE");
		} 
		//角色条件
		if ("2".equals(query.get("ROLE"))) {
			// 接收者是当前登录人
			query.put("RECIPIENT", SessionUtil.getCode());
		} else if ("1".equals(query.get("ROLE"))) {
			// 发起者是当前登录人
			query.put("SENDER", SessionUtil.getCode());
		} else {
			// 发送人或者接收人是当前登录人
			query.put("SENDER_OR_RECIPIENT", SessionUtil.getCode());
		}

	}

	@Override
	public void makeInsertEntity(Map<String, Object> entity) throws BusinessException {
		// 发送人是当前登录人
		entity.put("SENDER", SessionUtil.getCode());
		// 设置发起时间
		entity.put("LAUNCH_TIME", new Date());
		// 设置未读
		entity.put("READ_STATE", 0);
		// 设置未办
		entity.put("DO_STATE", 0);
	}

	@Override
	public void makeUpdateEntity(Map<String, Object> entity) throws BusinessException {
		//因为是从datagrid的数据来的，可能存在物理表中没有的字段，需要删除
		entity.remove("SEND_REAL_NAME");
		entity.remove("RECIPIENT_REAL_NAME");
		entity.remove("OPETYPE");
	}

}
