package com.jw.app.business.utils;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import oracle.sql.CLOB;
import oracle.sql.DATE;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class QueryParamUtil {
	/**
	 * 将用,分隔开的字符串转换成数组

	 * 
	 * @param query
	 * @param key
	 */
	public static void splitQueryParam(Map<String, Object> query, String key) {
		Object value = query.get(key);
		if (value == null) {
			return;
		} else if (value instanceof String) {
			query.put(key, StringUtils.split((String) value, ","));
		}
	}
	/**
	 * 将,分隔的字符转成list<String>模式
	 * @param key
	 * @return
	 */
	public static List<String> StringToList(String key){
		List<String> list = new ArrayList<String>();
		if(StringUtils.isNotEmpty(key)){
		   String s[] = StringUtils.split((String) key, ",");
		   for(String st:s){
			   list.add(st);
		   }
		}
 		return list;
	}
	
	/**
	 * 将Map中CLOB转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	@SuppressWarnings("rawtypes")
	public static Map<String,Object> ClobToString(Map<String,Object> map) throws IOException, SQLException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s) instanceof oracle.sql.CLOB){
			   oracle.sql.CLOB cb = (CLOB) map.get(s);
			   map.put(s,IOUtils.toString(cb.characterStreamValue()));
		   } 
		}
		return map;
	}
	/**
	 * 将list<Map>中CLOB转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static List<Map<String,Object>> ClobToString(List<Map<String,Object>> list) throws IOException, SQLException{
		for(Map<String,Object> map:list){
			map = ClobToString(map);
		}
		return list;
	}
	
	/**
	 * 将Map中Date转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	@SuppressWarnings("rawtypes")
	public static Map<String,Object> DateToString(Map<String,Object> map) throws SQLException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s) instanceof java.sql.Timestamp){
			   java.sql.Timestamp dt =  (Timestamp) map.get(s);
			   map.put(s,DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd"));
		   }else if(map.get(s) instanceof java.util.Date){
			   java.util.Date dt =  (java.util.Date) map.get(s);
			   map.put(s,DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd"));
		   }
		}
		return map;
	}
	
	@SuppressWarnings("rawtypes")
	public static Map<String,Object> DateToString_DATE(Map<String,Object> map) throws SQLException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s) instanceof java.sql.Timestamp){
			   java.sql.Timestamp dt =  (Timestamp) map.get(s);
			   map.put(s,"DATE_" + DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd"));
		   }else if(map.get(s) instanceof java.util.Date){
			   java.util.Date dt =  (java.util.Date) map.get(s);
			   map.put(s,"DATE_" + DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd"));
		   }
		}
		return map;
	}
	/**
	 * 将list<Map>中Date转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static List<Map<String,Object>> DateToString(List<Map<String,Object>> list) throws SQLException{
		for(Map<String,Object> map:list){
			map = DateToString(map);
		}
		return list;
	}
	
	public static List<Map<String,Object>> DateToString_DATE(List<Map<String,Object>> list) throws SQLException{
		for(Map<String,Object> map:list){
			map = DateToString_DATE(map);
		}
		return list;
	}
	
	
	public static Map<String,Object> StringToDate(Map<String,Object> map) throws SQLException, ParseException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s)!=null && map.get(s) instanceof String && map.get(s).toString().length()>0){
		     if(StringUtils.contains(map.get(s).toString(),"DATE_")){
			   if(map.get(s).toString().split("_").length>=2 && map.get(s).toString().split("_")[1].length()>0){  
				 String tempDate = map.get(s).toString().split("_")[1];
				 if(!(tempDate.contains("-") || tempDate.contains("/"))){
					 tempDate = DateFormatUtils.format(new Date(Long.parseLong(tempDate)), "yyyy-MM-dd");
				 }	 
			     map.put(s,DateUtils.parseDate(tempDate, "yyyy-MM-dd"));
			   }
		     } 
		   }
		}
		return map;
	}
	
	public static List<Map<String,Object>> StringToDate(List<Map<String,Object>> list) throws SQLException, ParseException{
		for(Map<String,Object> map:list){
			map = StringToDate(map);
		}
		return list;
	}
	
	/**
	 * 将Map中Date转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	@SuppressWarnings("rawtypes")
	public static Map<String,Object> DateTimeToString(Map<String,Object> map) throws SQLException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s) instanceof java.sql.Timestamp){
			   java.sql.Timestamp dt =  (Timestamp) map.get(s);
			   map.put(s,DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd HH:mm:ss"));
		   }else if(map.get(s) instanceof java.util.Date){
			   java.util.Date dt =  (java.util.Date) map.get(s);
			   map.put(s,DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd HH:mm:ss"));
		   }
		}
		return map;
	}
	
	@SuppressWarnings("rawtypes")
	public static Map<String,Object> DateTimeToString_DATE(Map<String,Object> map) throws SQLException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s) instanceof java.sql.Timestamp){
			   java.sql.Timestamp dt =  (Timestamp) map.get(s);
			   map.put(s,"DATE_" + DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd HH:mm:ss"));
		   }else if(map.get(s) instanceof java.util.Date){
			   java.util.Date dt =  (java.util.Date) map.get(s);
			   map.put(s,"DATE_" + DateFormatUtils.format(dt.getTime(), "yyyy-MM-dd HH:mm:ss"));
		   }
		}
		return map;
	}
	/**
	 * 将list<Map>中Date转成String
	 * @param map
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static List<Map<String,Object>> DateTimeToString(List<Map<String,Object>> list) throws SQLException{
		for(Map<String,Object> map:list){
			map = DateTimeToString(map);
		}
		return list;
	}
	
	public static List<Map<String,Object>> DateTimeToString_DATE(List<Map<String,Object>> list) throws SQLException{
		for(Map<String,Object> map:list){
			map = DateTimeToString_DATE(map);
		}
		return list;
	}
	
	
	public static Map<String,Object> StringToDateTime(Map<String,Object> map) throws SQLException, ParseException{
		Set<String> key = map.keySet();
		for (Iterator it = key.iterator(); it.hasNext();) {
		   String s = (String) it.next();
		   if(map.get(s)!=null && map.get(s).toString().length()>0){
		     if(StringUtils.contains(map.get(s).toString(),"DATE_")){
			   if(map.get(s).toString().split("_").length>=2 && map.get(s).toString().split("_")[1].length()>0){
				  String tempDate = map.get(s).toString().split("_")[1];
				  if(!(tempDate.contains("-") || tempDate.contains("/"))){
				     tempDate = DateFormatUtils.format(new Date(Long.parseLong(tempDate)), "yyyy-MM-dd HH:mm:ss");
				  }
			      map.put(s,DateUtils.parseDate(tempDate, "yyyy-MM-dd HH:mm:ss"));
			   }
		     } 
		   }
		}
		return map;
	}
	
	public static List<Map<String,Object>> StringToDateTime(List<Map<String,Object>> list) throws SQLException, ParseException{
		for(Map<String,Object> map:list){
			map = StringToDateTime(map);
		}
		return list;
	}
	
}
