package com.jw.app.business.vote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.jw.app.business.VoteBusiness;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;

public class VoteBusinessImpl implements VoteBusiness {

	private voteDAO voteDAO;

	public voteDAO getvoteDAO() {
		return voteDAO;
	}

	public void setvoteDAO(voteDAO voteDAO) {
		this.voteDAO = voteDAO;
	}

	@Override
	public void insert_vote(Map<String, Object> entity) throws BusinessException {
		String items = entity.get("ITEMS").toString();
		entity.remove("ITEMS");

		entity.put("UUID", java.util.UUID.randomUUID().toString());
		entity.put("START_TIME", new Date());
		entity.put("CREATE_ID", SessionUtil.getCode());
		entity.put("CREATE_TIME", new Date());
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("UPDATE_TIME", new Date());
		entity.put("STATUS_FLAG", 1);

		// 动态传值插入
		List<String> infoListKey = new ArrayList<String>();
		List<Object> infoList = new ArrayList<Object>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				infoList.add(entity.get(str));
				infoListKey.add(str);
			}
			entity.put("infoListKey", infoListKey);
			entity.put("infoList", infoList);
			// 插入
			voteDAO.insert_vote(entity);
		}
		// 插入明细表
		JSONArray itemArray = JSONArray.fromObject(items);
		for (int i = 0; i < itemArray.size(); i++) {
			Map<String, Object> itemmap = new HashMap<String, Object>();
			JSONObject item = itemArray.getJSONObject(i);
			item.put("UUID", java.util.UUID.randomUUID().toString());
			item.put("CREATE_ID", SessionUtil.getCode());
			item.put("CREATE_TIME", SessionUtil.getCurrenttime());
			item.put("UPDATE_ID", SessionUtil.getCode());
			item.put("MANAGE_ID", entity.get("UUID"));
			item.put("UPDATE_TIME", SessionUtil.getCurrenttime());
			item.put("SORT_NUM", i);
			List<String> itemListKey = new ArrayList<String>();
			List<Object> itemList = new ArrayList<Object>();
			Set<String> key = item.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				itemList.add(item.get(str));
				itemListKey.add(str);
			}
			itemmap.put("itemListKey", itemListKey);
			itemmap.put("itemList", itemList);
			// 插入
			voteDAO.insert_item(itemmap);
		}

	}

	@Override
	public void insert_userVote(Map<String, Object> entity) throws BusinessException {
		String flag = (String) entity.get("STATUS_FLAG");
		if (flag.equals("1")) {
			String s = (String) entity.get("UUIDS");
			List<String> uuidsList = Arrays.asList(s.split(","));
			for (int i = 0; i < uuidsList.size(); i++) {
				String item = uuidsList.get(i);
				Map<String, Object> itemmap = new HashMap<String, Object>();
				itemmap.put("UUID", java.util.UUID.randomUUID().toString());
				itemmap.put("MANAGE_ID", entity.get("UUID"));
				itemmap.put("ITEM_ID", item);
				itemmap.put("USER_ID", SessionUtil.getCode());
				itemmap.put("VOTE_TIME", SessionUtil.getCurrenttime());
				itemmap.put("CREATE_ID", SessionUtil.getCode());
				itemmap.put("CREATE_TIME", SessionUtil.getCurrenttime());
				itemmap.put("UPDATE_ID", SessionUtil.getCode());
				itemmap.put("UPDATE_TIME", SessionUtil.getCurrenttime());
				// 动态传值插入
				List<String> infoListKey = new ArrayList<String>();
				List<Object> infoList = new ArrayList<Object>();
				if (itemmap.keySet() != null) {
					Set<String> key = itemmap.keySet();
					// 将map集合中的key和value 取出来分别放到list集合里
					for (String str : key) {
						infoList.add(itemmap.get(str));
						infoListKey.add(str);
					}
					itemmap.put("infoListKey", infoListKey);
					itemmap.put("infoList", infoList);
				}
				voteDAO.insert_userVote(itemmap);
			}
		}
	}

	@Override
	public void update_vote(Map<String, Object> entity) throws BusinessException {
		// 动态传值修改
		String items = entity.get("ITEMS").toString();
		entity.remove("ITEMS");
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				Map<String, Object> updateMap = new HashMap<String, Object>();
				if (StringUtils.equalsIgnoreCase("UUID", str))
					continue;
				updateMap.put("key", str);
				updateMap.put("value", entity.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
			//
			voteDAO.update_vote(entity);
		}

		// 修改明细表
		List<Map<String, Object>> updateItemList = new ArrayList<Map<String, Object>>();
		// 用户新存储的明细
		JSONArray itemArray = JSONArray.fromObject(items);
		// 投票表原明细
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("MANAGE_ID", entity.get("UUID"));
		List<Map<String, Object>> listOldItem = voteDAO.list_item(query);

		//
		// List<>
		// 筛选新增的明细
		for (int i = 0; i < itemArray.size(); i++) {
			JSONObject item = itemArray.getJSONObject(i);
			item.put("SORT_NUM", i);
			if (item.get("UUID") != null && !"".equals(item.get("UUID"))) {
				// 表示旧数据
				// update item(UUID)
				Set<String> key1 = item.keySet();
				for (String str : key1) {
					Map<String, Object> updateItemMap = new HashMap<String, Object>();
					updateItemMap.put("key", str);
					updateItemMap.put("value", item.get(str));

					updateItemList.add(updateItemMap);
				}
				item.put("info", updateItemList);

				voteDAO.update_item(item);
			} else {
				// 表示新数据
				// insert item
				Map<String, Object> itemmap = new HashMap<String, Object>();
				item.put("UUID", java.util.UUID.randomUUID().toString());
				item.put("MANAGE_ID", entity.get("UUID"));
				item.put("CREATE_ID", SessionUtil.getCode());
				item.put("CREATE_TIME", SessionUtil.getCurrenttime());
				item.put("UPDATE_ID", SessionUtil.getCode());
				item.put("UPDATE_TIME", SessionUtil.getCurrenttime());
				List<String> itemListKey = new ArrayList<String>();
				List<Object> itemList = new ArrayList<Object>();
				Set<String> key = item.keySet();
				// 将map集合中的key和value 取出来分别放到list集合里
				for (String str : key) {
					itemList.add(item.get(str));
					itemListKey.add(str);
				}
				itemmap.put("itemListKey", itemListKey);
				itemmap.put("itemList", itemList);
				// 插入
				voteDAO.insert_item(itemmap);
			}
		}

		List<String> listMoveUuid = new ArrayList<String>();
		outer: for (Map<String, Object> oldItem : listOldItem) {
			for (int i = 0; i < itemArray.size(); i++) {
				JSONObject item = itemArray.getJSONObject(i);
				if (oldItem.get("UUID").equals(item.get("UUID"))) {
					// 表示该明细不需要删除
					continue outer;
				}
			}
			// 如果没有在新明细中查询到，则表示该明细需要删除
			listMoveUuid.add((String) oldItem.get("UUID"));
		}

		if (listMoveUuid.size() > 0) {
			voteDAO.delete_item(listMoveUuid);
			voteDAO.delete_vote_action(listMoveUuid);
		}
	}

	@Override
	public void delete_vote(List<String> list) throws BusinessException {
		voteDAO.delete_vote(list);
		voteDAO.delete_vote_item(list);
		voteDAO.delete_vote_action(list);

	}

	@Override
	public void delete_item(List<String> list) throws BusinessException {
		voteDAO.delete_item(list);

	}

	@Override
	public Page<Map<String, Object>> list_vote(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		query.put("CREATE_ID", SessionUtil.getCode());
		return list_vote_info(pageNo, pageSize, query);
	}

	@Override
	public Page<Map<String, Object>> list_ongoing(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		// 计算起始记录
		query.put("STATUS_FLAG", 1);
		return list_vote_info(pageNo, pageSize, query);
	}

	@Override
	public Page<Map<String, Object>> list_ended(int pageNo, int pageSize, Map<String, Object> query)
			throws BusinessException {
		query.put("STATUS_FLAG", 2);
		return list_vote_info(pageNo, pageSize, query);
	}

	private Page<Map<String, Object>> list_vote_info(int pageNo, int pageSize, Map<String, Object> query) {
		// 计算起始记录
		int pageStart = (pageNo - 1) * pageSize;

		// 获取列表
		List<Map<String, Object>> items = voteDAO.list_vote(new RowBounds(pageStart, pageSize), query);
		// 获取列表个数
		int count = voteDAO.listCount_vote(query);

		// 创建分页对象
		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
		page.setStart(pageStart);
		page.setLimit(pageSize);
		page.setCount(count);
		page.setItems(items);

		return page;
	}

	@Override
	public List<Map<String, Object>> list_vote(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = null;
		if (list_data == null || list_data.size() == 0) {
			list_data = voteDAO.list_vote(query);
		}
		return list_data;
	}

	@Override
	public List<Map<String, Object>> list_ongoing(Map<String, Object> query) throws BusinessException {

		return voteDAO.list_vote(query);
	}

	@Override
	public List<Map<String, Object>> list_ended(Map<String, Object> query) throws BusinessException {

		return voteDAO.list_vote(query);
	}

	@Override
	public List<Map<String, Object>> list_item(Map<String, Object> query) throws BusinessException {
		return voteDAO.list_item(query);
	}

	@Override
	public List<Map<String, Object>> list_userChecked(Map<String, Object> query) throws BusinessException {
		return voteDAO.list_userChecked(query);
	}

	@Override
	public void update_endVote(Map<String, Object> entity) throws BusinessException {
		// 动态传值修改
		entity.put("REALLY_END_TIME", new Date());
		entity.put("UPDATE_TIME", new Date());
		entity.put("UPDATE_ID", SessionUtil.getCode());
		entity.put("STATUS_FLAG", 2);
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if (entity.keySet() != null) {
			Set<String> key = entity.keySet();
			// 将map集合中的key和value 取出来分别放到list集合里
			for (String str : key) {
				Map<String, Object> updateMap = new HashMap<String, Object>();
				if (StringUtils.equalsIgnoreCase("UUID", str))
					continue;
				updateMap.put("key", str);
				updateMap.put("value", entity.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
			//
			voteDAO.update_vote(entity);
		}

	}

}
