package com.jw.app.calendar.action;

import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.CalendarBusiness;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 124457626402410251L;

	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 保存日历信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveCalendarInfo() throws BusinessException {
		Map<String, Object> info = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		CalendarBusiness business = BusinessManager.getBusiness(CalendarBusiness.class);
		try {
			info = QueryParamUtil.StringToDate(info);
			info.remove("OPETYPE");
			business.save_calendar(info);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
		}

		return "json";
	}

	/**
	 * 删除日历信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String removeCalendarInfo() throws BusinessException {
		CalendarBusiness business = BusinessManager.getBusiness(CalendarBusiness.class);
		try {
			business.delete_calendar(RequestUtils.getString(request, "UUID"));
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
		}

		return "json";
	}
	
	/**
	 * 保存公司日历信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveCalendarCompanyInfo() throws BusinessException {
		Map<String, Object> info = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		CalendarBusiness business = BusinessManager.getBusiness(CalendarBusiness.class);
		try {
			info = QueryParamUtil.StringToDate(info);
			info.remove("OPETYPE");
			business.save_calendar_by_company(info);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
		}

		return "json";
	}

	/**
	 * 删除公司日历信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String removeCalendarCompanyInfo() throws BusinessException {
		CalendarBusiness business = BusinessManager.getBusiness(CalendarBusiness.class);
		try {
			business.delete_calendar_company(RequestUtils.getString(request, "UUID"));
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
		}

		return "json";
	}

}
