package com.jw.app.friendlink.action;

import java.util.HashMap;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.CalendarBusiness;
import com.jw.app.business.FriendLinkBusiness;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {


	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 保存友情链接信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveFriendLinkInfo() throws BusinessException {
		Map<String, Object> info = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		FriendLinkBusiness business = BusinessManager.getBusiness(FriendLinkBusiness.class);
		try {
			info = QueryParamUtil.StringToDate(info);
			info.remove("OPETYPE");
			info=business.save_friendlink(info);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			if("-1".equals(info.get("ERROR"))){
				Map<String, Object> map=new HashMap<String, Object>();
				map.put("VALUE", "保存失败，快速链接不得超过8条！");
				jsonObject.putAll(map);
			}else{
				jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			}
		}

		return "json";
	}

	/**
	 * 删除友情链接信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String removeFriendLinkInfo() throws BusinessException {
		FriendLinkBusiness business = BusinessManager.getBusiness(FriendLinkBusiness.class);
		try {
			business.delete_friendlink(RequestUtils.getString(request, "UUID"));
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
		}

		return "json";
	}
}
