package com.jw.app.friendlink.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.CalendarBusiness;
import com.jw.app.business.FriendLinkBusiness;

import net.sf.json.JSONObject;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3043201121825378378L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	/**
	 * 获取友情链接列表
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String listFriendLinkInfo() throws BusinessException {
		FriendLinkBusiness business = BusinessManager.getBusiness(FriendLinkBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageData = business.list_friendlink(pageNo,pageSize,query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(pageData.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageData.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
