package com.jw.app.log.action;

import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.jw.app.business.LogBusiness;
import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.standard.utils.CacheKit;

public class actAction extends BasicAction {
	private static final long serialVersionUID = -4469183762817854794L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertLog() throws BusinessException {

		LogBusiness business = BusinessManager.getBusiness(LogBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 新增
			business.insert_log(entity);

			// 操作日志
			// sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("insertLog", "" + entity, "增加测试数据", (String) entity.get("UUID"),
					(String) entity.get("CREATE_NAME"), "logdemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertReply() throws BusinessException {

		LogBusiness business = BusinessManager.getBusiness(LogBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 新增
			business.insert_reply(entity);

			// 操作日志
			// sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("insertReply", "" + entity, "增加测试数据", (String) entity.get("UUID"),
					(String) entity.get("CREATE_NAME"), "logdemo1");
			Map<String, Object> result = Status.getStatusSuccessMessage("保存成功");
			result.put("UUID", entity.get("UUID"));
			result.put("REPLY_NAME", entity.get("REPLY_NAME"));
			result.put("CODE", entity.get("CODE"));
			result.put("REPLY_CONTENT", entity.get("REPLY_CONTENT"));
			jsonObject.putAll(result);
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateLog() throws BusinessException {

		LogBusiness business = BusinessManager.getBusiness(LogBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_log(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateLog", "" + entity, "修改测试数据", (String) entity.get("UUID"),
					(String) entity.get("CREATE_NAME"), "logdemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 在软删除基础上删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteLog() throws BusinessException {

		LogBusiness business = BusinessManager.getBusiness(LogBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);

		try {
			business.delete_log(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteLog", "" + ListKey, "删除测试数据", deletekey, "多个流水号", "logdemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 在软删除基础上删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteReply() throws BusinessException {

		LogBusiness business = BusinessManager.getBusiness(LogBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);

		try {
			business.delete_reply(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteLog", "" + ListKey, "删除测试数据", deletekey, "多个流水号", "logdemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}

}
