package com.jw.app.meeting.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.jw.app.business.MeetingBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.business.util.TestMd5;
import com.gaowj.standard.utils.CacheKit;

public class dataAction extends BasicAction {

	private static final long serialVersionUID = -3006159112969667743L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		return rows;
	}

	public void setRows(int rows) {
		this.rows = rows;
	}

	public int getPage() {
		return page;
	}

	public void setPage(int page) {
		this.page = page;
	}

	/**
	 * 分页获取记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String list() throws BusinessException {
		MeetingBusiness business = BusinessManager.getBusiness(MeetingBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_meeting(pageNo, pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(pageRows.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listCheck_in() throws BusinessException {
		MeetingBusiness business = BusinessManager.getBusiness(MeetingBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			List<Map<String, Object>> listchecks = business.list_check_in(query);
			// listchecks = QueryParamUtil.StringToDate(listchecks);
			jsonObject = new JSONObject();
			jsonObject.put("listchecks", QueryParamUtil.DateTimeToString(listchecks));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 获取所有记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String listAll() throws BusinessException {
		MeetingBusiness business = BusinessManager.getBusiness(MeetingBusiness.class);
		try {
			// 表示获取前台表单提交的所有"FIELD_"开始的键值数据，例如FIELD_NAME,FIELD_CODE....
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);

			// 把前端传进来的字符型时间数据例 如DATE_2018-09-09转换成DATE型的时间数据。
			// 主要和前端is_entity.FIELD_CREATE_TIME =
			// strToDateObj(is_entity.FIELD_CREATE_TIME)配对使用。
			// 前端提交前strToDateObj方法会把时间处理成DATE_2018-09-09再提交
			query = QueryParamUtil.StringToDate(query);

			// session工具
			String code = SessionUtil.getCode();// 当前用户ID
			String emid = SessionUtil.getEmid();// 当前用户帐号
			String emname = SessionUtil.getEmname();// 当前用户名称
			String emdepart = SessionUtil.getEmdepart();// 当前用户部门id
			String emdepartname = SessionUtil.getEmdepartname();// 当前用户部门名称
			String emsex = SessionUtil.getEmsex();// 当前用户性别
			String loginip = SessionUtil.getLoginip();// 当前用户登录IP

			String clientip = SessionUtil.getClientIp();// 获取客户端IP
			String quanxian = SessionUtil.getQuanxian();// 获取当前用户使用模块清单
			String sessionid = SessionUtil.getSessionid();// 获取当前用户sessionID
			String currenttimme = SessionUtil.getCurrenttime();// 当前用户本次登录时间
			String beforetime = SessionUtil.getBeforetime();// 当前用户上次登录时间

			// 配置文件工具
			// 表示获取src目录下quartz_service.properties文件中主键是login_main_url的值
			String tt = PropUtil.getValue("login_main_url", "quartz_service", "");

			List<Map<String, Object>> listData = business.list_meeting(query);
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
