package com.jw.app.notice.action;

import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.NoticeBusiness;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {



	/**
	 * 
	 */
	private static final long serialVersionUID = -1447740171556559942L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 保存通知公告信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveNoticeInfo() throws BusinessException {
		Map<String, Object> info = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		NoticeBusiness business = BusinessManager.getBusiness(NoticeBusiness.class);
		try {
			info = QueryParamUtil.StringToDate(info);
			info.remove("OPETYPE");
			business.save_notice(info);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
		}

		return "json";
	}

	/**
	 * 删除通知公告信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String removeNoticeInfo() throws BusinessException {
		NoticeBusiness business = BusinessManager.getBusiness(NoticeBusiness.class);
		try {
			business.delete_notice(RequestUtils.getString(request, "UUID"));
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
		}

		return "json";
	}
	

}
