package com.jw.app.portal.apps.action;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortalAppsBusiness;
import com.jw.app.business.PortalAppsRoleBusiness;
import com.gaowj.business.SystemOpeBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6517074422672442333L;
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
    public String insertAppAccount() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			if(entity.get("PWD") != null){
				entity.put("PWD", Encipher.EncodePasswd((String)entity.get("PWD")));
			}
			String returnid = "";
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("APP_ID", entity.get("APP_ID"));
			query.put("USERID", entity.get("USERID"));
			List<Map<String, Object>> listData = business.list_app_account(query);
			if(listData.size()<1){
				returnid = business.insert_app_account(entity);
			}
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK_RETURNID,returnid));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateAppAccount() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			if(entity.get("PWD") != null){
				entity.put("PWD", Encipher.EncodePasswd((String)entity.get("PWD")));
			}
		    business.update_app_account(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteAppAccount() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_app_account(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String insertApp() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    String returnid = business.insert_app(entity);
		    //操作日志
		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		    sysbusiness.insert_logBusiness("insertApp", ""+entity,"增加集成应用记录",returnid,(String)entity.get("NAME"),"JW_APPS_APPS_APP");
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK_RETURNID,returnid));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateApp() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
//		System.out.println("------update"+entity);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_app(entity);
		    //操作日志
		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		    sysbusiness.insert_logBusiness("updateApp", ""+entity,"修改集成应用记录",(String)entity.get("APP_ID"),(String)entity.get("NAME"),"JW_APPS_APPS_APP");
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteApp() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			Map<String,Object>query=new HashMap<String, Object>();
			deletekey="";
			for (String string : ListKey) {
				deletekey+="\'"+string+"\',";
			}
			deletekey = deletekey.substring(0,deletekey.length() - 1);
			query.put("list", deletekey);
			List<Map<String,Object>>list=business.list_app(query);
			query=new HashMap<String, Object>();
			//名称
			String Name="";
			for (Map<String, Object> map : list) {
				Name+=map.get("NAME")+",";
			}
			query.put("NAME", Name);
		    business.delete_app(ListKey);
		    business.delete_install_app_id(ListKey);
		    business.delete_uninstall_app_id(ListKey);
		    //操作日志
		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		    sysbusiness.insert_logBusiness("deleteApp", ""+ListKey.toString(),"删除集成应用记录",ListKey.toString(),query.toString(),"JW_APPS_APPS_APP");
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
    public String insertCategory() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_category(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateCategory() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_category(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
    public String deleteCategory() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_category(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertDefaultInstall() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		SystemOpeBusiness business_sys = BusinessManager.getBusiness(SystemOpeBusiness.class);
		PortalAppsRoleBusiness business_app_role = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		try{
			entity = QueryParamUtil.StringToDate(entity);
			List<Map<String,Object>> alluser=new ArrayList<Map<String,Object>>();
			if(entity.get("G_ID")!=null&&!entity.get("G_ID").toString().equals("all"))
			{
			  String gids[] = ((String)entity.get("G_ID")).split(",");
			  Map<String, Object> map=new HashMap<String, Object>();
				map.put("ROLE_IDS", gids);
				List<Map<String, Object>> listUserByRoleId=business_app_role.list_all_user_by_roleId(map);
				for(Map<String, Object> user:listUserByRoleId){
					user.put("CODE", user.get("USER_ID"));
				}
				alluser.addAll(listUserByRoleId);
			}
			else {
				alluser= business_sys.listLoginUserInfo(null);
			}
		    //删除原有此APP的所有用户

		    String app_id = (String) entity.get("APP_ID");
		    List<String> delApp = new ArrayList<String>();
		    delApp.add(app_id);
		    business.delete_install_app_id(delApp);
		    business.delete_uninstall_app_id(delApp);
		    //重新为所有用户安装此app
		    String is_default = (String) entity.get("IS_DEFAULT");
		    for(Map<String,Object> user:alluser){
		    	Map<String,Object> entityNew = new HashMap<String,Object>();
		    	entityNew.put("APP_ID", entity.get("APP_ID"));
		    	entityNew.put("USERID", user.get("CODE"));
		    	if(StringUtils.isNotEmpty(is_default) && StringUtils.equals(is_default, "1")){
		    	    business.insert_install(entityNew);
		    	}else{
		    		//business.insert_uninstall(entityNew);
		    	}
		    }
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertDefaultInstallNewUser() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    List<Map<String,Object>> alluser = business.list_userallapp_newuser(null);
		    for(Map<String,Object> user:alluser){
		    	Map<String,Object> entityNew = new HashMap<String,Object>();
		    	entityNew.put("APP_ID", entity.get("APP_ID"));
		    	entityNew.put("USERID", user.get("CODE"));
		    	business.insert_install(entityNew);
		    }
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
  
    public String insertInstall() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_install(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateInstall() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_install(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
 
    public String deleteInstall() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_install(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteInstall_app_id() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_install_app_id(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteInstall_app_user() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_install_app_user(entity);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertUninstall() throws BusinessException{
		
		PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_uninstall(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateUninstall() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_uninstall(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
 
    public String deleteUninstall() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_uninstall(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteUninstall_app_id() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_uninstall_app_id(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteUninstall_app_user() throws BusinessException{
		
	    PortalAppsBusiness business = BusinessManager.getBusiness(PortalAppsBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_uninstall_app_user(entity);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
	public String uploadApp() throws BusinessException{
	   String upPath = PropUtil.getValue("uploadPath", "quartz_service","")+File.separator+"apps";
	   //String upPath = request.getSession().getServletContext().getRealPath("/uploadFile/apps/apps");
	   super.setUserUploadFilePath(upPath);
	   return super.upload();
   }
	
	

}
