package com.jw.app.portal.content.action;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import oracle.sql.BLOB;

import org.apache.commons.io.IOUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortalContentBusiness;
import com.jw.app.business.table.utils.Common;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 303797180576461148L;
	
	private JSONObject jsonObject = new JSONObject();
	
	private File leftFile;
	
	private File appFile;	
	
	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertContent() throws BusinessException{
		PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		System.out.println("----------insert"+entity);
		jsonObject = new JSONObject();
		try{
			entity = QueryParamUtil.StringToDate(entity);
			
			business.insert_content(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	public String insertFile(){
		//附件信息
		Map<String,Object> fileentity = RequestUtils.getUpdateFieldMap(request, "FILED_");
		jsonObject = new JSONObject();
		try{
			fileentity = QueryParamUtil.StringToDate(fileentity);
			//内容主键
			String uuid=java.util.UUID.randomUUID().toString();
			if(fileentity.get("UUID")==null){
				fileentity.put("UUID", java.util.UUID.randomUUID().toString());
			}
			if(fileentity.get("MAIN_DOC_ID")==null||fileentity.get("MAIN_DOC_ID").toString().equals("")){
				fileentity.put("MAIN_DOC_ID", uuid);
			}
			Common.insert_table_info("APPS_FILE", fileentity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK_RETURNID,fileentity.get("MAIN_DOC_ID").toString()));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    public String updateContent() throws BusinessException{
    	PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		System.out.println("----------update"+entity);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			business.update_content(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String deleteContent() throws BusinessException{
	   PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		try{
			String deletekey  = RequestUtils.getString(request, "deletekey");
			List<String> ListKey = QueryParamUtil.StringToList(deletekey);
			Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
			business.delete_content(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
	public String uploadContent() throws BusinessException{
	   String upPath = request.getSession().getServletContext().getRealPath("/uploadFile/apps/content");
	   super.setUserUploadFilePath(upPath);
	   return super.upload();
   }
	public String downLoad(){
		String ret_download ="";
    	String uploadnew=request.getParameter("uploadnew");
		String uploadpath=request.getParameter("uploadpath");
		String uploadold=request.getParameter("uploadold");
		try {
			String upPath = request.getSession().getServletContext().getRealPath("/uploadFile/apps/content");
			BufferedInputStream bis = new BufferedInputStream(new FileInputStream(upPath+"//"+uploadold));
			File dir = new File(uploadpath);
			if (!dir.exists()) {
			    dir.mkdirs();
			}
			File tempfile = new File(uploadpath+"/"+uploadnew);
			FileOutputStream fio =new FileOutputStream(tempfile);
			IOUtils.copy(bis, fio);
			IOUtils.closeQuietly(bis);
			IOUtils.closeQuietly(fio);
			ret_download = super.download();
			tempfile.delete();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return ret_download;
	}
}
