package com.jw.app.portal.content.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.EasyuiJsonUtils;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortalContentBusiness;
import com.jw.app.business.table.utils.Common;
import com.jw.app.business.utils.QueryParamUtil;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7897314852467856687L;

	
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页


	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String list() throws BusinessException{
		PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
//		System.out.println("----------------query"+query);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.list_content(pageNo, pageSize, query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listfile() throws BusinessException{

		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, "FILED_");
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = Common.list_table_info("APPS_FILE", query);
		for (Map<String, Object> map : listData) {
			 String file = "";
			    if(map.get("FILE_PATH")!=null && map.get("FILE_PATH").toString().length()>0){
			    	file = (String) map.get("FILE_PATH");
			    }else{
			    	file = request.getSession().getServletContext().getRealPath("uploadFile/down/defaultFile.txt");
			    }
			 int tt = file.lastIndexOf("/");
			    if(tt == -1) file.lastIndexOf("\\");
			    String aa = file.substring(0, tt);
			    String bb = file.substring(tt + 1);
			    String url = "/jwAppsContentAct_download?myMethod=download&uploadnew="
				    + bb
				    + "&uploadpath="
				    + aa
				    + "&uploadold="
				    + map.get("FILE_NAME").toString();
			    map.put("URL", url);
		}
		int listDataCount = Common.list_table_info_Count("APPS_FILE", query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	public String listAll() throws BusinessException{
		PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.list_content(query);
		int listDataCount = business.listCount_content(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listContentTree() throws BusinessException{
		PortalContentBusiness business = BusinessManager.getBusiness(PortalContentBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.list_content(query);
		int listDataCount = business.listCount_content(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", EasyuiJsonUtils.getTreeJsonData(QueryParamUtil.DateToString(listData)));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	

}
