package com.jw.app.portal.role.action;

import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortalAppsRoleBusiness;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 124457626402410251L;

	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 保存角色信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveRoleInfo() throws BusinessException {
		Map<String, Object> info = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		try {
			info = QueryParamUtil.StringToDate(info);
			info.remove("OPETYPE");
			business.save_apps_role(info);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
		}

		return "json";
	}

	/**
	 * 删除角色信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String removeRoleInfo() throws BusinessException {
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		try {
			business.delete_apps_role(RequestUtils.getString(request, "UUID"));
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
		}

		return "json";
	}
	
	/**
	 * 删除角色信息
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String saveUserByRoleId() throws BusinessException {
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		try {
			business.saveUserByRoleId(RequestUtils.getString(request, "FIELD_ROLE_ID"),RequestUtils.getString(request, "FIELD_SELECT_USER"));
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
		}

		return "json";
	}
}
