package com.jw.app.portal.role.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortalAppsRoleBusiness;

import net.sf.json.JSONObject;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1838735286131979745L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	/**
	 * 获取角色列表
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String listRoleInfo() throws BusinessException {
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageData = business.list_apps_role(pageNo, pageSize, query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(pageData.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageData.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 获取全部角色列表
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String listAllRoleInfo() throws BusinessException {
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> list = business.list_all_apps_role(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(list));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", list.size());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 获取用户树结构
	 * 
	 * @return
	 * @throws BusinessException
	 */
	public String listAllUser() throws BusinessException {
		PortalAppsRoleBusiness business = BusinessManager.getBusiness(PortalAppsRoleBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);

		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> list = business.list_all_user(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateTimeToString(list));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", list.size());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
