package com.jw.app.portlet.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortletBusiness;
import com.jw.app.business.utils.QueryParamUtil;

import net.sf.json.JSONObject;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7897314852467856687L;

	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	/**
	 * 获取所有的门户栏目
	 * @return
	 * @throws BusinessException
	 */
	public String listAllPortletColumns() throws BusinessException {
		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business
					.list_portlet_columns(query);
			
			Map<String, Object> data = new HashMap<String, Object>();
			QueryParamUtil.DateToString(listData);
			data.put("rowSet", listData);
			data.put("pageNo", 1);
			data.put("pageSize", listData.size());
			data.put("pageCount", listData.size());
			data.put("rows", data.get("rowSet"));
			data.put("total", listData.size());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 获取用户的资源列表
	 * @return
	 * @throws BusinessException
	 */
	public String listAllPTemplate() throws BusinessException {
		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//设置当前登陆人
			List<Map<String, Object>> listData = business
					.list_portlet_template(query);
			for (Map<String, Object> rm : listData) {
				if(rm.get("P_TYPE")==null||!rm.get("P_TYPE").equals("3"))
				{
					rm.remove("RSS_CONTENT");
					rm.remove("TAKE_CONTENT");
				}
			}
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listData.size());
			data.put("pageCount", listData.size());
			data.put("rows", data.get("rowSet"));
			data.put("total", listData.size());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 获取用户的资源列表
	 * @return
	 * @throws BusinessException
	 */
	public String listAllPTemplateByUser() throws BusinessException {
		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//设置当前登陆人
			query.put("USER_ID", SessionUtil.getEmid());
			List<Map<String, Object>> listData = business
					.list_portlet_template_by_user(query);
			for (Map<String, Object> rm : listData) {
				if(rm.get("P_TYPE")==null||!rm.get("P_TYPE").equals("3"))
				{
					rm.remove("RSS_CONTENT");
					rm.remove("TAKE_CONTENT");
				}
			}
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listData.size());
			data.put("pageCount", listData.size());
			data.put("rows", data.get("rowSet"));
			data.put("total", listData.size());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
}
