package com.jw.app.store.action;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import oracle.sql.BLOB;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.jw.app.business.StoreBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.business.util.Status;
import com.gaowj.business.vfs.FileUtil;
import com.gaowj.util.AuthenticateUtil;
import com.gaowj.util.JPinyin4jUtil;
import com.gaowj.util.Md5CaculateUtil;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 124457626402410251L;
	
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String father_path = request.getParameter("FATHER_PATH");
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);
				
			//去除不要更新的字段
			entity.remove("OPETYPE");
			boolean is_save2db = Boolean.parseBoolean(PropUtil.getValue("uploadfile_savetodb", "quartz_service", "true"));
			String isfile = (String) entity.get("ISFILE");
			if(is_save2db){
				//处理上传文件保存到数据库
				if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
					String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
					FileUtil fileUtil = new FileUtil();
					File f = new File(uploadFile);
					if(f.isFile()){
						entity.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
					}
				}
			}
			//根据属性状态来填写FILE_TYPE内容,是目录填folder,是文件填扩展名
			String file_name = (String) entity.get("FILE_NAME");
			String file_type = (String) entity.get("FILE_TYPE");
			if(StringUtils.isEmpty(file_type)){
				String user_defaule_filedir = PropUtil.getValue("user_defaule_filedir", "quartz_service", "folder");
				if(StringUtils.equals("0", isfile)){
					entity.put("FILE_TYPE", user_defaule_filedir);
				}else{
					if(StringUtils.isNotEmpty(file_name)){
						String ext = file_name.substring(file_name.lastIndexOf(".")+1, file_name.length());
						if((ext.length()==file_name.length())==false){
							entity.put("FILE_TYPE", ext);
						}
					}
				}
			}
			//根据属性状态来填写FILE_SVAE_NAME内容,是目录填folder_中文拼音,是文件不动作
			String file_svae_name = (String) entity.get("FILE_SVAE_NAME");
			if(StringUtils.isEmpty(file_svae_name)){
				if(StringUtils.equals("0", isfile)){
					if(StringUtils.isNotEmpty(file_name)){
						JPinyin4jUtil jp = new JPinyin4jUtil();
						entity.put("FILE_SVAE_NAME",father_path+File.separator+jp.changeToTonePinYinTrim(file_name));
					}
				}
			}
			//处理md5值和文件大小
			if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
				String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
				long beginTime = System.currentTimeMillis();
				File file = new File(uploadFile);
				String md5 = Md5CaculateUtil.getMD5(file);
				long endTime = System.currentTimeMillis();
				System.out.println("MD5:" + md5 + "\n 耗时:" + ((endTime - beginTime) / 1000) + "s");
				entity.put("MD5_ID", md5);
				int f_size = (int) (file.length()/1024);
				if((file.length()%1024)>0)f_size=f_size+1;
				entity.put("FILE_SIZE",f_size);
			}
			
			//新增
			business.insert_store(entity);
			
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
				sysbusiness.insert_logBusiness("insertStore", "" + entity,
						"增加网盘公司文件", (String) entity.get("UUID"), (String) entity
								.get("FILE_NAME"), "store");
			//	
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String father_path = request.getParameter("FATHER_PATH");
		try {
			
			//去除不要更新的字段
			entity.remove("OPETYPE");
			boolean is_save2db = Boolean.parseBoolean(PropUtil.getValue("uploadfile_savetodb", "quartz_service", "true"));
			String isfile = (String) entity.get("ISFILE");
			if(is_save2db){
				//处理上传文件保存到数据库
				if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
					String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
					FileUtil fileUtil = new FileUtil();
					File f = new File(uploadFile);
					if(f.isFile()){
						entity.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
					}
				}
			}
			//根据属性状态来填写FILE_TYPE内容,是目录填folder,是文件填扩展名
			String file_name = (String) entity.get("FILE_NAME");
			String file_type = (String) entity.get("FILE_TYPE");
			if(StringUtils.isEmpty(file_type)){
				String user_defaule_filedir = PropUtil.getValue("user_defaule_filedir", "quartz_service", "folder");
				if(StringUtils.equals("0", isfile)){
					entity.put("FILE_TYPE", user_defaule_filedir);
				}else{
					if(StringUtils.isNotEmpty(file_name)){
						String ext = file_name.substring(file_name.lastIndexOf(".")+1, file_name.length());
						if((ext.length()==file_name.length())==false){
							entity.put("FILE_TYPE", ext);
						}
					}
				}
			}
			//根据属性状态来填写FILE_SVAE_NAME内容,是目录填folder_中文拼音,是文件不动作
			String file_svae_name = (String) entity.get("FILE_SVAE_NAME");
			if(StringUtils.isEmpty(file_svae_name)){
				if(StringUtils.equals("0", isfile)){
					if(StringUtils.isNotEmpty(file_name)){
						JPinyin4jUtil jp = new JPinyin4jUtil();
						entity.put("FILE_SVAE_NAME",father_path+File.separator+jp.changeToTonePinYinTrim(file_name));
					}
				}
			}
			//处理md5值和文件大小
			if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
				String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
				long beginTime = System.currentTimeMillis();
				File file = new File(uploadFile);
				String md5 = Md5CaculateUtil.getMD5(file);
				long endTime = System.currentTimeMillis();
				System.out.println("MD5:" + md5 + "\n 耗时:" + ((endTime - beginTime) / 1000) + "s");
				entity.put("MD5_ID", md5);
				int f_size = (int) (file.length()/1024);
				if((file.length()%1024)>0)f_size=f_size+1;
				entity.put("FILE_SIZE",f_size);
			}
			
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_store(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateStore", "" + entity, 
					"修改网盘公司文件",(String) entity.get("UUID"), (String) entity
					          .get("FILE_NAME"),"store");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_store(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteStore", "" + ListKey,
					"软删除网盘公司文件", deletekey, "多个流水号","store");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("软删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("软删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String resumeStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.resume_store(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("resumeStroe", "" + ListKey,
					"恢复网盘公司文件", deletekey, "多个流水号","store");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("恢复成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("恢复失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteTrueStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		//获取需删除的记录
		Map<String, Object> v_query = new HashMap<String,Object>();
		v_query.put("UUIDLIST", ListKey);
		List<Map<String, Object>> listData = business.list_storenofile(v_query);
		//
		
		try {
			business.delete_true_store(ListKey);
			
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			//sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			sysbusiness.insert_logBusiness("deleteTrueStore", "" + ListKey,
					"清除网盘公司文件", deletekey, "多个流水号","store");
			//
			
			boolean delete_true_and_delete_disk_file = Boolean.parseBoolean(PropUtil.getValue("delete_true_and_delete_disk_file", "quartz_service", "false"));
			if(delete_true_and_delete_disk_file){
				//删除相应的目录上文件
				for(Map<String, Object> delete_m:listData){
					if(delete_m.get("FILE_SAVE_PATH")!=null && delete_m.get("FILE_SVAE_NAME")!=null){
						String ls_file = delete_m.get("FILE_SAVE_PATH").toString()+File.separator+delete_m.get("FILE_SVAE_NAME").toString();
						File dFile = new File(ls_file);
						if(dFile.exists()){
							boolean tf = dFile.delete();
							String tf_name = "";
							if(tf){
								tf_name = "清除目录文件成功";
							}else{
								tf_name = "清除目录文件失败,可能文件被占";
							}
							System.out.println(tf_name+":"+ls_file);
							sysbusiness.insert_logBusiness("deleteTrueStore", "" + ls_file,
									tf_name, delete_m.get("UUID").toString(), (String)delete_m.get("FILE_NAME"),"store");
							
						}
					}
				}
				//
			}
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 根据条件清空大字段文件和加载大字段文件
	 * @param entity
	 * @throws BusinessException
	 */
	public String setStore() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		List<String> setKeySuccess = new ArrayList<String>();
		String ls_setname = "";
		try {
			Map<String, Object> v_query = new HashMap<String,Object>();
			v_query.put("UUIDLIST", ListKey);
			List<Map<String, Object>> listData = business.list_storenofile(v_query);
			String ls_set = (String) entity.get("SETKEY");
			
			if(listData.size()>0){
				if(StringUtils.isNotEmpty(ls_set) && ls_set.equals("0")){
					ls_setname = "清空大数据字段文件";
					for(Map<String, Object> m:listData){
						if(m.get("ISFILE").toString().equals("0")) continue;
						String exist_file = (String)m.get("EXIST_FILE");
						if(exist_file.equals("1")){//清空大数据字段文件并写到文件上
							setKeySuccess.add((String)m.get("UUID"));
							String uuid = (String)m.get("UUID");
					    	String uploadnew = (String)m.get("FILE_SVAE_NAME");
							String uploadpath= (String)m.get("FILE_SAVE_PATH");
							db2fileStore(uuid,uploadpath,uploadnew,false);
						}
					}
					if(setKeySuccess.size()>0){
						business.setnull_binary_data(setKeySuccess);
					}
				}else if(StringUtils.isNotEmpty(ls_set) && ls_set.equals("1")){
					ls_setname = "往大数据字段保存文件";
					for(Map<String, Object> m:listData){
						if(m.get("ISFILE").toString().equals("0")) continue;
						String exist_file = (String)m.get("EXIST_FILE");
						if(exist_file.equals("1")) continue;
						//处理上传文件保存到数据库
						if(m.get("FILE_SAVE_PATH")!=null && m.get("FILE_SVAE_NAME")!=null){
							String uploadFile  = (String)m.get("FILE_SAVE_PATH")+File.separator+(String)m.get("FILE_SVAE_NAME");
							FileUtil fileUtil = new FileUtil();
							File f = new File(uploadFile);
							if(f.isFile()){
								m.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
								m.remove("CREATE_NAME");
								m.remove("UPDATE_NAME");
								m.remove("EXIST_FILE");
								m.remove("FILENUMBER");
								setKeySuccess.add((String)m.get("UUID"));
								business.update_store(m);
							}
						}
						
					}
				}
			}
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("setStore"+ls_set, "" + ListKey+",处理网盘公司文件("+setKeySuccess+")",
					ls_setname, deletekey, "多个流水号","store");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage(ls_setname+"成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage(ls_setname+"失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	
	public String upload() throws BusinessException{
		String savePath = "";
		if(StringUtils.isEmpty(savePath)) savePath =  AuthenticateUtil.getEndpoint("uploadPath");
		if(StringUtils.isEmpty(savePath))savePath = request.getSession().getServletContext().getRealPath("/uploadFile/file/");
		try {
			savePath = setFilepath(savePath, true);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.setUserUploadFilePath(savePath);
		super.upload();
		String ret = super.getUserUploadFileResult();
		// 操作日志
		SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		sysbusiness.insert_logBusiness("upload", "用户["+SessionUtil.getEmname()+"]上传网盘公司文件:"+ret,
				"上传文件", ret, "上传文件："+super.getUserFileFileName(),"store");
		//
		return null;
    }
	
	/**
	 * 路径下有文件从路径中下载，没有则从库里写到路径中再下载
	 * @param entity
	 * @throws BusinessException
	 */
	public String download() throws BusinessException{
    	String ret_download ="";
    	String uuid = request.getParameter("uuid");
    	String uploadnew=request.getParameter("uploadnew");
		String uploadpath=request.getParameter("uploadpath");
//		String downloadFilenameEncode1 = PropUtil.getValue("downloadFilenameEncode1", "quartz_service", "gbk");
//		String downloadFilenameEncode2 = PropUtil.getValue("downloadFilenameEncode2", "quartz_service", "iso8859-1");
//		super.setEncoding1(downloadFilenameEncode1);
//		super.setEncoding2(downloadFilenameEncode2);
		response.setCharacterEncoding("utf-8");
		if(new File(uploadpath+File.separator+uploadnew).exists()==false){
			db2fileStore(uuid,uploadpath,uploadnew,false);
			ret_download = super.download();
		}else{
			ret_download = super.download();
		}
		String filename1 = RequestUtils.getString(request, "uploadold");
		try {
			filename1 = new String(filename1.getBytes("ISO-8859-1"),"UTF-8");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// 操作日志
		SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		sysbusiness.insert_logBusiness("download", "用户["+SessionUtil.getEmname()+"]下载网盘公司文件："+ uploadpath+File.separator+uploadnew,
				"下载文件",uploadpath+File.separator+uploadnew,filename1,"store");
		//
    	return ret_download;
    }
	
	/**---------------供其它模块接口使用-------------------**/
	
	/**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteStoreCommon() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		
		if(query.get("MAINDATA_ID")==null || query.get("MODULE_ID")==null){
			jsonObject.putAll(Status.getStatusErrorMessage("参数错误"));
			return "json";
		}
		//批处理MAINDATA_ID和MODULE_ID
		if(query.get("MAINDATA_ID")!=null){
			query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
			query.remove("MAINDATA_ID");
		}
		if(query.get("MODULE_ID")!=null){
			query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
			query.remove("MODULE_ID");
		}
		//
		
		try {
			query = QueryParamUtil.StringToDate(query);
			business.delete_store_common(query);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteStoreCommon", "" + query,
					"软删除网盘公司文件", query.get("MAINDATA_ID")+""+query.get("MODULE_ID"), "多个（模块+主表ID）","stroe");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("软删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("软删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String resumeStoreCommon() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
        Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		
		if(query.get("MAINDATA_ID")==null || query.get("MODULE_ID")==null){
			jsonObject.putAll(Status.getStatusErrorMessage("参数错误"));
			return "json";
		}
		//批处理MAINDATA_ID和MODULE_ID
		if(query.get("MAINDATA_ID")!=null){
			query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
			query.remove("MAINDATA_ID");
		}
		if(query.get("MODULE_ID")!=null){
			query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
			query.remove("MODULE_ID");
		}
		//
		
		try {
			query = QueryParamUtil.StringToDate(query);
			business.resume_store_common(query);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("resumeStoreCommon", "" + query,
					"恢复网盘公司文件", query.get("MAINDATA_ID")+""+query.get("MODULE_ID"), "多个（模块+主表ID）","store");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("恢复成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("恢复失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteTrueStoreCommon() throws BusinessException {

		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
        Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		
		if(query.get("MAINDATA_ID")==null || query.get("MODULE_ID")==null){
			jsonObject.putAll(Status.getStatusErrorMessage("参数错误"));
			return "json";
		}
		//获取需删除的记录
		Map<String, Object> v_query = new HashMap<String,Object>();
		v_query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
		v_query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
		List<Map<String, Object>> listData = business.list_storenofile(v_query);
		//
		
		//批处理MAINDATA_ID和MODULE_ID
		if(query.get("MAINDATA_ID")!=null){
			query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
			query.remove("MAINDATA_ID");
		}
		if(query.get("MODULE_ID")!=null){
			query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
			query.remove("MODULE_ID");
		}
		//
		
		try {
			query = QueryParamUtil.StringToDate(query);
			business.delete_true_store_common(query);
			
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			//sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			sysbusiness.insert_logBusiness("deleteTrueStoreCommon", "" + query,
					"清除网盘公司文件", query.get("MAINDATA_ID")+""+query.get("MODULE_ID"), "多个（模块+主表ID）","store");
			//
			boolean delete_true_and_delete_disk_file = Boolean.parseBoolean(PropUtil.getValue("delete_true_and_delete_disk_file", "quartz_service", "false"));
			if(delete_true_and_delete_disk_file){
				//删除相应的目录上文件
				for(Map<String, Object> delete_m:listData){
					if(delete_m.get("FILE_SAVE_PATH")!=null && delete_m.get("FILE_SVAE_NAME")!=null){
						String ls_file = delete_m.get("FILE_SAVE_PATH").toString()+File.separator+delete_m.get("FILE_SVAE_NAME").toString();
						File dFile = new File(ls_file);
						if(dFile.exists()){
							boolean tf = dFile.delete();
							String tf_name = "";
							if(tf){
								tf_name = "清除目录文件成功";
							}else{
								tf_name = "清除目录文件失败,可能文件被占";
							}
							sysbusiness.insert_logBusiness("deleteTrueStoreCommon", "" + ls_file,
									tf_name, delete_m.get("UUID").toString(), (String)delete_m.get("FILE_NAME"),"store");
							
						}
					}
				}
				//
			}
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	private void db2fileStore(String uuid,String uploadpath,String uploadnew,boolean isDelete){
	    StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
	    Map<String, Object> mapquery = new HashMap<String, Object>();
        mapquery.put("UUID", uuid);
        List<Map<String, Object>> list = business.list_store(mapquery);
        BufferedInputStream bis = null;       
		try {
			if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof byte[]){
		    	   byte[] b = (byte[]) list.get(0).get("BINARY_DATA");
		    	   bis = new BufferedInputStream(new ByteArrayInputStream(b));
	        }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof Blob){
	    	   Blob b = (Blob)list.get(0).get("BINARY_DATA");
	    	   try {
				bis = new BufferedInputStream(b.getBinaryStream());
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	       }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof String){
	    	   String b = (String)list.get(0).get("BINARY_DATA");
	    	   bis = new BufferedInputStream(new ByteArrayInputStream(b.getBytes())); 
	       }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof oracle.sql.BLOB){
	        	oracle.sql.BLOB filedata = (BLOB) list.get(0).get("BINARY_DATA");
	        	bis = new BufferedInputStream(filedata.getBinaryStream());
	        }
			File dir = new File(uploadpath);
			if (!dir.exists()) {
			    dir.mkdirs();
			}
			if(bis == null) bis = new BufferedInputStream(new ByteArrayInputStream("文件读取出错!".getBytes()));
			File tempfile = new File(uploadpath+File.separator+uploadnew);
			FileOutputStream fio =new FileOutputStream(tempfile);
			IOUtils.copy(bis, fio);
			IOUtils.closeQuietly(bis);
			IOUtils.closeQuietly(fio);
			if(isDelete)tempfile.delete();
		}catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private String setFilepath(String sourcepath,boolean tf)throws Exception{
		String destpath = "";
		if(StringUtils.isEmpty(sourcepath)||StringUtils.equalsIgnoreCase(sourcepath, "UUID"))
			sourcepath = PropUtil.getValue("uploadPath","quartz_service","");
		Calendar date=Calendar.getInstance();
		SimpleDateFormat format1=new SimpleDateFormat("yyyy"); 
		SimpleDateFormat format2=new SimpleDateFormat("MM");
		SimpleDateFormat format3=new SimpleDateFormat("dd");
		String name1=format1.format(date.getTime());
		String name2=format2.format(date.getTime());
		String name3=format3.format(date.getTime());
		destpath = sourcepath+"store"+File.separator+name1+File.separator+name2+File.separator+name3;
		if(tf){
			File fileDir=new File(destpath);
			if(!fileDir.exists()){
				fileDir.mkdirs();
			}
		}
		return destpath;
	}

}
