package com.jw.app.store.action;

import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.jw.app.business.StoreBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.EasyuiJsonUtils;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;

public class dataAction extends BasicAction {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1838735286131979745L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页
	public JSONObject getJsonObject() {
		return jsonObject;
	}
	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	/**
	 * 分页获取记录不含文件大字段
	 * @param entity
	 * @throws BusinessException
	 */
	public String list_storenofile() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			if(query.get("MAINDATA_ID")!=null && query.get("MAINDATA_ID").toString().indexOf(",")>-1){
				query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
				query.remove("MAINDATA_ID");
			}
			if(query.get("MODULE_ID")!=null && query.get("MODULE_ID").toString().indexOf(",")>-1){
				query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
				query.remove("MODULE_ID");
			}
			//
			Page<Map<String, Object>> pageRows = business.list_storenofile(pageNo,pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String listAll_storenofile() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			if(query.get("MAINDATA_ID")!=null && query.get("MAINDATA_ID").toString().indexOf(",")>-1){
				query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
				query.remove("MAINDATA_ID");
			}
			if(query.get("MODULE_ID")!=null && query.get("MODULE_ID").toString().indexOf(",")>-1){
				query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
				query.remove("MODULE_ID");
			}
			//
			List<Map<String, Object>> listData = business.list_storenofile(query);
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String list() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			if(query.get("MAINDATA_ID")!=null && query.get("MAINDATA_ID").toString().indexOf(",")>-1){
				query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
				query.remove("MAINDATA_ID");
			}
			if(query.get("MODULE_ID")!=null && query.get("MODULE_ID").toString().indexOf(",")>-1){
				query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
				query.remove("MODULE_ID");
			}
			//
			Page<Map<String, Object>> pageRows = business.list_store(pageNo,pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String listAll() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			if(query.get("MAINDATA_ID")!=null && query.get("MAINDATA_ID").toString().indexOf(",")>-1){
				query.put("MAINDATA_IDLIST", QueryParamUtil.StringToList(query.get("MAINDATA_ID").toString()));
				query.remove("MAINDATA_ID");
			}
			if(query.get("MODULE_ID")!=null && query.get("MODULE_ID").toString().indexOf(",")>-1){
				query.put("MODULE_IDLIST", QueryParamUtil.StringToList(query.get("MODULE_ID").toString()));
				query.remove("MODULE_ID");
			}
			//
			List<Map<String, Object>> listData = business.list_store(query);
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 获取文件目录树
	 * @param entity
	 * @throws BusinessException
	 */
	public String listTree() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			List<Map<String, Object>> listData = business.list_storetree(query);
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 获取easyui文件目录树
	 * @param entity
	 * @throws BusinessException
	 */
	public String listTreeEasyui() throws BusinessException {
		StoreBusiness business = BusinessManager.getBusiness(StoreBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			List<Map<String, Object>> listData = business.list_storetree(query);
			EasyuiJsonUtils.reSetPara("UUID","FILE_NAME","FATHER_ID");
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", EasyuiJsonUtils.getTreeJsonData(listData));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
