package com.jw.app.store.action.partook;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.StorePartookBusiness;

import net.sf.json.JSONObject;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3801177982688171221L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页
	public JSONObject getJsonObject() {
		return jsonObject;
	}
	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	/**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String list() throws BusinessException {
		StorePartookBusiness business = BusinessManager.getBusiness(StorePartookBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			//
			Page<Map<String, Object>> pageRows = business.list_partook(pageNo,pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String listAll() throws BusinessException {
		StorePartookBusiness business = BusinessManager.getBusiness(StorePartookBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			//
			List<Map<String, Object>> listData = business.list_partook(query);
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	//验证分享码是否对
	public String check() throws BusinessException {
		StorePartookBusiness business = BusinessManager.getBusiness(StorePartookBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			List<Map<String, Object>> listData = business.list_partook(query);
			jsonObject = new JSONObject();
			//添加一个session,来区别已经验证好的
			if(listData.size()>0){
				request.getSession().setAttribute(query.get("PARTOOK_CODE_EQUAL").toString(),true);
			}
			
			//把密码去掉
			//去掉密码
			for(Map<String, Object> map : listData){
				map.remove("PARTOOK_PASS");
			}
			//把获取的数据返回到前台
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject.put("data",data);
			jsonObject.put("result", listData.size()>0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	//获取发分享文件的信息列表
	public String listAllShare() throws BusinessException {
		StorePartookBusiness business = BusinessManager.getBusiness(StorePartookBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			//批处理UUID，MAINDATA_ID和MODULE_ID
			if(query.get("UUID")!=null && query.get("UUID").toString().indexOf(",")>-1){
				query.put("UUIDLIST", QueryParamUtil.StringToList(query.get("UUID").toString()));
				query.remove("UUID");
			}
			//
			List<Map<String, Object>> listData = business.list_partook(query);
			//去掉密码
			for(Map<String, Object> map : listData){
				if("666666".equals(map.get("PARTOOK_PASS"))){
					map.put("IS_PWD", "false");
				}
				else{
					map.put("IS_PWD", "true");
				}
				map.remove("PARTOOK_PASS");
			}
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
}
