package com.jw.app.store.action.personal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import oracle.sql.BLOB;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.business.util.Status;
import com.gaowj.business.vfs.FileUtil;
import com.gaowj.util.AuthenticateUtil;
import com.gaowj.util.JPinyin4jUtil;
import com.gaowj.util.Md5CaculateUtil;
import com.jw.app.business.StorePartookBusiness;
import com.jw.app.business.StorePersonalBusiness;
import com.jw.app.business.StoreShareBusiness;
import com.jw.app.business.StoreUserBusiness;
import com.sun.tools.ws.processor.model.Request;

public class actAction extends BasicAction {
	/**
	 * 
	 */
	private static final long serialVersionUID = 5614739796006595897L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String father_path = request.getParameter("FATHER_PATH");
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);
				
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//处理目录/文件重名的问题,处理是直接在文件和目录后加数字
//			Map<String,Object> v_congfu_query = new HashMap<String,Object>();
//			v_congfu_query.put("FATHER_ID", entity.get("FATHER_ID"));
//			v_congfu_query.put("CREATOR_ID", entity.get("CREATOR_ID"));
//			String isfile_1 = (String) entity.get("ISFILE");
//			if(StringUtils.equals(isfile_1, "1")){
//				String fname = (String) entity.get("FILE_NAME");
//				fname = fname.substring(0,fname.lastIndexOf("."));
//				v_congfu_query.put("FILE_NAME",fname);
//			}else{
//				v_congfu_query.put("FILE_NAME", entity.get("FILE_NAME"));
//			}
//			int ret_count = business.listCount_storePersonal(v_congfu_query);
//			if(ret_count>0){
//				String fname = (String) entity.get("FILE_NAME");
//				if(StringUtils.equals(isfile_1, "1")){
//				    fname = fname.substring(0,fname.lastIndexOf("."))+"("+ret_count+")."+fname.substring(fname.lastIndexOf(".")+1);
//				}else{
//					fname = fname + "("+ret_count+")";
//				}
//				entity.put("FILE_NAME",fname);
//			}
			//处理超限问题
			StoreUserBusiness business_storeuser = BusinessManager.getBusiness(StoreUserBusiness.class);
			Map<String,Object> storeuserQuery = new HashMap<String,Object>();
			//个人文件夹设置查看权限
			if(StringUtils.equals(SessionUtil.getCode(),"6666") || StringUtils.equals(SessionUtil.getCode(),"admin")){
			  String creator_id = (String) entity.get("CREATOR_ID");
			  if(StringUtils.isNotEmpty(creator_id)){
				  storeuserQuery.put("CREATOR_ID", creator_id);
			  }else{
				  storeuserQuery.put("CREATOR_ID", SessionUtil.getCode());
			  }
			}else{
				storeuserQuery.put("CREATOR_ID", SessionUtil.getCode());
			}
			List<Map<String, Object>> isFullData = business_storeuser.is_full_size(storeuserQuery);
			if(isFullData.size()>0 && isFullData.get(0).get("IS_FULL").toString().equals("0")){
				jsonObject.putAll(Status.getStatusErrorMessage("保存失败,当前用户容量超限"));
				//删除上传的附件
				String isfile = (String) entity.get("ISFILE");
				if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
					String ls_file  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
					File dFile = new File(ls_file);
					String tf_name = "";
					if(dFile.exists()){
						boolean tf = dFile.delete();
						if(tf){
							tf_name = "清除目录文件成功";
						}else{
							tf_name = "清除目录文件失败,可能文件被占";
						}
						System.out.println(tf_name+":"+ls_file);	
					}
					if(StringUtils.isNotEmpty(tf_name)){
						jsonObject.putAll(Status.getStatusErrorMessage("保存失败,当前用户容量超限,"+tf_name));
					}
				}
			}else{
				//
				boolean is_save2db = Boolean.parseBoolean(PropUtil.getValue("uploadfile_savetodb", "quartz_service", "true"));
				String isfile = (String) entity.get("ISFILE");
				if(is_save2db){
					//处理上传文件保存到数据库
					if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
						String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
						FileUtil fileUtil = new FileUtil();
						File f = new File(uploadFile);
						if(f.isFile()){
							entity.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
						}
					}
				}
				//根据属性状态来填写FILE_TYPE内容,是目录填folder,是文件填扩展名
				String file_name = (String) entity.get("FILE_NAME");
				String file_type = (String) entity.get("FILE_TYPE");
				if(StringUtils.isEmpty(file_type)){
					String user_defaule_filedir = PropUtil.getValue("user_defaule_filedir", "quartz_service", "folder");
					if(StringUtils.equals("0", isfile)){
						entity.put("FILE_TYPE", user_defaule_filedir);
					}else{
						if(StringUtils.isNotEmpty(file_name)){
							String ext = file_name.substring(file_name.lastIndexOf(".")+1, file_name.length());
							if((ext.length()==file_name.length())==false){
								entity.put("FILE_TYPE", ext);
							}
						}
					}
				}
				//根据属性状态来填写FILE_SVAE_NAME内容,是目录填folder_中文拼音,是文件不动作
				String file_svae_name = (String) entity.get("FILE_SVAE_NAME");
				if(StringUtils.isEmpty(file_svae_name)){
					if(StringUtils.equals("0", isfile)){
						if(StringUtils.isNotEmpty(file_name)){
							JPinyin4jUtil jp = new JPinyin4jUtil();
							entity.put("FILE_SVAE_NAME",father_path+File.separator+jp.changeToTonePinYinTrim(file_name));
						}
					}
				}
				//处理md5值和文件大小
				int ls_file_size = 0;
				if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
					String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
					long beginTime = System.currentTimeMillis();
					File file = new File(uploadFile);
					String md5 = Md5CaculateUtil.getMD5(file);
					long endTime = System.currentTimeMillis();
					System.out.println("MD5:" + md5 + "\n 耗时:" + ((endTime - beginTime) / 1000) + "s");
					entity.put("MD5_ID", md5);
					int f_size = (int) (file.length()/1024);
					if((file.length()%1024)>0)f_size=f_size+1;
					entity.put("FILE_SIZE",f_size);
					
					ls_file_size = f_size;
				}
				
				//新增
				business.insert_storePersonal(entity);
				
				// 操作日志
				SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
					sysbusiness.insert_logBusiness("insertStorePersonal", "" + entity,
							"增加网盘公司文件", (String) entity.get("UUID"), (String) entity
									.get("FILE_NAME"), "storePersonal");
					
				//处理个人开盘信息和开盘容量
				if(ls_file_size>0){
					String current_user = (String) entity.get("CREATOR_ID");
					if(StringUtils.isEmpty(current_user)){
						current_user = SessionUtil.getCode();
					}
					Map<String,Object> v_query = new HashMap<String,Object>();
					v_query.put("USER_ID",current_user);
					List<Map<String,Object>> storeuser = business_storeuser.list_user(v_query);
					if(storeuser.size()==0){
						//默认为配置文件取,取不到则为1073741824KB=1G
						String user_store_default_1gbsize = PropUtil.getValue("user_store_default_1gbsize", "quartz_service", "1073741824");
						Map<String,Object> idata = new HashMap<String,Object>();
						idata.put("USER_ID", current_user);
						idata.put("STORE_SIZE", user_store_default_1gbsize);
						idata.put("USE_SIZE", ls_file_size);
						business_storeuser.insert_user(idata);
					}else{
						Map<String,Object> udata = storeuser.get(0);
					    int c_size = (Integer) udata.get("USE_SIZE");
					    c_size = c_size + ls_file_size;
					    udata.put("USE_SIZE", c_size);
					    //
					    udata.remove("ID_NUMBER");
					    udata.remove("USER_NAME");
					    udata.remove("CREATE_NAME");
					    //
					    business_storeuser.update_user(udata);
					}
				}
				//
				jsonObject.putAll(Status.getStatusSuccessMessage("保存成功,"+entity.get("FILE_NAME")));
			}
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String father_path = request.getParameter("FATHER_PATH");
//		String old_file_name = request.getParameter("OLD_FILE_NAME");
		try {
//			String is_fname = (String) entity.get("FILE_NAME");
//			if(!StringUtils.equals(is_fname, old_file_name)){
//				//处理目录/文件重名的问题,处理是直接在文件和目录后加数字
//				Map<String,Object> v_congfu_query = new HashMap<String,Object>();
//				v_congfu_query.put("FATHER_ID", entity.get("FATHER_ID"));
//				v_congfu_query.put("CREATOR_ID", entity.get("CREATOR_ID"));
//				String isfile_1 = (String) entity.get("ISFILE");
//				if(StringUtils.equals(isfile_1, "1")){
//					String fname = (String) entity.get("FILE_NAME");
//					fname = fname.substring(0,fname.lastIndexOf("."));
//					v_congfu_query.put("FILE_NAME",fname);
//				}else{
//					v_congfu_query.put("FILE_NAME", entity.get("FILE_NAME"));
//				}
//				int ret_count = business.listCount_storePersonal(v_congfu_query);
//				if(ret_count>0){
//					String fname = (String) entity.get("FILE_NAME");
//					if(StringUtils.equals(isfile_1, "1")){
//					    fname = fname.substring(0,fname.lastIndexOf("."))+"("+ret_count+")."+fname.substring(fname.lastIndexOf(".")+1);
//					}else{
//						fname = fname + "("+ret_count+")";
//					}
//					entity.put("FILE_NAME",fname);
//				}
//			}
			//去除不要更新的字段
			entity.remove("OPETYPE");
			boolean is_save2db = Boolean.parseBoolean(PropUtil.getValue("uploadfile_savetodb", "quartz_service", "true"));
			String isfile = (String) entity.get("ISFILE");
			if(is_save2db){
				//处理上传文件保存到数据库
				if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
					String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
					FileUtil fileUtil = new FileUtil();
					File f = new File(uploadFile);
					if(f.isFile()){
						entity.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
					}
				}
			}
			//根据属性状态来填写FILE_TYPE内容,是目录填folder,是文件填扩展名
			String file_name = (String) entity.get("FILE_NAME");
			String file_type = (String) entity.get("FILE_TYPE");
			if(StringUtils.isEmpty(file_type)){
				String user_defaule_filedir = PropUtil.getValue("user_defaule_filedir", "quartz_service", "folder");
				if(StringUtils.equals("0", isfile)){
					entity.put("FILE_TYPE", user_defaule_filedir);
				}else{
					if(StringUtils.isNotEmpty(file_name)){
						String ext = file_name.substring(file_name.lastIndexOf(".")+1, file_name.length());
						if((ext.length()==file_name.length())==false){
							entity.put("FILE_TYPE", ext);
						}
					}
				}
			}
			//根据属性状态来填写FILE_SVAE_NAME内容,是目录填folder_中文拼音,是文件不动作
			String file_svae_name = (String) entity.get("FILE_SVAE_NAME");
			if(StringUtils.isEmpty(file_svae_name)){
				if(StringUtils.equals("0", isfile)){
					if(StringUtils.isNotEmpty(file_name)){
						JPinyin4jUtil jp = new JPinyin4jUtil();
						entity.put("FILE_SVAE_NAME",father_path+File.separator+jp.changeToTonePinYinTrim(file_name));
					}
				}
			}
			//处理md5值和文件大小
			int ls_file_size = 0;
			if(StringUtils.equals("1", isfile) && entity.get("FILE_SAVE_PATH")!=null && entity.get("FILE_SVAE_NAME")!=null){
				String uploadFile  = (String)entity.get("FILE_SAVE_PATH")+File.separator+(String)entity.get("FILE_SVAE_NAME");
				long beginTime = System.currentTimeMillis();
				File file = new File(uploadFile);
				String md5 = Md5CaculateUtil.getMD5(file);
				long endTime = System.currentTimeMillis();
				System.out.println("MD5:" + md5 + "\n 耗时:" + ((endTime - beginTime) / 1000) + "s");
				entity.put("MD5_ID", md5);
				int f_size = (int) (file.length()/1024);
				if((file.length()%1024)>0)f_size=f_size+1;
				entity.put("FILE_SIZE",f_size);
				
				ls_file_size = f_size;
			}
			
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_storePersonal(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateStorePersonal", "" + entity, 
					"修改网盘公司文件",(String) entity.get("UUID"), (String) entity
					          .get("FILE_NAME"),"storePersonal");
			
			//处理个人开盘信息和开盘容量
			if(ls_file_size>0){
				String current_user = (String) entity.get("CREATOR_ID");
				if(StringUtils.isEmpty(current_user)){
					current_user = SessionUtil.getCode();
				}
				StoreUserBusiness business_storeuser = BusinessManager.getBusiness(StoreUserBusiness.class);
				Map<String,Object> v_query = new HashMap<String,Object>();
				v_query.put("USER_ID",current_user);
				List<Map<String,Object>> storeuser = business_storeuser.list_user(v_query);
				if(storeuser.size()==0){
					//默认为配置文件取,取不到则为1073741824KB=1G
					String user_store_default_1gbsize = PropUtil.getValue("user_store_default_1gbsize", "quartz_service", "1073741824");
					Map<String,Object> idata = new HashMap<String,Object>();
					idata.put("USER_ID", current_user);
					idata.put("STORE_SIZE", user_store_default_1gbsize);
					idata.put("USE_SIZE", ls_file_size);
					business_storeuser.insert_user(idata);
				}else{
					Map<String,Object> udata = storeuser.get(0);
				    int c_size = (Integer) udata.get("USE_SIZE");
				    c_size = c_size + ls_file_size;
				    udata.put("USE_SIZE", c_size);
				    //
				    udata.remove("ID_NUMBER");
				    udata.remove("USER_NAME");
				    udata.remove("CREATE_NAME");
				    //
				    business_storeuser.update_user(udata);
				}
			}
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功,"+entity.get("FILE_NAME")));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_storePersonal(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteStorePersonal", "" + ListKey,
					"软删除网盘公司文件", deletekey, "多个流水号","storePersonal");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("软删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("软删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String resumeStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.resume_storePersonal(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("resumeStroe", "" + ListKey,
					"恢复网盘公司文件", deletekey, "多个流水号","storePersonal");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("恢复成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("恢复失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteTrueStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		//获取需删除的记录
		Map<String, Object> v_query = new HashMap<String,Object>();
		v_query.put("UUIDLIST", ListKey);
		List<Map<String, Object>> listData = business.list_storePersonalnofile(v_query);
		//
		
		try {
			business.delete_true_storePersonal(ListKey);
			
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			//sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			sysbusiness.insert_logBusiness("deleteTrueStorePersonal", "" + ListKey,
					"清除网盘公司文件", deletekey, "多个流水号","storePersonal");
			//
			
			boolean delete_true_and_delete_disk_file = Boolean.parseBoolean(PropUtil.getValue("delete_true_and_delete_disk_file", "quartz_service", "false"));
			if(delete_true_and_delete_disk_file){
				//删除相应的目录上文件
				for(Map<String, Object> delete_m:listData){
					if(delete_m.get("FILE_SAVE_PATH")!=null && delete_m.get("FILE_SVAE_NAME")!=null){
						String ls_file = delete_m.get("FILE_SAVE_PATH").toString()+File.separator+delete_m.get("FILE_SVAE_NAME").toString();
						File dFile = new File(ls_file);
						if(dFile.exists()){
							boolean tf = dFile.delete();
							String tf_name = "";
							if(tf){
								tf_name = "清除目录文件成功";
							}else{
								tf_name = "清除目录文件失败,可能文件被占";
							}
							System.out.println(tf_name+":"+ls_file);
							sysbusiness.insert_logBusiness("deleteTrueStorePersonal", "" + ls_file,
									tf_name, delete_m.get("UUID").toString(), (String)delete_m.get("FILE_NAME"),"storePersonal");
							
						}
					}
				}
				//
			}
			//处理个人开盘信息的已用容量
			String current_user = "";
			int del_size = 0;
			for(Map<String, Object> delete_m:listData){
				if(StringUtils.isEmpty(current_user)){
					current_user = (String) delete_m.get("CREATOR_ID");
				}
				int file_size = (Integer) delete_m.get("FILE_SIZE");
				del_size = del_size + file_size;	
			}
			if(del_size>0){
				if(StringUtils.isEmpty(current_user)){
					current_user = SessionUtil.getCode();
				}
				StoreUserBusiness business_storeuser = BusinessManager.getBusiness(StoreUserBusiness.class);
				Map<String,Object> storeuser_query = new HashMap<String,Object>();
				storeuser_query.put("USER_ID",current_user);
				List<Map<String,Object>> storeuser = business_storeuser.list_user(storeuser_query);
				if(storeuser.size()>0){
					Map<String,Object> udata = storeuser.get(0);
				    int c_size = (Integer) udata.get("USE_SIZE");
				    c_size = c_size - del_size;
				    udata.put("USE_SIZE", c_size);
				    //
				    udata.remove("ID_NUMBER");
				    udata.remove("USER_NAME");
				    udata.remove("CREATE_NAME");
				    //
				    business_storeuser.update_user(udata);
				}
			}
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 根据条件清空大字段文件和加载大字段文件
	 * @param entity
	 * @throws BusinessException
	 */
	public String setStorePersonal() throws BusinessException {

		StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		List<String> setKeySuccess = new ArrayList<String>();
		String ls_setname = "";
		try {
			Map<String, Object> v_query = new HashMap<String,Object>();
			v_query.put("UUIDLIST", ListKey);
			List<Map<String, Object>> listData = business.list_storePersonalnofile(v_query);
			String ls_set = (String) entity.get("SETKEY");
			
			if(listData.size()>0){
				if(StringUtils.isNotEmpty(ls_set) && ls_set.equals("0")){
					ls_setname = "清空大数据字段文件";
					for(Map<String, Object> m:listData){
						if(m.get("ISFILE").toString().equals("0")) continue;
						String exist_file = (String)m.get("EXIST_FILE");
						if(exist_file.equals("1")){//清空大数据字段文件并写到文件上
							setKeySuccess.add((String)m.get("UUID"));
							String uuid = (String)m.get("UUID");
					    	String uploadnew = (String)m.get("FILE_SVAE_NAME");
							String uploadpath= (String)m.get("FILE_SAVE_PATH");
							db2fileStore(uuid,uploadpath,uploadnew,false);
						}
					}
					if(setKeySuccess.size()>0){
						business.setnull_binary_data(setKeySuccess);
					}
				}else if(StringUtils.isNotEmpty(ls_set) && ls_set.equals("1")){
					ls_setname = "往大数据字段保存文件";
					for(Map<String, Object> m:listData){
						if(m.get("ISFILE").toString().equals("0")) continue;
						String exist_file = (String)m.get("EXIST_FILE");
						if(exist_file.equals("1")) continue;
						//处理上传文件保存到数据库
						if(m.get("FILE_SAVE_PATH")!=null && m.get("FILE_SVAE_NAME")!=null){
							String uploadFile  = (String)m.get("FILE_SAVE_PATH")+File.separator+(String)m.get("FILE_SVAE_NAME");
							FileUtil fileUtil = new FileUtil();
							File f = new File(uploadFile);
							if(f.isFile()){
								m.put("BINARY_DATA", fileUtil.getBytes(fileUtil.getInputStream(uploadFile)));
								m.remove("CREATE_NAME");
								m.remove("UPDATE_NAME");
								m.remove("EXIST_FILE");
								m.remove("FILENUMBER");
								setKeySuccess.add((String)m.get("UUID"));
								business.update_storePersonal(m);
							}
						}
						
					}
				}
			}
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("setStore"+ls_set, "" + ListKey+",处理网盘公司文件("+setKeySuccess+")",
					ls_setname, deletekey, "多个流水号","storePersonal");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage(ls_setname+"成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage(ls_setname+"失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	
	public String upload() throws BusinessException{
		String savePath = "";
		if(StringUtils.isEmpty(savePath)) savePath =  AuthenticateUtil.getEndpoint("uploadPath");
		if(StringUtils.isEmpty(savePath))savePath = request.getSession().getServletContext().getRealPath("/uploadFile/file/");
		try {
			savePath = setFilepath(savePath, true);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.setUserUploadFilePath(savePath);
		super.upload();
		String ret = super.getUserUploadFileResult();
		// 操作日志
		SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		sysbusiness.insert_logBusiness("upload", "用户["+SessionUtil.getEmname()+"]上传网盘公司文件:"+ret,
				"上传文件", ret, "上传文件："+super.getUserFileFileName(),"storePersonal");
		//
		return null;
    }
	
	/**
	 * 路径下有文件从路径中下载，没有则从库里写到路径中再下载
	 * @param entity
	 * @throws BusinessException
	 */
	public String download() throws BusinessException{
    	String ret_download ="";
    	String uuid = request.getParameter("uuid");
    	String uploadnew=request.getParameter("uploadnew");
		String uploadpath=request.getParameter("uploadpath");
//		String downloadFilenameEncode1 = PropUtil.getValue("downloadFilenameEncode1", "quartz_service", "gbk");
//		String downloadFilenameEncode2 = PropUtil.getValue("downloadFilenameEncode2", "quartz_service", "iso8859-1");
//		super.setEncoding1(downloadFilenameEncode1);
//		super.setEncoding2(downloadFilenameEncode2);
		response.setCharacterEncoding("utf-8");
		if(new File(uploadpath+File.separator+uploadnew).exists()==false){
			db2fileStore(uuid,uploadpath,uploadnew,false);
			ret_download = super.download();
		}else{
			ret_download = super.download();
		}
		
		String filename1 = RequestUtils.getString(request, "uploadold");
		try {
			filename1 = new String(filename1.getBytes("ISO-8859-1"),"UTF-8");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// 操作日志
		SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		sysbusiness.insert_logBusiness("download", "用户["+SessionUtil.getEmname()+"]下载网盘公司文件："+ uploadpath+File.separator+uploadnew,
				"下载文件",uploadpath+File.separator+uploadnew,filename1,"storePersonal");
		//
    	return ret_download;
    }
	
	/**
	 * 共享文件操作
	 * @param entity
	 * @throws BusinessException
	 */
	public String shareStorePersonal() throws BusinessException {
		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);	
			//去除不要更新的字段
			entity.remove("OPETYPE");
			String file_uuid = (String) entity.get("CODE");
			String file_userid = (String) entity.get("USER_ID");
			if(StringUtils.isNotEmpty(file_uuid) && StringUtils.isNotEmpty(file_userid)){
				for(String fileid:file_uuid.split(",")){
					for(String userid:file_userid.split(",")){
						Map<String,Object> isData = new HashMap<String,Object>();
						isData.put("FILE_UUID", fileid);
						isData.put("SHARE_ID", userid);
						int listOldCount = business.listCount_share(isData);
						if(listOldCount==0){
							//新增
							business.insert_share(isData);
							// 操作日志
							SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
								sysbusiness.insert_logBusiness("shareStorePersonal", "" + entity,
										"增加个人文件共享", (String) entity.get("UUID"), (String) entity
												.get("FILE_NAME"), "storePersonal");
							//
						}
					}
				}
					
				jsonObject.putAll(Status.getStatusSuccessMessage("共享成功"));
			}else{
				jsonObject.putAll(Status.getStatusSuccessMessage("共享失败,参数不全"));
			}
			
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("共享失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 分享文件操作
	 * @param entity
	 * @throws BusinessException
	 */
	public String partookStorePersonal() throws BusinessException {

		StorePartookBusiness business = BusinessManager.getBusiness(StorePartookBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);	
			//去除不要更新的字段
			entity.remove("OPETYPE");
			String file_uuid = (String) entity.get("CODE");
			String fx_pass = (String) entity.get("PARTOOK_PASS");
			String fx_code = (String) entity.get("PARTOOK_CODE");
			
			//处理时间的有效性
			int fx_time = Integer.parseInt(request.getParameter("LIMIT_TIME"));							
			
			if(StringUtils.isNotEmpty(file_uuid) && StringUtils.isNotEmpty(fx_pass)){
				//先判断下文件是否已经分享过了,如果分享过了,则这次分享操作不执行
				Boolean shareFlag = false ;
				for(String fileid:file_uuid.split(",")){
					Map<String,Object> iData = new HashMap<String,Object>();
					iData.put("FILE_UUID", fileid);
					int listOldCount = business.listCount_partook(iData);
					if(listOldCount!=0){
						shareFlag = true;
						break;
					}
				}
				if(shareFlag==false){
					for(String fileid:file_uuid.split(",")){
						Map<String,Object> iData = new HashMap<String,Object>();
						iData.put("FILE_UUID", fileid);
						iData.put("PARTOOK_CODE", fx_code);
						iData.put("PARTOOK_PASS", fx_pass);

						//处理失效时间
						Date date = new Date();
						Date limit_date = new Date();
						Calendar calendar = new GregorianCalendar();
						calendar.setTime(date);	
						switch (fx_time) {
						//0或者默认表示永久,1表示7天,2表示一天
						case 1:
							calendar.add(calendar.DATE,7);//把日期往后增加一天.整数往后推,负数往前移动 
							limit_date=calendar.getTime();						
							break;
						case 2:
							calendar.add(calendar.DATE,1);//把日期往后增加一天.整数往后推,负数往前移动 
							limit_date=calendar.getTime();
							break;
						default:
							break;
						}
						iData.put("CREATE_TIME", date);
						iData.put("PARTOOK_TIME", limit_date);

						//新增
						business.insert_partook(iData);
						// 操作日志
						SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
							sysbusiness.insert_logBusiness("partookStorePersonal", "" + entity,
									"增加个人文件分享", (String) entity.get("UUID"), (String) entity
											.get("FILE_NAME"), "storePersonal");
						//
					}
					jsonObject.putAll(Status.getStatusSuccessMessage("分享成功"));
				}
				else{
					jsonObject.putAll(Status.getStatusSuccessMessage("存在已经分享过的文件/文件夹"));
				}
			}else{
				jsonObject.putAll(Status.getStatusSuccessMessage("分享失败,参数不全"));
			}
			
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("分享失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	private void db2fileStore(String uuid,String uploadpath,String uploadnew,boolean isDelete){
	    StorePersonalBusiness business = BusinessManager.getBusiness(StorePersonalBusiness.class);
	    Map<String, Object> mapquery = new HashMap<String, Object>();
        mapquery.put("UUID", uuid);
        List<Map<String, Object>> list = business.list_storePersonal(mapquery);
        BufferedInputStream bis = null;       
		try {
			if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof byte[]){
		    	   byte[] b = (byte[]) list.get(0).get("BINARY_DATA");
		    	   bis = new BufferedInputStream(new ByteArrayInputStream(b));
	        }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof Blob){
	    	   Blob b = (Blob)list.get(0).get("BINARY_DATA");
	    	   try {
				bis = new BufferedInputStream(b.getBinaryStream());
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	       }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof String){
	    	   String b = (String)list.get(0).get("BINARY_DATA");
	    	   bis = new BufferedInputStream(new ByteArrayInputStream(b.getBytes())); 
	       }else if(list.get(0).get("BINARY_DATA")!=null && list.get(0).get("BINARY_DATA") instanceof oracle.sql.BLOB){
	        	oracle.sql.BLOB filedata = (BLOB) list.get(0).get("BINARY_DATA");
	        	bis = new BufferedInputStream(filedata.getBinaryStream());
	        }
			File dir = new File(uploadpath);
			if (!dir.exists()) {
			    dir.mkdirs();
			}
			if(bis == null) bis = new BufferedInputStream(new ByteArrayInputStream("文件读取出错!".getBytes()));
			File tempfile = new File(uploadpath+File.separator+uploadnew);
			FileOutputStream fio =new FileOutputStream(tempfile);
			IOUtils.copy(bis, fio);
			IOUtils.closeQuietly(bis);
			IOUtils.closeQuietly(fio);
			if(isDelete)tempfile.delete();
		}catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private String setFilepath(String sourcepath,boolean tf)throws Exception{
		String destpath = "";
		if(StringUtils.isEmpty(sourcepath)||StringUtils.equalsIgnoreCase(sourcepath, "UUID"))
			sourcepath = PropUtil.getValue("uploadPath","quartz_service","");
		Calendar date=Calendar.getInstance();
		SimpleDateFormat format1=new SimpleDateFormat("yyyy"); 
		SimpleDateFormat format2=new SimpleDateFormat("MM");
		SimpleDateFormat format3=new SimpleDateFormat("dd");
		String name1=format1.format(date.getTime());
		String name2=format2.format(date.getTime());
		String name3=format3.format(date.getTime());
		destpath = sourcepath+"store"+File.separator+name1+File.separator+name2+File.separator+name3;
		if(tf){
			File fileDir=new File(destpath);
			if(!fileDir.exists()){
				fileDir.mkdirs();
			}
		}
		return destpath;
	}

}
